/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.SmartList;
import com.intellij.util.io.CharSequenceBackedByChars;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0010\u0012\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0002*\u00020\u0002\u001a\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0006\u001a\u0012\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u0014\u0010\t\u001a\u00020\u0001*\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"decodeBase64", "", "", "encodeUrlQueryParameter", "readCharSequence", "", "Ljava/io/InputStreamReader;", "length", "", "toByteArray", "Ljava/nio/ByteBuffer;", "isClear", "", "intellij.platform.projectModel"})
public final class IoKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final CharSequence readCharSequence(@NotNull InputStreamReader $receiver, int length) {
        Closeable closeable = $receiver;
        Throwable throwable = null;
        try {
            int count;
            int n;
            InputStreamReader it = (InputStreamReader)closeable;
            boolean bl = false;
            char[] chars = new char[length];
            for (count = 0; count < chars.length && (n = $receiver.read(chars, count, chars.length - count)) > 0; count += n) {
            }
            CharSequence charSequence = (CharSequence)((Object)new CharSequenceBackedByChars(chars, 0, count));
            return charSequence;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @NotNull
    public static final CharSequence readCharSequence(@NotNull InputStreamReader $receiver) {
        int n;
        char[] chars = new char[8192];
        List buffers = null;
        int count = 0;
        int total = 0;
        while ((n = $receiver.read(chars, count, chars.length - count)) > 0) {
            total += n;
            if ((count += n) != chars.length) continue;
            if (buffers == null) {
                buffers = (List)new SmartList();
            }
            buffers.add(chars);
            int newLength = Math.min(0x100000, chars.length * 2);
            chars = new char[newLength];
            count = 0;
        }
        if (buffers == null) {
            return (CharSequence)((Object)new CharSequenceBackedByChars(chars, 0, total));
        }
        char[] result2 = new char[total];
        for (char[] buffer : buffers) {
            System.arraycopy(buffer, 0, result2, result2.length - total, buffer.length);
            total -= buffer.length;
        }
        System.arraycopy(chars, 0, result2, result2.length - total, total);
        return (CharSequence)((Object)new CharSequenceBackedByChars(result2));
    }

    @NotNull
    public static final byte[] toByteArray(@NotNull ByteBuffer $receiver, boolean isClear) {
        if ($receiver.hasArray()) {
            int offset = $receiver.arrayOffset();
            byte[] array = $receiver.array();
            if (offset == 0 && array.length == $receiver.limit()) {
                return array;
            }
            byte[] byArray = array;
            int n = offset + $receiver.limit();
            byte[] result2 = ArraysKt.copyOfRange((byte[])byArray, (int)offset, (int)n);
            if (isClear) {
                ArraysKt.fill$default((byte[])array, (byte)0, (int)0, (int)0, (int)6, null);
            }
            return result2;
        }
        byte[] bytes = new byte[$receiver.limit()];
        $receiver.get(bytes);
        return bytes;
    }

    @NotNull
    public static /* synthetic */ byte[] toByteArray$default(ByteBuffer byteBuffer, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return IoKt.toByteArray(byteBuffer, bl);
    }

    @NotNull
    public static final String encodeUrlQueryParameter(@NotNull String $receiver) {
        String string = URLEncoder.encode($receiver, Charsets.UTF_8.name());
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return string;
    }

    @NotNull
    public static final byte[] decodeBase64(@NotNull String $receiver) {
        return Base64.getDecoder().decode($receiver);
    }
}

