/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ui.AnimatedIcon;
import com.intellij.util.ui.AnimatedIcon;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class AsyncProcessIcon
extends AnimatedIcon {
    private static final Icon[] SMALL_ICONS = AnimatedIcon.Default.ICONS.toArray(new Icon[0]);
    public static final int COUNT = SMALL_ICONS.length;
    public static final int CYCLE_LENGTH = 130 * SMALL_ICONS.length;

    public AsyncProcessIcon(@NonNls String name) {
        this(name, SMALL_ICONS, AllIcons.Process.Step_passive);
    }

    public AsyncProcessIcon(@NonNls String name, Icon[] icons, Icon passive) {
        super(name, icons, passive, CYCLE_LENGTH);
    }

    @Deprecated
    public AsyncProcessIcon setUseMask(boolean useMask) {
        return this;
    }

    @Override
    protected void paintIcon(Graphics g, Icon icon, int x, int y) {
        super.paintIcon(g, icon, x, y);
    }

    public void updateLocation(JComponent container) {
        Rectangle newBounds = this.calculateBounds(container);
        if (!newBounds.equals(this.getBounds())) {
            this.setBounds(newBounds);
            SwingUtilities.invokeLater(() -> container.repaint());
        }
    }

    @NotNull
    protected Rectangle calculateBounds(@NotNull JComponent container) {
        Rectangle rec = container.getVisibleRect();
        Dimension iconSize = this.getPreferredSize();
        return new Rectangle(rec.x + rec.width - iconSize.width, rec.y, iconSize.width, iconSize.height);
    }

    public boolean isDisposed() {
        return this.myAnimator.isDisposed();
    }

    public static class Big
    extends AsyncProcessIcon {
        private static final Icon[] BIG_ICONS = AnimatedIcon.Big.ICONS.toArray(new Icon[0]);

        public Big(@NonNls String name) {
            super(name, BIG_ICONS, AllIcons.Process.Big.Step_passive);
        }
    }
}

