/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.ui.ClickListener;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.UIBundle;
import com.intellij.ui.components.JBViewport;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StatusText {
    public static final SimpleTextAttributes DEFAULT_ATTRIBUTES = SimpleTextAttributes.GRAYED_ATTRIBUTES;
    public static final String DEFAULT_EMPTY_TEXT = UIBundle.message((String)"message.nothingToShow", (Object[])new Object[0]);
    private static final int Y_GAP = 2;
    @Nullable
    private Component myOwner;
    private Component myMouseTarget;
    @NotNull
    private final MouseMotionListener myMouseMotionListener;
    @NotNull
    private final ClickListener myClickListener;
    private boolean myIsDefaultText;
    private String myText = "";
    @NotNull
    protected final SimpleColoredComponent myComponent = new SimpleColoredComponent();
    @NotNull
    private final SimpleColoredComponent mySecondaryComponent = new SimpleColoredComponent();
    private final List<ActionListener> myClickListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final List<ActionListener> mySecondaryListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private boolean myHasActiveClickListeners;
    private boolean myShowAboveCenter = true;
    private boolean myVerticalFlow = true;
    private boolean myFontSet = false;

    protected StatusText(JComponent owner) {
        this();
        this.attachTo(owner);
    }

    public StatusText() {
        this.myClickListener = new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                ActionListener actionListener;
                if (e.getButton() == 1 && clickCount == 1 && (actionListener = StatusText.this.findActionListenerAt(e.getPoint())) != null) {
                    actionListener.actionPerformed(new ActionEvent((Object)this, 0, ""));
                    return true;
                }
                return false;
            }
        };
        this.myMouseMotionListener = new MouseAdapter(){
            private Cursor myOriginalCursor;

            @Override
            public void mouseMoved(MouseEvent e) {
                if (StatusText.this.isStatusVisible()) {
                    if (StatusText.this.findActionListenerAt(e.getPoint()) != null) {
                        if (this.myOriginalCursor == null) {
                            this.myOriginalCursor = StatusText.this.myMouseTarget.getCursor();
                            StatusText.this.myMouseTarget.setCursor(Cursor.getPredefinedCursor(12));
                        }
                    } else if (this.myOriginalCursor != null) {
                        StatusText.this.myMouseTarget.setCursor(this.myOriginalCursor);
                        this.myOriginalCursor = null;
                    }
                }
            }
        };
        this.myComponent.setOpaque(false);
        this.myComponent.setFont(UIUtil.getLabelFont());
        this.setText(DEFAULT_EMPTY_TEXT, DEFAULT_ATTRIBUTES);
        this.myIsDefaultText = true;
        this.mySecondaryComponent.setOpaque(false);
        this.mySecondaryComponent.setFont(UIUtil.getLabelFont());
    }

    protected boolean isFontSet() {
        return this.myFontSet;
    }

    public void setFont(@NotNull Font font) {
        this.myComponent.setFont(font);
        this.mySecondaryComponent.setFont(font);
        this.myFontSet = true;
    }

    public void attachTo(@Nullable Component owner) {
        this.attachTo(owner, owner);
    }

    public void attachTo(@Nullable Component owner, @Nullable Component mouseTarget) {
        if (this.myMouseTarget != null) {
            this.myClickListener.uninstall(this.myMouseTarget);
            this.myMouseTarget.removeMouseMotionListener(this.myMouseMotionListener);
        }
        this.myOwner = owner;
        this.myMouseTarget = mouseTarget;
        if (this.myMouseTarget != null) {
            this.myClickListener.installOn(this.myMouseTarget);
            this.myMouseTarget.addMouseMotionListener(this.myMouseMotionListener);
        }
    }

    protected abstract boolean isStatusVisible();

    @Nullable
    private static ActionListener findListener(@NotNull SimpleColoredComponent component, @NotNull List<ActionListener> listeners, int xCoord) {
        int index2 = component.findFragmentAt(xCoord);
        if (index2 >= 0 && index2 < listeners.size()) {
            return listeners.get(index2);
        }
        return null;
    }

    @Nullable
    private ActionListener findActionListenerAt(Point point) {
        if (!this.myHasActiveClickListeners || !this.isStatusVisible()) {
            return null;
        }
        point = SwingUtilities.convertPoint(this.myMouseTarget, point, this.myOwner);
        Rectangle commonBounds = this.getTextComponentBound();
        if (commonBounds.contains(point)) {
            if (this.myComponent.getPreferredSize().height >= point.y - commonBounds.y) {
                Rectangle bounds = this.adjustComponentBounds(this.myComponent, commonBounds);
                return StatusText.findListener(this.myComponent, this.myClickListeners, point.x - bounds.x);
            }
            Rectangle bounds = this.adjustComponentBounds(this.mySecondaryComponent, commonBounds);
            return StatusText.findListener(this.mySecondaryComponent, this.mySecondaryListeners, point.x - bounds.x);
        }
        return null;
    }

    protected Rectangle getTextComponentBound() {
        Rectangle ownerRec = this.myOwner == null ? new Rectangle(0, 0, 0, 0) : this.myOwner.getBounds();
        Dimension size = this.getPreferredSize();
        int x = (ownerRec.width - size.width) / 2;
        int y = (ownerRec.height - size.height) / (this.myShowAboveCenter ? 3 : 2);
        return new Rectangle(x, y, size.width, size.height);
    }

    public final boolean isShowAboveCenter() {
        return this.myShowAboveCenter;
    }

    public final StatusText setShowAboveCenter(boolean showAboveCenter) {
        this.myShowAboveCenter = showAboveCenter;
        return this;
    }

    @NotNull
    public String getText() {
        return this.myText;
    }

    public StatusText setText(String text) {
        return this.setText(text, DEFAULT_ATTRIBUTES);
    }

    public StatusText setText(String text, SimpleTextAttributes attrs) {
        return this.clear().appendText(text, attrs);
    }

    public StatusText clear() {
        this.myText = "";
        this.myComponent.clear();
        this.myClickListeners.clear();
        this.mySecondaryComponent.clear();
        this.mySecondaryListeners.clear();
        this.myHasActiveClickListeners = false;
        this.repaintOwner();
        return this;
    }

    private void repaintOwner() {
        if (this.myOwner != null && this.isStatusVisible()) {
            this.myOwner.repaint();
        }
    }

    public StatusText appendText(String text) {
        return this.appendText(text, DEFAULT_ATTRIBUTES);
    }

    public StatusText appendText(String text, SimpleTextAttributes attrs) {
        return this.appendText(text, attrs, null);
    }

    public StatusText appendText(String text, SimpleTextAttributes attrs, ActionListener listener) {
        if (this.myIsDefaultText) {
            this.clear();
            this.myIsDefaultText = false;
        }
        this.myText = this.myText + text;
        this.myComponent.append(text, attrs);
        this.myClickListeners.add(listener);
        if (listener != null) {
            this.myHasActiveClickListeners = true;
        }
        this.repaintOwner();
        return this;
    }

    public void setIsVerticalFlow(boolean isVerticalFlow) {
        this.myVerticalFlow = isVerticalFlow;
    }

    @NotNull
    public StatusText appendSecondaryText(@NotNull String text, @NotNull SimpleTextAttributes attrs, @Nullable ActionListener listener) {
        this.mySecondaryComponent.append(text, attrs);
        this.mySecondaryListeners.add(listener);
        if (listener != null) {
            this.myHasActiveClickListeners = true;
        }
        this.repaintOwner();
        return this;
    }

    public void paint(Component owner, Graphics g) {
        if (!this.isStatusVisible()) {
            return;
        }
        if (owner == this.myOwner) {
            this.doPaintStatusText(g, this.getTextComponentBound());
        } else {
            this.paintOnComponentUnderViewport(owner, g);
        }
    }

    private void paintOnComponentUnderViewport(Component component, Graphics g) {
        JBViewport viewport = (JBViewport)ObjectUtils.tryCast((Object)this.myOwner, JBViewport.class);
        if (viewport == null || viewport.getView() != component || viewport.isPaintingNow()) {
            return;
        }
        Rectangle textBoundsInViewport = this.getTextComponentBound();
        int xInOwner = textBoundsInViewport.x - component.getX();
        int yInOwner = textBoundsInViewport.y - component.getY();
        Rectangle textBoundsInOwner = new Rectangle(xInOwner, yInOwner, textBoundsInViewport.width, textBoundsInViewport.height);
        this.doPaintStatusText(g, textBoundsInOwner);
        viewport.repaint(textBoundsInViewport);
    }

    private void doPaintStatusText(@NotNull Graphics g, @NotNull Rectangle bounds) {
        if (!this.hasSecondaryText()) {
            StatusText.paintComponentInBounds(this.myComponent, g, bounds);
        } else {
            Rectangle primaryBounds = this.adjustComponentBounds(this.myComponent, bounds);
            Rectangle secondaryBounds = this.adjustComponentBounds(this.mySecondaryComponent, bounds);
            if (this.myVerticalFlow) {
                secondaryBounds.y += primaryBounds.height + JBUI.scale((int)2);
            }
            StatusText.paintComponentInBounds(this.myComponent, g, primaryBounds);
            StatusText.paintComponentInBounds(this.mySecondaryComponent, g, secondaryBounds);
        }
    }

    @NotNull
    protected Rectangle adjustComponentBounds(@NotNull JComponent component, @NotNull Rectangle bounds) {
        Dimension size = component.getPreferredSize();
        if (this.myVerticalFlow) {
            return new Rectangle(bounds.x + (bounds.width - size.width) / 2, bounds.y, size.width, size.height);
        }
        return component == this.myComponent ? new Rectangle(bounds.x, bounds.y, size.width, size.height) : new Rectangle(bounds.x + bounds.width - size.width, bounds.y, size.width, size.height);
    }

    private boolean hasSecondaryText() {
        return this.mySecondaryComponent.getCharSequence(false).length() > 0;
    }

    private static void paintComponentInBounds(@NotNull SimpleColoredComponent component, @NotNull Graphics g, @NotNull Rectangle bounds) {
        Graphics2D g2 = (Graphics2D)g.create(bounds.x, bounds.y, bounds.width, bounds.height);
        component.setBounds(0, 0, bounds.width, bounds.height);
        component.paint(g2);
        g2.dispose();
    }

    @NotNull
    public SimpleColoredComponent getComponent() {
        return this.myComponent;
    }

    @NotNull
    public SimpleColoredComponent getSecondaryComponent() {
        return this.mySecondaryComponent;
    }

    public Dimension getPreferredSize() {
        Dimension componentSize = this.myComponent.getPreferredSize();
        if (!this.hasSecondaryText()) {
            return componentSize;
        }
        Dimension secondaryComponentSize = this.mySecondaryComponent.getPreferredSize();
        if (this.myVerticalFlow) {
            return new Dimension(Math.max(componentSize.width, secondaryComponentSize.width), componentSize.height + secondaryComponentSize.height + JBUI.scale((int)2));
        }
        return new Dimension(componentSize.width + secondaryComponentSize.width, Math.max(componentSize.height, secondaryComponentSize.height));
    }

    public boolean isVerticalFlow() {
        return this.myVerticalFlow;
    }
}

