/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.tree;

import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Range;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.TreeTraversal;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.IndexTreePathState;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public final class TreeUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.ui.tree.TreeUtil");
    private static final String TREE_UTIL_SCROLL_TIME_STAMP = "TreeUtil.scrollTimeStamp";
    private static final JBIterable<Integer> NUMBERS = JBIterable.generate((Object)0, i -> i + 1);

    private TreeUtil() {
    }

    @NotNull
    public static JBTreeTraverser<Object> treeTraverser(@NotNull JTree tree) {
        TreeModel model = tree.getModel();
        Object root = model.getRoot();
        return (JBTreeTraverser)JBTreeTraverser.from(node -> TreeUtil.nodeChildren(node, model)).withRoot(root);
    }

    @NotNull
    public static JBTreeTraverser<TreePath> treePathTraverser(@NotNull JTree tree) {
        TreeModel model = tree.getModel();
        Object root = model.getRoot();
        TreePath rootPath = root == null ? null : new TreePath(root);
        return (JBTreeTraverser)JBTreeTraverser.from(path2 -> TreeUtil.nodeChildren(path2.getLastPathComponent(), model).map(o -> path2.pathByAddingChild(o))).withRoot((Object)rootPath);
    }

    @NotNull
    public static JBIterable<Object> nodeChildren(@Nullable Object node, @NotNull TreeModel model) {
        int count = model.getChildCount(node);
        return count == 0 ? JBIterable.empty() : NUMBERS.take(count).map(index2 -> model.getChild(node, (int)index2));
    }

    @NotNull
    public static JBTreeTraverser<TreeNode> treeNodeTraverser(@Nullable TreeNode treeNode) {
        return (JBTreeTraverser)JBTreeTraverser.from(node -> TreeUtil.nodeChildren(node)).withRoot((Object)treeNode);
    }

    @NotNull
    public static JBIterable<TreeNode> nodeChildren(@Nullable TreeNode treeNode) {
        int count = treeNode == null ? 0 : treeNode.getChildCount();
        return count == 0 ? JBIterable.empty() : NUMBERS.take(count).map(index2 -> treeNode.getChildAt((int)index2));
    }

    @NotNull
    public static List<TreePath> collectExpandedPaths(@NotNull JTree tree) {
        return TreeUtil.collectExpandedObjects(tree, Function.identity());
    }

    @NotNull
    public static List<Object> collectExpandedUserObjects(@NotNull JTree tree) {
        return TreeUtil.collectExpandedObjects(tree, TreeUtil::getLastUserObject);
    }

    @NotNull
    public static <T> List<T> collectExpandedObjects(@NotNull JTree tree, @NotNull Function<? super TreePath, ? extends T> mapper) {
        return TreeUtil.collectVisibleRows(tree, tree::isExpanded, mapper);
    }

    @Nullable
    public static <T> T findObjectInPath(@Nullable TreePath path2, @NotNull Class<T> clazz) {
        while (path2 != null) {
            T object = TreeUtil.getLastUserObject(clazz, path2);
            if (object != null) {
                return object;
            }
            path2 = path2.getParentPath();
        }
        return null;
    }

    @NotNull
    public static <T> List<T> collectSelectedObjectsOfType(@NotNull JTree tree, @NotNull Class<? extends T> type) {
        return TreeUtil.collectSelectedObjects(tree, path2 -> TreeUtil.getLastUserObject(type, path2));
    }

    @NotNull
    public static List<TreePath> collectExpandedPaths(@NotNull JTree tree, @NotNull TreePath root) {
        return TreeUtil.collectExpandedObjects(tree, root, Function.identity());
    }

    @NotNull
    public static List<Object> collectExpandedUserObjects(@NotNull JTree tree, @NotNull TreePath root) {
        return TreeUtil.collectExpandedObjects(tree, root, TreeUtil::getLastUserObject);
    }

    @NotNull
    public static <T> List<T> collectExpandedObjects(@NotNull JTree tree, @NotNull TreePath root, @NotNull Function<? super TreePath, ? extends T> mapper) {
        if (!tree.isVisible(root)) {
            return Collections.emptyList();
        }
        return TreeUtil.collectVisibleRows(tree, path2 -> tree.isExpanded((TreePath)path2) && root.isDescendant((TreePath)path2), mapper);
    }

    public static void restoreExpandedPaths(@NotNull JTree tree, @NotNull List<? extends TreePath> paths) {
        for (int i = paths.size() - 1; i >= 0; --i) {
            tree.expandPath(paths.get(i));
        }
    }

    @NotNull
    public static TreePath getPath(@NotNull TreeNode aRootNode, @NotNull TreeNode aNode) {
        Object[] nodes = TreeUtil.getPathFromRootTo(aRootNode, aNode, true);
        return new TreePath(nodes);
    }

    public static boolean isAncestor(@NotNull TreeNode ancestor, @NotNull TreeNode node) {
        for (TreeNode parent = node; parent != null; parent = parent.getParent()) {
            if (parent != ancestor) continue;
            return true;
        }
        return false;
    }

    private static boolean isAncestor(@NotNull TreePath ancestor, @NotNull TreePath path2) {
        if (path2.getPathCount() < ancestor.getPathCount()) {
            return false;
        }
        for (int i = 0; i < ancestor.getPathCount(); ++i) {
            if (path2.getPathComponent(i).equals(ancestor.getPathComponent(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isDescendants(@NotNull TreePath path2, @NotNull TreePath[] paths) {
        for (TreePath ancestor : paths) {
            if (!TreeUtil.isAncestor(ancestor, path2)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static TreePath getPathFromRoot(@NotNull TreeNode node) {
        Object[] path2 = TreeUtil.getPathFromRootTo(null, node, false);
        return new TreePath(path2);
    }

    @NotNull
    private static TreeNode[] getPathFromRootTo(@Nullable TreeNode root, @NotNull TreeNode node, boolean includeRoot) {
        int height = 0;
        for (TreeNode n = node; n != root; n = n.getParent()) {
            ++height;
        }
        TreeNode[] path2 = new TreeNode[includeRoot ? height + 1 : height];
        int i = path2.length - 1;
        TreeNode n = node;
        while (i >= 0) {
            path2[i--] = n;
            n = n.getParent();
        }
        return path2;
    }

    @Nullable
    public static TreeNode findNodeWithObject(Object object, @NotNull TreeModel model, Object parent) {
        for (int i = 0; i < model.getChildCount(parent); ++i) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)model.getChild(parent, i);
            if (!childNode.getUserObject().equals(object)) continue;
            return childNode;
        }
        return null;
    }

    public static void removeSelected(@NotNull JTree tree) {
        TreePath[] paths = tree.getSelectionPaths();
        if (paths == null) {
            return;
        }
        for (TreePath path2 : paths) {
            TreeUtil.removeLastPathComponent((DefaultTreeModel)tree.getModel(), path2).restoreSelection(tree);
        }
    }

    public static void removeLastPathComponent(@NotNull JTree tree, @NotNull TreePath pathToBeRemoved) {
        TreeUtil.removeLastPathComponent((DefaultTreeModel)tree.getModel(), pathToBeRemoved).restoreSelection(tree);
    }

    @Nullable
    public static DefaultMutableTreeNode findNodeWithObject(@NotNull DefaultMutableTreeNode aRoot, Object aObject) {
        return TreeUtil.findNode(aRoot, (Condition<? super DefaultMutableTreeNode>)((Condition)node -> Comparing.equal((Object)node.getUserObject(), (Object)aObject)));
    }

    @Nullable
    public static DefaultMutableTreeNode findNode(@NotNull DefaultMutableTreeNode aRoot, @NotNull Condition<? super DefaultMutableTreeNode> condition) {
        if (condition.value((Object)aRoot)) {
            return aRoot;
        }
        for (int i = 0; i < aRoot.getChildCount(); ++i) {
            DefaultMutableTreeNode candidate = TreeUtil.findNode((DefaultMutableTreeNode)aRoot.getChildAt(i), condition);
            if (null == candidate) continue;
            return candidate;
        }
        return null;
    }

    @NotNull
    public static TreePath findCommonPath(@NotNull TreePath[] treePaths) {
        LOG.assertTrue(TreeUtil.areComponentsEqual(treePaths, 0));
        TreePath result2 = new TreePath(treePaths[0].getPathComponent(0));
        int pathIndex = 1;
        while (TreeUtil.areComponentsEqual(treePaths, pathIndex)) {
            result2 = result2.pathByAddingChild(treePaths[0].getPathComponent(pathIndex));
            ++pathIndex;
        }
        return result2;
    }

    @NotNull
    public static ActionCallback selectFirstNode(@NotNull JTree tree) {
        TreePath selectionPath = TreeUtil.getFirstNodePath(tree);
        return TreeUtil.selectPath(tree, selectionPath);
    }

    @NotNull
    public static TreePath getFirstNodePath(@NotNull JTree tree) {
        TreeModel model = tree.getModel();
        Object root = model.getRoot();
        TreePath selectionPath = new TreePath(root);
        if (!tree.isRootVisible() && model.getChildCount(root) > 0) {
            selectionPath = selectionPath.pathByAddingChild(model.getChild(root, 0));
        }
        return selectionPath;
    }

    @NotNull
    public static TreePath getFirstLeafNodePath(@NotNull JTree tree) {
        TreeModel model = tree.getModel();
        Object root = model.getRoot();
        TreePath selectionPath = new TreePath(root);
        while (model.getChildCount(root) > 0) {
            Object child = model.getChild(root, 0);
            selectionPath = selectionPath.pathByAddingChild(child);
            root = child;
        }
        return selectionPath;
    }

    @NotNull
    private static IndexTreePathState removeLastPathComponent(@NotNull DefaultTreeModel model, @NotNull TreePath pathToBeRemoved) {
        IndexTreePathState selectionState = new IndexTreePathState(pathToBeRemoved);
        if (((MutableTreeNode)pathToBeRemoved.getLastPathComponent()).getParent() == null) {
            return selectionState;
        }
        model.removeNodeFromParent((MutableTreeNode)pathToBeRemoved.getLastPathComponent());
        return selectionState;
    }

    private static boolean areComponentsEqual(@NotNull TreePath[] paths, int componentIndex) {
        if (paths[0].getPathCount() <= componentIndex) {
            return false;
        }
        Object pathComponent = paths[0].getPathComponent(componentIndex);
        for (TreePath treePath : paths) {
            if (treePath.getPathCount() <= componentIndex) {
                return false;
            }
            if (pathComponent.equals(treePath.getPathComponent(componentIndex))) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static TreePath[] removeDuplicates(@NotNull TreePath[] paths) {
        ArrayList<TreePath> result2 = new ArrayList<TreePath>();
        for (TreePath path2 : paths) {
            if (result2.contains(path2)) continue;
            result2.add(path2);
        }
        return result2.toArray(new TreePath[0]);
    }

    @NotNull
    public static TreePath[] selectMaximals(@Nullable TreePath[] paths) {
        if (paths == null) {
            return new TreePath[0];
        }
        TreePath[] noDuplicates = TreeUtil.removeDuplicates(paths);
        ArrayList<TreePath> result2 = new ArrayList<TreePath>();
        for (TreePath path2 : noDuplicates) {
            ArrayList<TreePath> otherPaths = new ArrayList<TreePath>(Arrays.asList(noDuplicates));
            otherPaths.remove(path2);
            if (TreeUtil.isDescendants(path2, otherPaths.toArray(new TreePath[0]))) continue;
            result2.add(path2);
        }
        return result2.toArray(new TreePath[0]);
    }

    public static void sort(@NotNull DefaultTreeModel model, @Nullable Comparator comparator) {
        TreeUtil.sort((DefaultMutableTreeNode)model.getRoot(), comparator);
    }

    public static void sort(@NotNull DefaultMutableTreeNode node, @Nullable Comparator comparator) {
        TreeUtil.sortRecursively(node, comparator);
    }

    public static <T extends MutableTreeNode> void sortRecursively(@NotNull T node, @Nullable Comparator<? super T> comparator) {
        TreeUtil.sortChildren(node, comparator);
        for (int i = 0; i < node.getChildCount(); ++i) {
            TreeUtil.sortRecursively((MutableTreeNode)node.getChildAt(i), comparator);
        }
    }

    public static <T extends MutableTreeNode> void sortChildren(@NotNull T node, @Nullable Comparator<? super T> comparator) {
        List<TreeNode> children = TreeUtil.listChildren(node);
        Collections.sort(children, comparator);
        for (int i = node.getChildCount() - 1; i >= 0; --i) {
            node.remove(i);
        }
        TreeUtil.addChildrenTo(node, children);
    }

    public static void addChildrenTo(@NotNull MutableTreeNode node, @NotNull List<? extends TreeNode> children) {
        for (TreeNode treeNode : children) {
            MutableTreeNode child = (MutableTreeNode)treeNode;
            node.insert(child, node.getChildCount());
        }
    }

    @Deprecated
    public static boolean traverse(@NotNull TreeNode node, @NotNull Traverse traverse) {
        return TreeUtil.treeNodeTraverser(node).traverse(TreeTraversal.POST_ORDER_DFS).processEach(traverse::accept);
    }

    @Deprecated
    public static boolean traverseDepth(@NotNull TreeNode node, @NotNull Traverse traverse) {
        return TreeUtil.treeNodeTraverser(node).traverse(TreeTraversal.PRE_ORDER_DFS).processEach(traverse::accept);
    }

    public static void selectPaths(@NotNull JTree tree, @NotNull Collection<? extends TreePath> paths) {
        if (paths.isEmpty()) {
            return;
        }
        TreeUtil.selectPaths(tree, paths.toArray(new TreePath[0]));
    }

    public static void selectPaths(@NotNull JTree tree, TreePath ... paths) {
        if (paths.length == 0) {
            return;
        }
        for (TreePath path2 : paths) {
            tree.makeVisible(path2);
        }
        tree.setSelectionPaths(paths);
        tree.scrollPathToVisible(paths[0]);
    }

    @NotNull
    public static ActionCallback selectPath(@NotNull JTree tree, TreePath path2) {
        return TreeUtil.selectPath(tree, path2, true);
    }

    @NotNull
    public static ActionCallback selectPath(@NotNull JTree tree, TreePath path2, boolean center) {
        tree.makeVisible(path2);
        if (center) {
            return TreeUtil.showRowCentred(tree, tree.getRowForPath(path2));
        }
        int row = tree.getRowForPath(path2);
        return TreeUtil.showAndSelect(tree, row - 2, row + 2, row, -1);
    }

    @NotNull
    public static ActionCallback moveDown(@NotNull JTree tree) {
        int size = tree.getRowCount();
        int row = tree.getLeadSelectionRow();
        if (row < size - 1) {
            return TreeUtil.showAndSelect(tree, ++row, row + 2, row, TreeUtil.getSelectedRow(tree), false, true, true);
        }
        return ActionCallback.DONE;
    }

    @NotNull
    public static ActionCallback moveUp(@NotNull JTree tree) {
        int row = tree.getLeadSelectionRow();
        if (row > 0) {
            return TreeUtil.showAndSelect(tree, --row - 2, row, row, TreeUtil.getSelectedRow(tree), false, true, true);
        }
        return ActionCallback.DONE;
    }

    @NotNull
    public static ActionCallback movePageUp(@NotNull JTree tree) {
        int visible = TreeUtil.getVisibleRowCount(tree);
        if (visible <= 0) {
            return TreeUtil.moveHome(tree);
        }
        int decrement = visible - 1;
        int row = Math.max(TreeUtil.getSelectedRow(tree) - decrement, 0);
        int top = TreeUtil.getFirstVisibleRow(tree) - decrement;
        int bottom = top + visible - 1;
        return TreeUtil.showAndSelect(tree, top, bottom, row, TreeUtil.getSelectedRow(tree));
    }

    @NotNull
    public static ActionCallback movePageDown(@NotNull JTree tree) {
        int visible = TreeUtil.getVisibleRowCount(tree);
        if (visible <= 0) {
            return TreeUtil.moveEnd(tree);
        }
        int size = tree.getRowCount();
        int increment = visible - 1;
        int index2 = Math.min(TreeUtil.getSelectedRow(tree) + increment, size - 1);
        int top = TreeUtil.getFirstVisibleRow(tree) + increment;
        int bottom = top + visible - 1;
        return TreeUtil.showAndSelect(tree, top, bottom, index2, TreeUtil.getSelectedRow(tree));
    }

    @NotNull
    private static ActionCallback moveHome(@NotNull JTree tree) {
        return TreeUtil.showRowCentred(tree, 0);
    }

    @NotNull
    private static ActionCallback moveEnd(@NotNull JTree tree) {
        return TreeUtil.showRowCentred(tree, tree.getRowCount() - 1);
    }

    @NotNull
    private static ActionCallback showRowCentred(@NotNull JTree tree, int row) {
        return TreeUtil.showRowCentered(tree, row, true);
    }

    @NotNull
    public static ActionCallback showRowCentered(@NotNull JTree tree, int row, boolean centerHorizontally) {
        return TreeUtil.showRowCentered(tree, row, centerHorizontally, true);
    }

    @NotNull
    public static ActionCallback showRowCentered(@NotNull JTree tree, int row, boolean centerHorizontally, boolean scroll) {
        int visible = TreeUtil.getVisibleRowCount(tree);
        int top = visible > 0 ? row - (visible - 1) / 2 : row;
        int bottom = visible > 0 ? top + visible - 1 : row;
        return TreeUtil.showAndSelect(tree, top, bottom, row, -1, false, scroll, false);
    }

    @NotNull
    public static ActionCallback showAndSelect(@NotNull JTree tree, int top, int bottom, int row, int previous) {
        return TreeUtil.showAndSelect(tree, top, bottom, row, previous, false);
    }

    @NotNull
    public static ActionCallback showAndSelect(@NotNull JTree tree, int top, int bottom, int row, int previous, boolean addToSelection) {
        return TreeUtil.showAndSelect(tree, top, bottom, row, previous, addToSelection, true, false);
    }

    @NotNull
    public static ActionCallback showAndSelect(@NotNull JTree tree, int top, int bottom, int row, int previous, boolean addToSelection, boolean scroll) {
        return TreeUtil.showAndSelect(tree, top, bottom, row, previous, addToSelection, scroll, false);
    }

    @NotNull
    public static ActionCallback showAndSelect(@NotNull JTree tree, int top, int bottom, int row, int previous, boolean addToSelection, boolean scroll, boolean resetSelection) {
        Rectangle bottomBounds;
        TreePath path2 = tree.getPathForRow(row);
        if (path2 == null) {
            return ActionCallback.DONE;
        }
        int size = tree.getRowCount();
        if (size == 0) {
            tree.clearSelection();
            return ActionCallback.DONE;
        }
        if (top < 0) {
            top = 0;
        }
        if (bottom >= size) {
            bottom = size - 1;
        }
        if (row >= tree.getRowCount()) {
            return ActionCallback.DONE;
        }
        boolean okToScroll = true;
        if (tree.isShowing()) {
            if (!tree.isValid()) {
                tree.validate();
            }
        } else {
            Application app = ApplicationManager.getApplication();
            if (app != null && app.isUnitTestMode()) {
                okToScroll = false;
            }
        }
        Runnable selectRunnable = () -> {
            if (!tree.isRowSelected(row)) {
                if (addToSelection) {
                    tree.getSelectionModel().addSelectionPath(tree.getPathForRow(row));
                } else {
                    tree.setSelectionRow(row);
                }
            } else if (resetSelection && !addToSelection) {
                tree.setSelectionRow(row);
            }
        };
        if (!okToScroll || !scroll) {
            selectRunnable.run();
            return ActionCallback.DONE;
        }
        Rectangle rowBounds = tree.getRowBounds(row);
        if (rowBounds == null) {
            return ActionCallback.DONE;
        }
        Rectangle topBounds = tree.getRowBounds(top);
        if (topBounds == null) {
            topBounds = rowBounds;
        }
        if ((bottomBounds = tree.getRowBounds(bottom)) == null) {
            bottomBounds = rowBounds;
        }
        Rectangle bounds = topBounds.union(bottomBounds);
        bounds.x = rowBounds.x;
        bounds.width = rowBounds.width;
        Rectangle visible = tree.getVisibleRect();
        if (visible.contains(bounds)) {
            selectRunnable.run();
            return ActionCallback.DONE;
        }
        Component comp = tree.getCellRenderer().getTreeCellRendererComponent(tree, path2.getLastPathComponent(), true, true, false, row, false);
        if (comp instanceof SimpleColoredComponent) {
            SimpleColoredComponent renderer = (SimpleColoredComponent)comp;
            Dimension scrollableSize = renderer.computePreferredSize(true);
            bounds.width = scrollableSize.width;
        }
        ActionCallback callback = new ActionCallback();
        selectRunnable.run();
        Range<Integer> range = TreeUtil.getExpandControlRange(tree, path2);
        if (range != null) {
            int delta = bounds.x - (Integer)range.getFrom();
            bounds.x -= delta;
            bounds.width -= delta;
        }
        if (visible.width < bounds.width) {
            bounds.width = visible.width;
        }
        if (tree instanceof Tree && !((Tree)tree).isHorizontalAutoScrollingEnabled()) {
            bounds.x = tree.getVisibleRect().x;
        }
        LOG.debug("tree scroll: ", new Object[]{path2});
        tree.scrollRectToVisible(bounds);
        Object property2 = tree.getClientProperty(TREE_UTIL_SCROLL_TIME_STAMP);
        long stamp = property2 instanceof Long ? (Long)property2 + 1L : Long.MIN_VALUE;
        tree.putClientProperty(TREE_UTIL_SCROLL_TIME_STAMP, stamp);
        int offset = rowBounds.y - bounds.y;
        AbstractTreeBuilder builder = AbstractTreeBuilder.getBuilderFor(tree);
        TreeUtil.scrollToVisible(tree, path2, bounds, offset, stamp, callback::setDone, builder, 3);
        return callback;
    }

    private static void scrollToVisible(JTree tree, TreePath path2, Rectangle bounds, int offset, long expected, Runnable done2, AbstractTreeBuilder builder, int attempt) {
        Runnable scroll = () -> {
            Rectangle pathBounds;
            Rectangle rectangle = pathBounds = attempt <= 0 ? null : tree.getPathBounds(path2);
            if (pathBounds != null) {
                Object property2 = tree.getClientProperty(TREE_UTIL_SCROLL_TIME_STAMP);
                long stamp = property2 instanceof Long ? (Long)property2 : Long.MAX_VALUE;
                LOG.debug("tree scroll ", new Object[]{attempt, stamp == expected ? ": try again: " : ": ignore: ", path2});
                if (stamp == expected) {
                    bounds.y = pathBounds.y - offset;
                    Rectangle visible = tree.getVisibleRect();
                    if (bounds.y < visible.y || bounds.y > visible.y + Math.max(0, visible.height - bounds.height)) {
                        tree.scrollRectToVisible(bounds);
                        TreeUtil.scrollToVisible(tree, path2, bounds, offset, expected, done2, builder, attempt - 1);
                        return;
                    }
                }
            }
            done2.run();
        };
        SwingUtilities.invokeLater(builder == null ? scroll : () -> builder.getReady(TreeUtil.class).doWhenDone(scroll));
    }

    private static int getSelectedRow(@NotNull JTree tree) {
        return tree.getRowForPath(tree.getSelectionPath());
    }

    private static int getFirstVisibleRow(@NotNull JTree tree) {
        Rectangle visible = tree.getVisibleRect();
        int row = -1;
        for (int i = 0; i < tree.getRowCount(); ++i) {
            Rectangle bounds = tree.getRowBounds(i);
            if (visible.y > bounds.y || visible.y + visible.height < bounds.y + bounds.height) continue;
            row = i;
            break;
        }
        return row;
    }

    public static int getVisibleRowCount(@NotNull JTree tree) {
        Rectangle visible = tree.getVisibleRect();
        if (visible == null) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < tree.getRowCount(); ++i) {
            Rectangle bounds = tree.getRowBounds(i);
            if (bounds == null || visible.y > bounds.y || visible.y + visible.height < bounds.y + bounds.height) continue;
            ++count;
        }
        return count;
    }

    public static int getVisibleRowCountForFixedRowHeight(@NotNull JTree tree) {
        Rectangle bounds = tree.getRowBounds(0);
        int rowHeight = bounds == null ? 0 : bounds.height;
        return rowHeight == 0 ? tree.getVisibleRowCount() : tree.getVisibleRect().height / rowHeight;
    }

    public static void installActions(final @NotNull JTree tree) {
        tree.getActionMap().put("scrollUpChangeSelection", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreeUtil.movePageUp(tree);
            }
        });
        tree.getActionMap().put("scrollDownChangeSelection", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreeUtil.movePageDown(tree);
            }
        });
        tree.getActionMap().put("selectPrevious", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreeUtil.moveUp(tree);
            }
        });
        tree.getActionMap().put("selectNext", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreeUtil.moveDown(tree);
            }
        });
        TreeUtil.copyAction(tree, "selectLast", "selectLastChangeLead");
        TreeUtil.copyAction(tree, "selectFirst", "selectFirstChangeLead");
        InputMap inputMap = tree.getInputMap(0);
        UIUtil.maybeInstall((InputMap)inputMap, (String)"scrollUpChangeSelection", (KeyStroke)KeyStroke.getKeyStroke(33, 0));
        UIUtil.maybeInstall((InputMap)inputMap, (String)"scrollDownChangeSelection", (KeyStroke)KeyStroke.getKeyStroke(34, 0));
        UIUtil.maybeInstall((InputMap)inputMap, (String)"selectNext", (KeyStroke)KeyStroke.getKeyStroke(40, 0));
        UIUtil.maybeInstall((InputMap)inputMap, (String)"selectPrevious", (KeyStroke)KeyStroke.getKeyStroke(38, 0));
        UIUtil.maybeInstall((InputMap)inputMap, (String)"selectLast", (KeyStroke)KeyStroke.getKeyStroke(35, 0));
        UIUtil.maybeInstall((InputMap)inputMap, (String)"selectFirst", (KeyStroke)KeyStroke.getKeyStroke(36, 0));
    }

    private static void copyAction(@NotNull JTree tree, String original, String copyTo) {
        Action action = tree.getActionMap().get(original);
        if (action != null) {
            tree.getActionMap().put(copyTo, action);
        }
    }

    public static void collapseAll(@NotNull JTree tree, int keepSelectionLevel) {
        TreePath leadSelectionPath = tree.getLeadSelectionPath();
        for (int row = tree.getRowCount() - 1; row >= 0; --row) {
            tree.collapseRow(row);
        }
        Object root = tree.getModel().getRoot();
        if (root != null && !tree.isRootVisible()) {
            tree.expandPath(new TreePath(root));
        }
        if (leadSelectionPath != null) {
            Object[] path2 = leadSelectionPath.getPath();
            Object[] pathToSelect = new Object[path2.length > keepSelectionLevel && keepSelectionLevel >= 0 ? keepSelectionLevel : path2.length];
            System.arraycopy(path2, 0, pathToSelect, 0, pathToSelect.length);
            if (pathToSelect.length == 0) {
                return;
            }
            TreeUtil.selectPath(tree, new TreePath(pathToSelect));
        }
    }

    public static void selectNode(@NotNull JTree tree, TreeNode node) {
        TreeUtil.selectPath(tree, TreeUtil.getPathFromRoot(node));
    }

    public static void moveSelectedRow(@NotNull JTree tree, int direction) {
        TreePath selectionPath = tree.getSelectionPath();
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)selectionPath.getLastPathComponent();
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)treeNode.getParent();
        int idx = parent.getIndex(treeNode);
        ((DefaultTreeModel)tree.getModel()).removeNodeFromParent(treeNode);
        ((DefaultTreeModel)tree.getModel()).insertNodeInto(treeNode, parent, idx + direction);
        TreeUtil.selectNode(tree, treeNode);
    }

    @NotNull
    public static List<TreeNode> listChildren(@NotNull TreeNode node) {
        int size = node.getChildCount();
        ArrayList<TreeNode> result2 = new ArrayList<TreeNode>(size);
        for (int i = 0; i < size; ++i) {
            TreeNode child = node.getChildAt(i);
            LOG.assertTrue(child != null);
            result2.add(child);
        }
        return result2;
    }

    public static void expandRootChildIfOnlyOne(@Nullable JTree tree) {
        if (tree == null) {
            return;
        }
        Runnable runnable = () -> {
            TreeModel model = tree.getModel();
            Object root = model.getRoot();
            if (root == null) {
                return;
            }
            TreePath rootPath = new TreePath(root);
            tree.expandPath(rootPath);
            if (model.getChildCount(root) == 1) {
                Object firstChild = model.getChild(root, 0);
                tree.expandPath(rootPath.pathByAddingChild(firstChild));
            }
        };
        UIUtil.invokeLaterIfNeeded((Runnable)runnable);
    }

    public static void expandAll(@NotNull JTree tree) {
        TreeUtil.promiseExpandAll(tree);
    }

    public static void expandAll(@NotNull JTree tree, @NotNull Runnable onDone) {
        TreeUtil.promiseExpandAll(tree).onSuccess(result2 -> UIUtil.invokeLaterIfNeeded((Runnable)onDone));
    }

    @NotNull
    public static Promise<?> promiseExpandAll(@NotNull JTree tree) {
        return TreeUtil.promiseExpand(tree, Integer.MAX_VALUE);
    }

    public static void expand(@NotNull JTree tree, int levels) {
        TreeUtil.promiseExpand(tree, levels);
    }

    public static void expand(@NotNull JTree tree, int depth, @NotNull Runnable onDone) {
        TreeUtil.promiseExpand(tree, depth).onSuccess(result2 -> UIUtil.invokeLaterIfNeeded((Runnable)onDone));
    }

    @NotNull
    public static Promise<?> promiseExpand(@NotNull JTree tree, int depth) {
        AsyncPromise promise = new AsyncPromise();
        TreeUtil.promiseMakeVisible(tree, path2 -> depth < path2.getPathCount() ? TreeVisitor.Action.SKIP_SIBLINGS : TreeVisitor.Action.CONTINUE, promise).onError(promise::setError).onSuccess(path2 -> {
            if (promise.isCancelled()) {
                return;
            }
            promise.setResult(null);
        });
        return promise;
    }

    @NotNull
    public static ActionCallback selectInTree(DefaultMutableTreeNode node, boolean requestFocus, @NotNull JTree tree) {
        return TreeUtil.selectInTree(node, requestFocus, tree, true);
    }

    @NotNull
    public static ActionCallback selectInTree(@Nullable DefaultMutableTreeNode node, boolean requestFocus, @NotNull JTree tree, boolean center) {
        if (node == null) {
            return ActionCallback.DONE;
        }
        TreePath treePath = new TreePath(node.getPath());
        tree.expandPath(treePath);
        if (requestFocus) {
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(tree, true));
        }
        return TreeUtil.selectPath(tree, treePath, center);
    }

    @NotNull
    public static ActionCallback selectInTree(Project project, @Nullable DefaultMutableTreeNode node, boolean requestFocus, @NotNull JTree tree, boolean center) {
        if (node == null) {
            return ActionCallback.DONE;
        }
        TreePath treePath = new TreePath(node.getPath());
        tree.expandPath(treePath);
        if (requestFocus) {
            ActionCallback result2 = new ActionCallback(2);
            IdeFocusManager.getInstance(project).requestFocus(tree, true).notifyWhenDone(result2);
            TreeUtil.selectPath(tree, treePath, center).notifyWhenDone(result2);
            return result2;
        }
        return TreeUtil.selectPath(tree, treePath, center);
    }

    private static boolean isViewable(@NotNull JTree tree, @NotNull TreePath path2) {
        TreePath parent = path2.getParentPath();
        return parent != null ? tree.isExpanded(parent) : tree.isRootVisible();
    }

    @NotNull
    public static List<TreePath> collectSelectedPaths(@NotNull JTree tree) {
        return TreeUtil.collectSelectedObjects(tree, Function.identity());
    }

    @NotNull
    public static List<Object> collectSelectedUserObjects(@NotNull JTree tree) {
        return TreeUtil.collectSelectedObjects(tree, TreeUtil::getLastUserObject);
    }

    @NotNull
    public static <T> List<T> collectSelectedObjects(@NotNull JTree tree, @NotNull Function<? super TreePath, ? extends T> mapper) {
        return TreeUtil.getSelection(tree, path2 -> TreeUtil.isViewable(tree, path2), mapper);
    }

    @NotNull
    public static List<TreePath> collectSelectedPaths(@NotNull JTree tree, @NotNull TreePath root) {
        return TreeUtil.collectSelectedObjects(tree, root, Function.identity());
    }

    @NotNull
    public static List<Object> collectSelectedUserObjects(@NotNull JTree tree, @NotNull TreePath root) {
        return TreeUtil.collectSelectedObjects(tree, root, TreeUtil::getLastUserObject);
    }

    @NotNull
    public static <T> List<T> collectSelectedObjects(@NotNull JTree tree, @NotNull TreePath root, @NotNull Function<? super TreePath, ? extends T> mapper) {
        if (!tree.isVisible(root)) {
            return Collections.emptyList();
        }
        return TreeUtil.getSelection(tree, path2 -> TreeUtil.isViewable(tree, path2) && root.isDescendant((TreePath)path2), mapper);
    }

    @NotNull
    private static <T> List<T> getSelection(@NotNull JTree tree, @NotNull Predicate<? super TreePath> filter, @NotNull Function<? super TreePath, ? extends T> mapper) {
        TreePath[] paths = tree.getSelectionPaths();
        if (paths == null || paths.length == 0) {
            return Collections.emptyList();
        }
        return Stream.of(paths).filter(filter).map(mapper).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static void unselectPath(@NotNull JTree tree, @Nullable TreePath path2) {
        if (path2 == null) {
            return;
        }
        TreePath[] selectionPaths = tree.getSelectionPaths();
        if (selectionPaths == null) {
            return;
        }
        for (TreePath selectionPath : selectionPaths) {
            if (selectionPath.getPathCount() <= path2.getPathCount() || !path2.isDescendant(selectionPath)) continue;
            tree.removeSelectionPath(selectionPath);
        }
    }

    @Nullable
    public static Range<Integer> getExpandControlRange(@NotNull JTree aTree, @Nullable TreePath path2) {
        TreeModel treeModel = aTree.getModel();
        BasicTreeUI basicTreeUI = (BasicTreeUI)aTree.getUI();
        Icon expandedIcon = basicTreeUI.getExpandedIcon();
        Range box = null;
        if (path2 != null && !treeModel.isLeaf(path2.getLastPathComponent())) {
            Insets i = aTree.getInsets();
            int boxWidth = expandedIcon != null ? expandedIcon.getIconWidth() : 8;
            int boxLeftX = i != null ? i.left : 0;
            boolean leftToRight = aTree.getComponentOrientation().isLeftToRight();
            int depthOffset = TreeUtil.getDepthOffset(aTree);
            int totalChildIndent = basicTreeUI.getLeftChildIndent() + basicTreeUI.getRightChildIndent();
            if (leftToRight) {
                boxLeftX += (path2.getPathCount() + depthOffset - 2) * totalChildIndent + basicTreeUI.getLeftChildIndent() - boxWidth / 2;
            }
            int boxRightX = boxLeftX + boxWidth;
            box = new Range((Comparable)Integer.valueOf(boxLeftX), (Comparable)Integer.valueOf(boxRightX));
        }
        return box;
    }

    public static int getDepthOffset(@NotNull JTree aTree) {
        if (aTree.isRootVisible()) {
            return aTree.getShowsRootHandles() ? 1 : 0;
        }
        return aTree.getShowsRootHandles() ? 0 : -1;
    }

    @NotNull
    public static RelativePoint getPointForSelection(@NotNull JTree aTree) {
        int[] rows = aTree.getSelectionRows();
        if (rows == null || rows.length == 0) {
            return RelativePoint.getCenterOf((JComponent)aTree);
        }
        return TreeUtil.getPointForRow(aTree, rows[rows.length - 1]);
    }

    @NotNull
    public static RelativePoint getPointForRow(@NotNull JTree aTree, int aRow) {
        return TreeUtil.getPointForPath(aTree, aTree.getPathForRow(aRow));
    }

    @NotNull
    public static RelativePoint getPointForPath(@NotNull JTree aTree, TreePath path2) {
        Rectangle rowBounds = aTree.getPathBounds(path2);
        rowBounds.x += 20;
        return TreeUtil.getPointForBounds(aTree, rowBounds);
    }

    @NotNull
    public static RelativePoint getPointForBounds(JComponent aComponent, @NotNull Rectangle aBounds) {
        return new RelativePoint((Component)aComponent, new Point(aBounds.x, (int)aBounds.getMaxY()));
    }

    public static boolean isOverSelection(@NotNull JTree tree, @NotNull Point point) {
        TreePath path2 = tree.getPathForLocation(point.x, point.y);
        return path2 != null && tree.getSelectionModel().isPathSelected(path2);
    }

    public static void dropSelectionButUnderPoint(@NotNull JTree tree, @NotNull Point treePoint) {
        TreePath toRetain = tree.getPathForLocation(treePoint.x, treePoint.y);
        if (toRetain == null) {
            return;
        }
        TreePath[] selection = tree.getSelectionModel().getSelectionPaths();
        for (TreePath each : selection = selection == null ? new TreePath[]{} : selection) {
            if (toRetain.equals(each)) continue;
            tree.getSelectionModel().removeSelectionPath(each);
        }
    }

    @Nullable
    public static Object getUserObject(@Nullable Object node) {
        return node instanceof DefaultMutableTreeNode ? ((DefaultMutableTreeNode)node).getUserObject() : node;
    }

    @Nullable
    public static <T> T getUserObject(@NotNull Class<T> type, @Nullable Object node) {
        return type.isInstance(node = TreeUtil.getUserObject(node)) ? (T)type.cast(node) : null;
    }

    @Nullable
    public static Object getLastUserObject(@Nullable TreePath path2) {
        return path2 == null ? null : TreeUtil.getUserObject(path2.getLastPathComponent());
    }

    @Nullable
    public static <T> T getLastUserObject(@NotNull Class<T> type, @Nullable TreePath path2) {
        return path2 == null ? null : (T)TreeUtil.getUserObject(type, path2.getLastPathComponent());
    }

    @Nullable
    public static TreePath getSelectedPathIfOne(@NotNull JTree tree) {
        TreePath[] paths = tree.getSelectionPaths();
        return paths != null && paths.length == 1 ? paths[0] : null;
    }

    public static void ensureSelection(@NotNull JTree tree) {
        TreePath[] paths = tree.getSelectionPaths();
        if (paths != null) {
            for (TreePath each : paths) {
                if (tree.getRowForPath(each) < 0 || !tree.isVisible(each)) continue;
                return;
            }
        }
        for (int eachRow = 0; eachRow < tree.getRowCount(); ++eachRow) {
            TreePath eachPath = tree.getPathForRow(eachRow);
            if (eachPath == null || !tree.isVisible(eachPath)) continue;
            tree.setSelectionPath(eachPath);
            break;
        }
    }

    public static <T extends MutableTreeNode> void insertNode(@NotNull T child, @NotNull T parent, @Nullable DefaultTreeModel model, @NotNull Comparator<? super T> comparator) {
        TreeUtil.insertNode(child, parent, model, false, comparator);
    }

    public static <T extends MutableTreeNode> void insertNode(@NotNull T child, @NotNull T parent, @Nullable DefaultTreeModel model, boolean allowDuplication, @NotNull Comparator<? super T> comparator) {
        int insertionPoint;
        int index2 = TreeUtil.indexedBinarySearch(parent, child, comparator);
        if (index2 >= 0 && !allowDuplication) {
            LOG.error("Node " + child + " is already added to " + parent);
            return;
        }
        int n = insertionPoint = index2 >= 0 ? index2 : -(index2 + 1);
        if (model != null) {
            model.insertNodeInto(child, parent, insertionPoint);
        } else {
            parent.insert(child, insertionPoint);
        }
    }

    public static <T extends TreeNode> int indexedBinarySearch(@NotNull T parent, @NotNull T key, @NotNull Comparator<? super T> comparator) {
        return ObjectUtils.binarySearch((int)0, (int)parent.getChildCount(), mid -> comparator.compare(parent.getChildAt(mid), key));
    }

    @NotNull
    public static Comparator<TreePath> getDisplayOrderComparator(@NotNull JTree tree) {
        return Comparator.comparingInt(tree::getRowForPath);
    }

    private static void expandPathWithDebug(@NotNull JTree tree, @NotNull TreePath path2) {
        LOG.debug("tree expand path: ", new Object[]{path2});
        tree.expandPath(path2);
    }

    public static void expand(@NotNull JTree tree, @NotNull TreeVisitor visitor, @NotNull Consumer<? super TreePath> consumer) {
        TreeUtil.promiseMakeVisibleOne(tree, visitor, path2 -> {
            TreeUtil.expandPathWithDebug(tree, path2);
            consumer.accept((TreePath)path2);
        });
    }

    @NotNull
    public static Promise<TreePath> promiseExpand(@NotNull JTree tree, @NotNull TreeVisitor visitor) {
        return TreeUtil.promiseMakeVisibleOne(tree, visitor, path2 -> TreeUtil.expandPathWithDebug(tree, path2));
    }

    @NotNull
    public static Promise<List<TreePath>> promiseExpand(@NotNull JTree tree, @NotNull Stream<? extends TreeVisitor> visitors) {
        return TreeUtil.promiseMakeVisibleAll(tree, visitors, paths -> paths.forEach(path2 -> TreeUtil.expandPathWithDebug(tree, path2)));
    }

    public static void makeVisible(@NotNull JTree tree, @NotNull TreeVisitor visitor, @NotNull Consumer<? super TreePath> consumer) {
        TreeUtil.promiseMakeVisibleOne(tree, visitor, consumer);
    }

    @NotNull
    public static Promise<TreePath> promiseMakeVisible(@NotNull JTree tree, @NotNull TreeVisitor visitor) {
        return TreeUtil.promiseMakeVisibleOne(tree, visitor, null);
    }

    @NotNull
    private static Promise<TreePath> promiseMakeVisibleOne(@NotNull JTree tree, @NotNull TreeVisitor visitor, @Nullable Consumer<? super TreePath> consumer) {
        AsyncPromise<TreePath> promise = new AsyncPromise<TreePath>();
        TreeUtil.promiseMakeVisible(tree, visitor, promise).onError(promise::setError).onSuccess(path2 -> {
            if (promise.isCancelled()) {
                return;
            }
            UIUtil.invokeLaterIfNeeded(() -> {
                if (promise.isCancelled()) {
                    return;
                }
                if (tree.isVisible((TreePath)path2)) {
                    if (consumer != null) {
                        consumer.accept((TreePath)path2);
                    }
                    promise.setResult((TreePath)path2);
                } else {
                    promise.cancel();
                }
            });
        });
        return promise;
    }

    @NotNull
    public static Promise<List<TreePath>> promiseMakeVisible(@NotNull JTree tree, @NotNull Stream<? extends TreeVisitor> visitors) {
        return TreeUtil.promiseMakeVisibleAll(tree, visitors, null);
    }

    private static Promise<List<TreePath>> promiseMakeVisibleAll(@NotNull JTree tree, @NotNull Stream<? extends TreeVisitor> visitors, @Nullable Consumer<? super List<TreePath>> consumer) {
        AsyncPromise<List<TreePath>> promise = new AsyncPromise<List<TreePath>>();
        List promises = visitors.filter(Objects::nonNull).map(visitor -> TreeUtil.promiseMakeVisible(tree, visitor, promise)).collect(Collectors.toList());
        Promises.collectResults(promises, true).onError(promise::setError).onSuccess(paths -> {
            if (promise.isCancelled()) {
                return;
            }
            if (!ContainerUtil.isEmpty((Collection)paths)) {
                UIUtil.invokeLaterIfNeeded(() -> {
                    if (promise.isCancelled()) {
                        return;
                    }
                    List visible = ContainerUtil.filter((Collection)paths, tree::isVisible);
                    if (!ContainerUtil.isEmpty((Collection)visible)) {
                        if (consumer != null) {
                            consumer.accept(visible);
                        }
                        promise.setResult(visible);
                    } else {
                        promise.cancel();
                    }
                });
            } else {
                promise.cancel();
            }
        });
        return promise;
    }

    @NotNull
    private static Promise<TreePath> promiseMakeVisible(@NotNull JTree tree, @NotNull TreeVisitor visitor, @NotNull AsyncPromise<?> promise) {
        return TreeUtil.promiseVisit(tree, path2 -> {
            if (promise.isCancelled()) {
                return TreeVisitor.Action.SKIP_SIBLINGS;
            }
            TreeVisitor.Action action = visitor.visit(path2);
            if (action == TreeVisitor.Action.CONTINUE || action == TreeVisitor.Action.INTERRUPT) {
                if (!tree.isVisible(path2)) {
                    if (!promise.isCancelled()) {
                        LOG.debug("tree expand canceled");
                        promise.cancel();
                    }
                    return TreeVisitor.Action.SKIP_SIBLINGS;
                }
                if (action == TreeVisitor.Action.CONTINUE) {
                    TreeUtil.expandPathWithDebug(tree, path2);
                }
            }
            return action;
        });
    }

    public static void select(@NotNull JTree tree, @NotNull TreeVisitor visitor, @NotNull Consumer<? super TreePath> consumer) {
        TreeUtil.promiseMakeVisibleOne(tree, visitor, path2 -> {
            TreeUtil.internalSelectPath(tree, path2);
            consumer.accept((TreePath)path2);
        });
    }

    @NotNull
    public static Promise<TreePath> promiseSelect(@NotNull JTree tree, @NotNull TreeVisitor visitor) {
        return TreeUtil.promiseMakeVisibleOne(tree, visitor, path2 -> TreeUtil.internalSelectPath(tree, path2));
    }

    private static void internalSelectPath(@NotNull JTree tree, @NotNull TreePath path2) {
        assert (EventQueue.isDispatchThread());
        tree.setSelectionPath(path2);
        TreeUtil.internalScroll(tree, path2);
    }

    @NotNull
    public static Promise<List<TreePath>> promiseSelect(@NotNull JTree tree, @NotNull Stream<? extends TreeVisitor> visitors) {
        return TreeUtil.promiseMakeVisibleAll(tree, visitors, paths -> TreeUtil.internalSelectPaths(tree, paths));
    }

    private static void internalSelectPaths(@NotNull JTree tree, @NotNull List<? extends TreePath> paths) {
        assert (EventQueue.isDispatchThread());
        if (paths.isEmpty()) {
            return;
        }
        tree.setSelectionPaths(paths.toArray(new TreePath[0]));
        for (TreePath treePath : paths) {
            if (TreeUtil.internalScroll(tree, treePath)) break;
        }
    }

    private static boolean internalScroll(@NotNull JTree tree, @NotNull TreePath path2) {
        assert (EventQueue.isDispatchThread());
        int row = tree.getRowForPath(path2);
        if (row == -1) {
            LOG.debug("cannot scroll to: ", new Object[]{path2});
            return false;
        }
        TreeUtil.showRowCentred(tree, row);
        return true;
    }

    @NotNull
    public static Promise<TreePath> promiseSelectFirst(@NotNull JTree tree) {
        return TreeUtil.promiseSelect(tree, (TreePath path2) -> !tree.isRootVisible() && path2.getParentPath() == null ? TreeVisitor.Action.CONTINUE : TreeVisitor.Action.INTERRUPT);
    }

    public static void visit(@NotNull JTree tree, @NotNull TreeVisitor visitor, @NotNull Consumer<? super TreePath> consumer) {
        TreeUtil.promiseVisit(tree, visitor).onSuccess(path2 -> UIUtil.invokeLaterIfNeeded(() -> consumer.accept((TreePath)path2)));
    }

    @NotNull
    public static Promise<TreePath> promiseVisit(@NotNull JTree tree, @NotNull TreeVisitor visitor) {
        TreeModel model = tree.getModel();
        if (model instanceof TreeVisitor.Acceptor) {
            TreeVisitor.Acceptor acceptor = (TreeVisitor.Acceptor)((Object)model);
            return acceptor.accept(visitor);
        }
        if (model == null) {
            return Promises.rejectedPromise("tree model is not set");
        }
        AsyncPromise<TreePath> promise = new AsyncPromise<TreePath>();
        UIUtil.invokeLaterIfNeeded(() -> promise.setResult(TreeUtil.visitModel(model, visitor)));
        return promise;
    }

    private static TreePath visitModel(@NotNull TreeModel model, @NotNull TreeVisitor visitor) {
        Object root = model.getRoot();
        if (root == null) {
            return null;
        }
        TreePath path2 = new TreePath(root);
        switch (visitor.visit(path2)) {
            case INTERRUPT: {
                return path2;
            }
            case CONTINUE: {
                break;
            }
            default: {
                return null;
            }
        }
        ArrayDeque<Deque<TreePath>> stack = new ArrayDeque<Deque<TreePath>>();
        stack.push(TreeUtil.children(model, path2));
        while (path2 != null) {
            Deque siblings = (Deque)stack.peek();
            if (siblings == null) {
                return null;
            }
            TreePath next = (TreePath)siblings.poll();
            if (next == null) {
                LOG.assertTrue(siblings == stack.poll());
                path2 = path2.getParentPath();
                continue;
            }
            switch (visitor.visit(next)) {
                case INTERRUPT: {
                    return next;
                }
                case CONTINUE: {
                    path2 = next;
                    stack.push(TreeUtil.children(model, path2));
                    break;
                }
                case SKIP_SIBLINGS: {
                    siblings.clear();
                    break;
                }
            }
        }
        LOG.assertTrue(stack.isEmpty());
        return null;
    }

    @NotNull
    private static Deque<TreePath> children(@NotNull TreeModel model, @NotNull TreePath path2) {
        Object object = path2.getLastPathComponent();
        int count = model.getChildCount(object);
        ArrayDeque<TreePath> deque = new ArrayDeque<TreePath>(count);
        for (int i = 0; i < count; ++i) {
            deque.add(path2.pathByAddingChild(model.getChild(object, i)));
        }
        return deque;
    }

    public static TreePath visitVisibleRows(@NotNull JTree tree, @NotNull TreeVisitor visitor) {
        TreePath parent = null;
        int count = tree.getRowCount();
        block6: for (int row = 0; row < count; ++row) {
            if (count != tree.getRowCount()) {
                throw new ConcurrentModificationException("tree is modified");
            }
            TreePath path2 = tree.getPathForRow(row);
            if (path2 == null) {
                throw new NullPointerException("path is not found at row " + row);
            }
            if (parent != null && parent.isDescendant(path2)) continue;
            switch (visitor.visit(path2)) {
                case INTERRUPT: {
                    return path2;
                }
                case CONTINUE: {
                    parent = null;
                    continue block6;
                }
                case SKIP_CHILDREN: {
                    parent = path2;
                    continue block6;
                }
                case SKIP_SIBLINGS: {
                    parent = path2.getParentPath();
                    if (parent != null) continue block6;
                    return null;
                }
            }
        }
        return null;
    }

    public static <T> void visitVisibleRows(@NotNull JTree tree, @NotNull Function<? super TreePath, ? extends T> mapper, @NotNull Consumer<? super T> consumer) {
        TreeUtil.visitVisibleRows(tree, path2 -> {
            Object object = mapper.apply(path2);
            if (object != null) {
                consumer.accept((Object)object);
            }
            return TreeVisitor.Action.CONTINUE;
        });
    }

    @NotNull
    private static <T> List<T> collectVisibleRows(@NotNull JTree tree, @NotNull Predicate<? super TreePath> filter, @NotNull Function<? super TreePath, ? extends T> mapper) {
        int count = tree.getRowCount();
        if (count == 0) {
            return Collections.emptyList();
        }
        ArrayList list = new ArrayList(count);
        TreeUtil.visitVisibleRows(tree, path2 -> filter.test((TreePath)path2) ? mapper.apply((TreePath)path2) : null, list::add);
        return list;
    }

    @Deprecated
    @FunctionalInterface
    public static interface Traverse {
        public boolean accept(Object var1);
    }
}

