/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.update;

import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LazyUiDisposable<T extends Disposable>
implements Activatable {
    private Throwable myAllocation;
    private final AtomicReference<JComponent> myUI;
    private final Disposable myParent;
    private final T myChild;

    public LazyUiDisposable(@Nullable Disposable parent, @NotNull JComponent ui, @NotNull T child) {
        if (Boolean.TRUE.toString().equalsIgnoreCase(System.getProperty("idea.is.internal"))) {
            this.myAllocation = new Exception();
        }
        this.myUI = new AtomicReference<JComponent>(ui);
        this.myParent = parent;
        this.myChild = child;
        new UiNotifyConnector.Once(ui, this);
    }

    @Override
    public final void showNotify() {
        JComponent ui = this.myUI.getAndSet(null);
        if (ui == null) {
            return;
        }
        Project project = null;
        Disposable parent = this.myParent;
        if (ApplicationManager.getApplication() != null) {
            DataContext context = DataManager.getInstance().getDataContext(ui);
            project = CommonDataKeys.PROJECT.getData(context);
            if (parent == null) {
                parent = PlatformDataKeys.UI_DISPOSABLE.getData(context);
            }
        }
        if (parent == null) {
            if (project == null) {
                Logger.getInstance(LazyUiDisposable.class).warn("use application as a parent disposable");
                parent = Disposer.get((String)"ui");
            } else {
                Logger.getInstance(LazyUiDisposable.class).warn("use project as a parent disposable");
                parent = project;
            }
        }
        this.initialize(parent, this.myChild, project);
        Disposer.register((Disposable)parent, this.myChild);
    }

    @Override
    public final void hideNotify() {
    }

    protected abstract void initialize(@NotNull Disposable var1, @NotNull T var2, @Nullable Project var3);
}

