/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log;

import com.intellij.util.text.DateFormatUtil;
import com.intellij.vcs.log.VcsLogDetailsFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface VcsLogDateFilter
extends VcsLogDetailsFilter {
    @Nullable
    public Date getAfter();

    @Nullable
    public Date getBefore();

    @NotNull
    default public VcsLogFilterCollection.FilterKey<VcsLogDateFilter> getKey() {
        return VcsLogFilterCollection.DATE_FILTER;
    }

    @Override
    @NotNull
    default public String getPresentation() {
        if (this.getBefore() != null && this.getAfter() != null) {
            return DateFormatUtil.formatBetweenDates((long)this.getAfter().getTime(), (long)this.getBefore().getTime());
        }
        if (this.getAfter() != null) {
            return "after " + DateFormatUtil.formatDate((Date)this.getAfter());
        }
        return "before " + DateFormatUtil.formatDate((Date)this.getBefore());
    }
}

