/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcsUtil;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.VcsBundle;
import org.jetbrains.annotations.NotNull;

public class VcsSelection {
    private final Document myDocument;
    private final int mySelectionStartLineNumber;
    private final int mySelectionEndLineNumber;
    private final String myActionName;
    private final String myDialogTitle;

    public VcsSelection(@NotNull Document document, SelectionModel selectionModel) {
        this(document, new TextRange(selectionModel.getSelectionStart(), selectionModel.getSelectionEnd()), VcsBundle.message("action.name.show.history.for.selection", new Object[0]));
    }

    public VcsSelection(@NotNull Document document, TextRange textRange, String actionName) {
        this.myDocument = document;
        int startOffset = textRange.getStartOffset();
        this.mySelectionStartLineNumber = document.getLineNumber(startOffset);
        int endOffset = textRange.getEndOffset();
        this.mySelectionEndLineNumber = endOffset >= document.getTextLength() ? document.getLineCount() - 1 : document.getLineNumber(endOffset);
        this.myActionName = VcsBundle.message("show.history.action.name.template", actionName);
        this.myDialogTitle = VcsBundle.message("show.history.dialog.title.template", actionName);
    }

    @NotNull
    public Document getDocument() {
        return this.myDocument;
    }

    public int getSelectionStartLineNumber() {
        return this.mySelectionStartLineNumber;
    }

    public int getSelectionEndLineNumber() {
        return this.mySelectionEndLineNumber;
    }

    public String getActionName() {
        return this.myActionName;
    }

    public String getDialogTitle() {
        return this.myDialogTitle;
    }
}

