/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.evaluation;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XDebuggerEditorsProviderBase
extends XDebuggerEditorsProvider {
    @Override
    @NotNull
    public final Document createDocument(@NotNull Project project, @NotNull String text, @Nullable XSourcePosition sourcePosition, @NotNull EvaluationMode mode) {
        PsiElement context = null;
        if (sourcePosition != null) {
            context = this.getContextElement(sourcePosition.getFile(), sourcePosition.getOffset(), project);
        }
        PsiFile codeFragment = this.createExpressionCodeFragment(project, text, context, true);
        Document document = PsiDocumentManager.getInstance(project).getDocument(codeFragment);
        assert (document != null);
        return document;
    }

    @Override
    @NotNull
    public Document createDocument(@NotNull Project project, @NotNull XExpression expression, @Nullable XSourcePosition sourcePosition, @NotNull EvaluationMode mode) {
        PsiElement context = null;
        if (sourcePosition != null) {
            context = this.getContextElement(sourcePosition.getFile(), sourcePosition.getOffset(), project);
        }
        return this.createDocument(project, expression, context, mode);
    }

    @NotNull
    public Document createDocument(@NotNull Project project, @NotNull XExpression expression, @Nullable PsiElement context, @NotNull EvaluationMode mode) {
        PsiFile codeFragment = this.createExpressionCodeFragment(project, expression, context, true);
        Document document = PsiDocumentManager.getInstance(project).getDocument(codeFragment);
        assert (document != null);
        return document;
    }

    protected abstract PsiFile createExpressionCodeFragment(@NotNull Project var1, @NotNull String var2, @Nullable PsiElement var3, boolean var4);

    protected PsiFile createExpressionCodeFragment(@NotNull Project project, @NotNull XExpression expression, @Nullable PsiElement context, boolean isPhysical) {
        return this.createExpressionCodeFragment(project, expression.getExpression(), context, isPhysical);
    }

    @NotNull
    public Collection<Language> getSupportedLanguages(@Nullable PsiElement context) {
        if (context != null) {
            return this.getSupportedLanguages(context.getProject(), null);
        }
        return Collections.emptyList();
    }

    @Nullable
    protected PsiElement getContextElement(@NotNull VirtualFile virtualFile2, int offset, @NotNull Project project) {
        return XDebuggerUtil.getInstance().findContextElement(virtualFile2, offset, project, false);
    }
}

