/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.concurrency;

import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.DonePromise;
import org.jetbrains.concurrency.InternalPromiseUtil;
import org.jetbrains.concurrency.Promise;

public interface CancellablePromise<T>
extends Promise<T>,
Future<T> {
    public void cancel();

    @NotNull
    public static <T> CancellablePromise<T> resolve(@Nullable T result2) {
        if (result2 == null) {
            return (CancellablePromise)InternalPromiseUtil.FULFILLED_PROMISE.getValue();
        }
        return new DonePromise<T>(InternalPromiseUtil.PromiseValue.createFulfilled(result2));
    }
}

