/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.concurrency;

import com.intellij.util.Function;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.InternalPromiseUtil;
import org.jetbrains.concurrency.Promise;

class DonePromise<T>
extends InternalPromiseUtil.BasePromise<T> {
    private final InternalPromiseUtil.PromiseValue<T> value;

    DonePromise(@NotNull InternalPromiseUtil.PromiseValue<T> value) {
        this.value = value;
    }

    @Override
    @NotNull
    public Promise<T> onSuccess(@NotNull Consumer<? super T> handler) {
        if (this.value.error != null) {
            return this;
        }
        if (!InternalPromiseUtil.isHandlerObsolete(handler)) {
            handler.accept(this.value.result);
        }
        return this;
    }

    @Override
    @NotNull
    public Promise<T> processed(@NotNull Promise<? super T> child) {
        if (child instanceof InternalPromiseUtil.PromiseImpl) {
            ((InternalPromiseUtil.PromiseImpl)((Object)child))._setValue(this.value);
        } else if (child instanceof InternalPromiseUtil.CompletablePromise) {
            ((InternalPromiseUtil.CompletablePromise)child).setResult(this.value.result);
        }
        return this;
    }

    @Override
    @NotNull
    public Promise<T> onProcessed(@NotNull Consumer<? super T> handler) {
        if (this.value.error == null) {
            this.onSuccess(handler);
        } else if (!InternalPromiseUtil.isHandlerObsolete(handler)) {
            handler.accept(null);
        }
        return this;
    }

    @Override
    @NotNull
    public Promise<T> onError(@NotNull Consumer<Throwable> handler) {
        if (this.value.error != null && !InternalPromiseUtil.isHandlerObsolete(handler)) {
            handler.accept(this.value.error);
        }
        return this;
    }

    @Override
    @NotNull
    public <SUB_RESULT> Promise<SUB_RESULT> then(@NotNull Function<? super T, ? extends SUB_RESULT> done2) {
        if (this.value.error != null) {
            return this;
        }
        if (InternalPromiseUtil.isHandlerObsolete(done2)) {
            return (Promise)InternalPromiseUtil.CANCELLED_PROMISE.getValue();
        }
        return new DonePromise<Object>(InternalPromiseUtil.PromiseValue.createFulfilled(done2.fun(this.value.result)));
    }

    @Override
    @NotNull
    public <SUB_RESULT> Promise<SUB_RESULT> thenAsync(@NotNull Function<? super T, Promise<SUB_RESULT>> done2) {
        if (this.value.error == null) {
            return (Promise)done2.fun(this.value.result);
        }
        return this;
    }

    @Override
    @Nullable
    public T blockingGet(int timeout, @NotNull TimeUnit timeUnit) throws ExecutionException, TimeoutException {
        return this.value.getResultOrThrowError();
    }

    @Override
    public void _setValue(@NotNull InternalPromiseUtil.PromiseValue<T> value) {
    }

    @Override
    @Nullable
    protected InternalPromiseUtil.PromiseValue<T> getValue() {
        return this.value;
    }

    @Override
    public void cancel() {
    }
}

