/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.concurrency;

import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.util.ExceptionUtilRt;
import com.intellij.util.ThreeState;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.concurrency.DonePromise;
import org.jetbrains.concurrency.Obsolescent;
import org.jetbrains.concurrency.Promise;

public class InternalPromiseUtil {
    public static final RuntimeException OBSOLETE_ERROR = new MessageError("Obsolete", false);
    public static final NotNullLazyValue<Promise<Object>> CANCELLED_PROMISE = new NotNullLazyValue<Promise<Object>>(){

        @NotNull
        protected Promise<Object> compute() {
            return new DonePromise<Object>(PromiseValue.createRejected(OBSOLETE_ERROR));
        }
    };
    public static final NotNullLazyValue<CancellablePromise<Object>> FULFILLED_PROMISE = new NotNullLazyValue<CancellablePromise<Object>>(){

        @NotNull
        protected CancellablePromise<Object> compute() {
            return new DonePromise<Object>(PromiseValue.createFulfilled(null));
        }
    };

    public static boolean isHandlerObsolete(@NotNull Object handler) {
        return handler instanceof Obsolescent && ((Obsolescent)handler).isObsolete();
    }

    public static abstract class BasePromise<T>
    implements Promise<T>,
    Future<T>,
    PromiseImpl<T>,
    CancellablePromise<T> {
        @Nullable
        protected abstract PromiseValue<T> getValue();

        @Override
        public final boolean isDone() {
            return this.getValue() != null;
        }

        @Override
        @NotNull
        public final Promise.State getState() {
            PromiseValue<T> value = this.getValue();
            return value == null ? Promise.State.PENDING : value.getState();
        }

        @Override
        public final boolean isCancelled() {
            PromiseValue<T> value = this.getValue();
            return value != null && value.isCancelled();
        }

        @Override
        public final T get() throws ExecutionException {
            try {
                return this.blockingGet(-1);
            }
            catch (TimeoutException e) {
                throw new ExecutionException(e);
            }
        }

        @Override
        public final T get(long timeout, @NotNull TimeUnit unit) throws ExecutionException, TimeoutException {
            return this.blockingGet((int)timeout, unit);
        }

        @Override
        public final boolean cancel(boolean mayInterruptIfRunning) {
            if (this.getState() == Promise.State.PENDING) {
                this.cancel();
                return true;
            }
            return false;
        }
    }

    public static class PromiseValue<T> {
        public final T result;
        public final Throwable error;

        public static <T> PromiseValue<T> createFulfilled(@Nullable T result2) {
            return new PromiseValue<T>(result2, null);
        }

        public static <T> PromiseValue<T> createRejected(@Nullable Throwable error) {
            return new PromiseValue<Object>(null, error);
        }

        private PromiseValue(@Nullable T result2, @Nullable Throwable error) {
            this.result = result2;
            this.error = error;
        }

        @NotNull
        public Promise.State getState() {
            return this.error == null ? Promise.State.SUCCEEDED : Promise.State.REJECTED;
        }

        public boolean isCancelled() {
            return this.error == OBSOLETE_ERROR;
        }

        @Nullable
        public T getResultOrThrowError() throws ExecutionException, TimeoutException {
            if (this.error == null) {
                return this.result;
            }
            if (this.error == OBSOLETE_ERROR) {
                return null;
            }
            ExceptionUtilRt.rethrowUnchecked((Throwable)this.error);
            if (this.error instanceof ExecutionException) {
                throw (ExecutionException)this.error;
            }
            if (this.error instanceof TimeoutException) {
                throw (TimeoutException)this.error;
            }
            throw new ExecutionException(this.error);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PromiseValue value = (PromiseValue)o;
            return Objects.equals(this.result, value.result) && Objects.equals(this.error, value.error);
        }

        public int hashCode() {
            int result1 = this.result != null ? this.result.hashCode() : 0;
            result1 = 31 * result1 + (this.error != null ? this.error.hashCode() : 0);
            return result1;
        }
    }

    public static class MessageError
    extends RuntimeException {
        public final ThreeState log;

        public MessageError(@NotNull String message, boolean isLog) {
            super(message);
            this.log = ThreeState.fromBoolean((boolean)isLog);
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }

    public static interface CompletablePromise<T>
    extends Promise<T> {
        public void setResult(@Nullable T var1);

        public boolean setError(@NotNull Throwable var1);
    }

    public static interface PromiseImpl<T> {
        public void _setValue(@NotNull PromiseValue<T> var1);
    }
}

