/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.java;

import com.intellij.util.lang.JavaVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JpsJavaSdkType;

public enum LanguageLevel {
    JDK_1_3(3),
    JDK_1_4(4),
    JDK_1_5(5),
    JDK_1_6(6),
    JDK_1_7(7),
    JDK_1_8(8),
    JDK_1_9(9),
    JDK_10(10),
    JDK_11(11),
    JDK_12(12),
    JDK_12_PREVIEW(12),
    JDK_X(13);

    public static final LanguageLevel HIGHEST;
    private final JavaVersion myVersion;

    private LanguageLevel(int major) {
        this.myVersion = JavaVersion.compose((int)major);
    }

    @NotNull
    public JavaVersion toJavaVersion() {
        return this.myVersion;
    }

    public boolean isPreview() {
        return this.name().endsWith("_PREVIEW");
    }

    @Deprecated
    public String getComplianceOption() {
        return JpsJavaSdkType.complianceOption(this.toJavaVersion());
    }

    static {
        HIGHEST = JDK_11;
    }
}

