/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.junit.RefactoringListeners;
import com.intellij.execution.junit.TestObject;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import org.jetbrains.annotations.NotNull;

class TestClass
extends TestObject {
    TestClass(JUnitConfiguration configuration, ExecutionEnvironment environment) {
        super(configuration, environment);
    }

    @Override
    protected JavaParameters createJavaParameters() throws ExecutionException {
        JavaParameters javaParameters = super.createJavaParameters();
        JUnitConfiguration.Data data = this.getConfiguration().getPersistentData();
        javaParameters.getProgramParametersList().add(data.getMainClassName());
        return javaParameters;
    }

    @Override
    @NotNull
    protected String getForkMode() {
        String forkMode = super.getForkMode();
        return "class".equals(forkMode) ? "repeat" : forkMode;
    }

    @Override
    public String suggestActionName() {
        String name = this.getConfiguration().getPersistentData().MAIN_CLASS_NAME;
        if (name != null && name.endsWith(".")) {
            return name;
        }
        return JavaExecutionUtil.getShortClassName((String)name);
    }

    @Override
    public RefactoringElementListener getListener(PsiElement element, JUnitConfiguration configuration) {
        return RefactoringListeners.getClassOrPackageListener((PsiElement)element, configuration.myClass);
    }

    @Override
    public boolean isConfiguredByElement(JUnitConfiguration configuration, PsiClass testClass, PsiMethod testMethod, PsiPackage testPackage, PsiDirectory testDir) {
        if (testClass == null) {
            return false;
        }
        if (testMethod != null) {
            return false;
        }
        return Comparing.equal((String)JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)testClass), (String)configuration.getPersistentData().getMainClassName());
    }

    @Override
    public void checkConfiguration() throws RuntimeConfigurationException {
        super.checkConfiguration();
        String testClassName = this.getConfiguration().getPersistentData().getMainClassName();
        JavaRunConfigurationModule configurationModule = (JavaRunConfigurationModule)this.getConfiguration().getConfigurationModule();
        PsiClass testClass = configurationModule.checkModuleAndClassName(testClassName, ExecutionBundle.message((String)"no.test.class.specified.error.text", (Object[])new Object[0]));
        if (!JUnitUtil.isTestClass((PsiClass)testClass)) {
            throw new RuntimeConfigurationWarning(ExecutionBundle.message((String)"class.isnt.test.class.error.message", (Object[])new Object[]{testClassName}));
        }
    }
}

