/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit.codeInsight;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.MetaAnnotationUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.DeleteElementFix;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaVersionService;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0017\u00a8\u0006\f"}, d2={"Lcom/intellij/execution/junit/codeInsight/JUnit5MalformedRepeatedTestInspection;", "Lcom/intellij/codeInspection/AbstractBaseJavaLocalInspectionTool;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "getDisplayName", "", "Annotations", "intellij.junit"})
public final class JUnit5MalformedRepeatedTestInspection
extends AbstractBaseJavaLocalInspectionTool {
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message((String)"junit5.malformed.repeated.test.display.name", (Object[])new Object[0]);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        PsiFile file = holder.getFile();
        if (!JavaVersionService.getInstance().isAtLeast((PsiElement)file, JavaSdkVersion.JDK_1_8)) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        if (JavaPsiFacade.getInstance((Project)file.getProject()).findClass("org.junit.jupiter.api.RepeatedTest", file.getResolveScope()) == null) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        return (PsiElementVisitor)new JavaElementVisitor(holder, file){
            final /* synthetic */ ProblemsHolder $holder;
            final /* synthetic */ PsiFile $file;

            public void visitMethod(@NotNull PsiMethod method) {
                PsiModifierList modifierList = method.getModifierList();
                PsiAnnotation repeatedAnno = modifierList.findAnnotation("org.junit.jupiter.api.RepeatedTest");
                if (repeatedAnno != null) {
                    Object constant;
                    PsiAnnotationMemberValue repeatedNumber;
                    PsiAnnotation[] testAnno = AnnotationUtil.findAnnotations((PsiModifierListOwner)((PsiModifierListOwner)method), (Collection)JUnitUtil.TEST5_JUPITER_ANNOTATIONS);
                    PsiAnnotation[] psiAnnotationArray = testAnno;
                    PsiAnnotation[] psiAnnotationArray2 = psiAnnotationArray;
                    if (!(psiAnnotationArray2.length == 0)) {
                        this.$holder.registerProblem((PsiElement)testAnno[0], "Suspicious combination @Test and @RepeatedTest", new LocalQuickFix[]{(LocalQuickFix)new DeleteElementFix((PsiElement)testAnno[0])});
                    }
                    if ((repeatedNumber = repeatedAnno.findDeclaredAttributeValue("value")) instanceof PsiExpression && (constant = ExpressionUtils.computeConstantExpression((PsiExpression)((PsiExpression)repeatedNumber))) instanceof Integer && ((Number)constant).intValue() <= 0) {
                        this.$holder.registerProblem((PsiElement)repeatedNumber, "The number of repetitions must be greater than zero", new LocalQuickFix[0]);
                    }
                } else {
                    PsiParameter repetitionInfoParam;
                    int n;
                    PsiParameter[] psiParameterArray;
                    PsiParameter[] psiParameterArray2;
                    block17: {
                        PsiParameter psiParameter;
                        PsiParameter[] psiParameterArray3;
                        PsiClass repetitionInfo = JavaPsiFacade.getInstance((Project)this.$holder.getProject()).findClass("org.junit.jupiter.api.RepetitionInfo", this.$file.getResolveScope());
                        PsiElementFactory psiElementFactory = JavaPsiFacade.getElementFactory((Project)this.$holder.getProject());
                        PsiClass psiClass = repetitionInfo;
                        if (psiClass == null) {
                            Intrinsics.throwNpe();
                        }
                        PsiClassType repetitionType = psiElementFactory.createType(psiClass);
                        psiParameterArray = psiParameterArray2 = (psiParameterArray3 = method.getParameterList().getParameters());
                        int n2 = psiParameterArray.length;
                        for (n = 0; n < n2; ++n) {
                            PsiParameter psiParameter2;
                            PsiParameter it = psiParameter2 = psiParameterArray[n];
                            boolean bl = false;
                            if (!Intrinsics.areEqual((Object)it.getType(), (Object)repetitionType)) continue;
                            psiParameter = psiParameter2;
                            break block17;
                        }
                        psiParameter = repetitionInfoParam = null;
                    }
                    if (repetitionInfoParam != null) {
                        if (MetaAnnotationUtil.isMetaAnnotated((PsiModifierListOwner)((PsiModifierListOwner)method), (Collection)Annotations.INSTANCE.getNON_REPEATED_ANNOTATIONS())) {
                            PsiIdentifier psiIdentifier = repetitionInfoParam.getNameIdentifier();
                            this.$holder.registerProblem(psiIdentifier != null ? (PsiElement)psiIdentifier : (PsiElement)repetitionInfoParam, "RepetitionInfo is injected for @RepeatedTest only", new LocalQuickFix[0]);
                        } else {
                            PsiAnnotation anno = MetaAnnotationUtil.findMetaAnnotations((PsiModifierListOwner)((PsiModifierListOwner)method), (Collection)JUnitUtil.TEST5_STATIC_CONFIG_METHODS).findFirst().orElse(null);
                            if (anno != null) {
                                String qName = anno.getQualifiedName();
                                PsiIdentifier psiIdentifier = repetitionInfoParam.getNameIdentifier();
                                PsiElement psiElement = psiIdentifier != null ? (PsiElement)psiIdentifier : (PsiElement)repetitionInfoParam;
                                StringBuilder stringBuilder = new StringBuilder().append("RepetitionInfo is injected for @BeforeEach/@AfterEach only, but not for ");
                                String string = qName;
                                if (string == null) {
                                    Intrinsics.throwNpe();
                                }
                                this.$holder.registerProblem(psiElement, stringBuilder.append(StringUtil.getShortName((String)string)).toString(), new LocalQuickFix[0]);
                            } else if (MetaAnnotationUtil.isMetaAnnotated((PsiModifierListOwner)((PsiModifierListOwner)method), (Collection)JUnitUtil.TEST5_CONFIG_METHODS)) {
                                PsiParameter psiParameter;
                                block18: {
                                    PsiMethod[] psiMethodArray = method.getContainingClass();
                                    if (psiMethodArray != null && (psiMethodArray = psiMethodArray.getMethods()) != null) {
                                        PsiParameter[] psiParameterArray4 = psiParameterArray = (psiParameterArray2 = psiMethodArray);
                                        n = psiParameterArray4.length;
                                        for (int i = 0; i < n; ++i) {
                                            PsiParameter psiParameter3;
                                            PsiParameter it = psiParameter3 = psiParameterArray4[i];
                                            boolean bl = false;
                                            if (!MetaAnnotationUtil.isMetaAnnotated((PsiModifierListOwner)((PsiModifierListOwner)it), (Collection)Annotations.INSTANCE.getNON_REPEATED_ANNOTATIONS())) continue;
                                            psiParameter = psiParameter3;
                                            break block18;
                                        }
                                        psiParameter = null;
                                    } else {
                                        psiParameter = null;
                                    }
                                }
                                if (psiParameter != null) {
                                    PsiIdentifier psiIdentifier = repetitionInfoParam.getNameIdentifier();
                                    this.$holder.registerProblem(psiIdentifier != null ? (PsiElement)psiIdentifier : (PsiElement)repetitionInfoParam, "RepetitionInfo won't be injected for @Test methods", new LocalQuickFix[0]);
                                }
                            }
                        }
                    }
                }
            }
            {
                this.$holder = $captured_local_variable$0;
                this.$file = $captured_local_variable$1;
            }
        };
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/execution/junit/codeInsight/JUnit5MalformedRepeatedTestInspection$Annotations;", "", "()V", "NON_REPEATED_ANNOTATIONS", "", "", "getNON_REPEATED_ANNOTATIONS", "()Ljava/util/List;", "intellij.junit"})
    public static final class Annotations {
        @NotNull
        private static final List<String> NON_REPEATED_ANNOTATIONS;
        public static final Annotations INSTANCE;

        @NotNull
        public final List<String> getNON_REPEATED_ANNOTATIONS() {
            return NON_REPEATED_ANNOTATIONS;
        }

        private Annotations() {
        }

        static {
            Annotations annotations;
            INSTANCE = annotations = new Annotations();
            NON_REPEATED_ANNOTATIONS = CollectionsKt.listOf((Object[])new String[]{"org.junit.jupiter.api.Test", "org.junit.jupiter.api.TestFactory", "org.junit.jupiter.params.ParameterizedTest"});
        }
    }
}

