/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit.codeInsight.references;

import com.intellij.execution.junit.codeInsight.references.EnumSourceReference;
import com.intellij.execution.junit.codeInsight.references.MethodSourceReference;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.InitialPatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.position.FilterPattern;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JUnitReferenceContributor
extends PsiReferenceContributor {
    private static PsiElementPattern.Capture<PsiLiteral> getElementPattern(String annotation, String paramName) {
        return (PsiElementPattern.Capture)PlatformPatterns.psiElement(PsiLiteral.class).and((ElementPattern)new FilterPattern((ElementFilter)new TestAnnotationFilter(annotation, paramName)));
    }

    private static PsiElementPattern.Capture<PsiLiteral> getEnumSourceNamesPattern() {
        return (PsiElementPattern.Capture)JUnitReferenceContributor.getElementPattern("org.junit.jupiter.params.provider.EnumSource", "names").withAncestor(4, (ElementPattern)PlatformPatterns.psiElement(PsiAnnotation.class).and((ElementPattern)new PsiJavaElementPattern((InitialPatternCondition)new InitialPatternCondition<PsiAnnotation>(PsiAnnotation.class){

            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                PsiAnnotationMemberValue mode;
                if (o instanceof PsiAnnotation && (mode = ((PsiAnnotation)o).findAttributeValue("mode")) instanceof PsiReferenceExpression) {
                    String referenceName = ((PsiReferenceExpression)mode).getReferenceName();
                    return "INCLUDE".equals(referenceName) || "EXCLUDE".equals(referenceName);
                }
                return false;
            }
        })));
    }

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        registrar.registerReferenceProvider(JUnitReferenceContributor.getElementPattern("org.junit.jupiter.params.provider.MethodSource", "value"), new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                return new MethodSourceReference[]{new MethodSourceReference((PsiLiteral)element)};
            }
        });
        registrar.registerReferenceProvider(JUnitReferenceContributor.getEnumSourceNamesPattern(), new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                return new EnumSourceReference[]{new EnumSourceReference((PsiLiteral)element)};
            }
        });
        registrar.registerReferenceProvider(JUnitReferenceContributor.getElementPattern("org.junit.jupiter.params.provider.CsvFileSource", "resources"), new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                return FileReferenceSet.createSet((PsiElement)element, (boolean)false, (boolean)false, (boolean)false).getAllReferences();
            }
        });
    }

    private static class TestAnnotationFilter
    implements ElementFilter {
        private final String myAnnotation;
        private final String myParameterName;

        TestAnnotationFilter(String annotation, @NotNull @NonNls String parameterName) {
            this.myAnnotation = annotation;
            this.myParameterName = parameterName;
        }

        public boolean isAcceptable(Object element, PsiElement context) {
            PsiNameValuePair pair = (PsiNameValuePair)PsiTreeUtil.getParentOfType((PsiElement)context, PsiNameValuePair.class, (boolean)false, (Class[])new Class[]{PsiMember.class, PsiStatement.class, PsiCall.class});
            if (pair == null) {
                return false;
            }
            String name = (String)ObjectUtils.notNull((Object)pair.getName(), (Object)"value");
            if (!this.myParameterName.equals(name)) {
                return false;
            }
            PsiAnnotation annotation = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)pair, PsiAnnotation.class);
            if (annotation == null) {
                return false;
            }
            return this.myAnnotation.equals(annotation.getQualifiedName());
        }

        public boolean isClassAcceptable(Class hintClass) {
            return PsiLiteral.class.isAssignableFrom(hintClass);
        }
    }
}

