/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit.codeInsight.references;

import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.psiutils.TestUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodSourceReference
extends PsiReferenceBase<PsiLiteral> {
    public MethodSourceReference(PsiLiteral element) {
        super((PsiElement)element, false);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element instanceof PsiMethod) {
            return this.handleElementRename(((PsiMethod)element).getName());
        }
        return super.bindToElement(element);
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        String methodName = this.getValue();
        String className = StringUtil.getPackageName((String)methodName, (char)'#');
        boolean selfClassReference = className.isEmpty() || ClassUtil.findPsiClass((PsiManager)((PsiLiteral)this.getElement()).getManager(), (String)className, null, (boolean)false, (GlobalSearchScope)((PsiLiteral)this.getElement()).getResolveScope()) == null;
        return super.handleElementRename(selfClassReference ? newElementName : className + '#' + newElementName);
    }

    @Nullable
    public PsiElement resolve() {
        PsiClass cls = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), PsiClass.class);
        if (cls != null) {
            PsiClass aClass;
            String methodName = this.getValue();
            String className = StringUtil.getPackageName((String)methodName, (char)'#');
            if (!className.isEmpty() && (aClass = ClassUtil.findPsiClass((PsiManager)cls.getManager(), (String)className, null, (boolean)false, (GlobalSearchScope)cls.getResolveScope())) != null) {
                cls = aClass;
                methodName = StringUtil.getShortName((String)methodName, (char)'#');
            }
            PsiMethod[] methods = cls.findMethodsByName(methodName, false);
            return Arrays.stream(methods).filter(MethodSourceReference::staticNoParams).findFirst().orElse(methods.length == 0 ? null : methods[0]);
        }
        return null;
    }

    @NotNull
    public Object[] getVariants() {
        ArrayList<LookupElement> list = new ArrayList<LookupElement>();
        PsiClass topLevelClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), PsiClass.class);
        if (topLevelClass != null) {
            PsiMethod[] methods;
            PsiMethod current = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), PsiMethod.class);
            for (PsiMethod method : methods = topLevelClass.getMethods()) {
                if (current != null && method.getName().equals(current.getName()) || !MethodSourceReference.staticNoParams(method)) continue;
                LookupElementBuilder builder = LookupElementBuilder.create((PsiNamedElement)method);
                list.add(builder.withAutoCompletionPolicy(AutoCompletionPolicy.SETTINGS_DEPENDENT));
            }
        }
        return list.toArray();
    }

    private static boolean staticNoParams(PsiMethod method) {
        boolean isStatic = method.hasModifierProperty("static");
        return TestUtils.testInstancePerClass((PsiClass)Objects.requireNonNull(method.getContainingClass())) != isStatic && method.getParameterList().isEmpty();
    }
}

