/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profiler;

import com.android.tools.profiler.HttpURLAdapter;
import com.android.tools.profiler.InitializerAdapter;
import com.android.tools.profiler.OkHttpAdapter;
import com.android.tools.profiler.asm.ClassReader;
import com.android.tools.profiler.asm.ClassVisitor;
import com.android.tools.profiler.asm.ClassWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.logging.Logger;

public final class ProfilerTransform
implements BiConsumer<InputStream, OutputStream> {
    private static final Properties PROPERTIES = ProfilerTransform.loadTransformProperties();
    private static final boolean OKHTTP_PROFILING_ENABLED = "true".equals(PROPERTIES.getProperty("android.profiler.okhttp.enabled"));

    private static Logger getLog() {
        return Logger.getLogger(ProfilerTransform.class.getName());
    }

    @Override
    public void accept(InputStream in, OutputStream out) {
        ClassWriter writer;
        ClassVisitor visitor = writer = new ClassWriter(1);
        visitor = new InitializerAdapter(visitor);
        visitor = new HttpURLAdapter(visitor);
        if (OKHTTP_PROFILING_ENABLED) {
            visitor = new OkHttpAdapter(visitor);
        }
        try {
            ClassReader cr = new ClassReader(in);
            cr.accept(visitor, 0);
            out.write(writer.toByteArray());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static Properties loadTransformProperties() {
        Properties properties = new Properties();
        String propertiesFile = System.getProperty("android.profiler.properties");
        if (propertiesFile != null && !propertiesFile.trim().isEmpty()) {
            try (FileInputStream inputStream = new FileInputStream(propertiesFile);){
                properties.load(inputStream);
            }
            catch (FileNotFoundException e) {
                ProfilerTransform.getLog().warning("Profiler properties file cannot be found.");
            }
            catch (IOException e) {
                ProfilerTransform.getLog().warning("Profiler properties file is not read properly.");
            }
        }
        return properties;
    }
}

