/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.duplicateStringLiteral;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SuppressManager;
import com.intellij.codeInspection.ex.BaseLocalInspectionTool;
import com.intellij.codeInspection.i18n.JavaI18nUtil;
import com.intellij.find.findUsages.PsiElement2UsageTargetAdapter;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.search.LowLevelSearchUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.introduceField.IntroduceConstantHandler;
import com.intellij.refactoring.util.occurrences.BaseOccurrenceManager;
import com.intellij.refactoring.util.occurrences.OccurrenceManager;
import com.intellij.ui.DocumentAdapter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.StringSearcher;
import com.siyeh.ig.style.UnnecessarilyQualifiedStaticUsageInspection;
import gnu.trove.THashSet;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Stream;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DuplicateStringLiteralInspection
extends BaseLocalInspectionTool {
    public int MIN_STRING_LENGTH = 5;
    public boolean IGNORE_PROPERTY_KEYS;
    @NonNls
    private static final String BR = "<br>";

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        return new JavaElementVisitor(){

            public void visitReferenceExpression(PsiReferenceExpression expression) {
                this.visitExpression((PsiExpression)expression);
            }

            public void visitLiteralExpression(PsiLiteralExpression expression) {
                DuplicateStringLiteralInspection.this.checkStringLiteralExpression(expression, holder, isOnTheFly);
            }
        };
    }

    @NotNull
    public String getShortName() {
        return "DuplicateStringLiteralInspection";
    }

    @NotNull
    private static Set<PsiFile> getCandidateFiles(@NotNull String stringToFind, @NotNull Project project, int minStringLength) {
        GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)project);
        PsiSearchHelper searchHelper = PsiSearchHelper.getInstance((Project)project);
        List words = StringUtil.getWordsInStringLongestFirst((String)stringToFind);
        if (words.isEmpty()) {
            return Collections.emptySet();
        }
        THashSet resultFiles = null;
        for (String word : words) {
            if (word.length() < minStringLength) continue;
            ProgressManager.checkCanceled();
            THashSet files = new THashSet();
            Processor processor = Processors.cancelableCollectProcessor((Collection)files);
            searchHelper.processAllFilesWithWordInLiterals(word, scope, processor);
            if (resultFiles == null) {
                resultFiles = files;
            } else {
                resultFiles.retainAll((Collection<?>)files);
            }
            if (!resultFiles.isEmpty()) continue;
            return Collections.emptySet();
        }
        return resultFiles != null ? resultFiles : Collections.emptySet();
    }

    @NotNull
    private static List<PsiLiteralExpression> findDuplicateLiterals(@NotNull String stringToFind, boolean ignorePropertyKeys, Set<PsiFile> resultFiles) {
        if (resultFiles.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<PsiLiteralExpression> foundExpr = new ArrayList<PsiLiteralExpression>();
        for (PsiFile file : resultFiles) {
            ProgressManager.checkCanceled();
            FileViewProvider viewProvider = file.getViewProvider();
            if (viewProvider.getPsi((Language)JavaLanguage.INSTANCE) == null) continue;
            CharSequence text = viewProvider.getContents();
            StringSearcher searcher = new StringSearcher(stringToFind, true, true);
            LowLevelSearchUtil.processTextOccurrences((CharSequence)text, (int)0, (int)text.length(), (StringSearcher)searcher, (ProgressIndicator)ProgressManager.getInstance().getProgressIndicator(), offset -> {
                PsiElement element = file.findElementAt(offset);
                if (element == null || !(element.getParent() instanceof PsiLiteralExpression)) {
                    return true;
                }
                PsiLiteralExpression expression = (PsiLiteralExpression)element.getParent();
                if (Comparing.equal((Object)stringToFind, (Object)expression.getValue()) && DuplicateStringLiteralInspection.shouldCheck(expression, ignorePropertyKeys)) {
                    foundExpr.add(expression);
                }
                return true;
            });
        }
        return foundExpr;
    }

    /*
     * WARNING - void declaration
     */
    private void checkStringLiteralExpression(@NotNull PsiLiteralExpression originalExpression, @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        void var7_14;
        List<PsiLiteralExpression> foundExpr = this.getDuplicateLiterals(holder.getProject(), originalExpression);
        if (foundExpr.isEmpty()) {
            return;
        }
        THashSet classes = new THashSet();
        for (PsiElement psiElement : foundExpr) {
            void var7_9;
            PsiElement psiElement2;
            ProgressManager.checkCanceled();
            while ((psiElement2 = PsiTreeUtil.getParentOfType((PsiElement)var7_9, PsiClass.class)) != null && ((PsiClass)psiElement2).getQualifiedName() == null) {
            }
            if (psiElement2 == null) continue;
            classes.add((PsiClass)psiElement2);
        }
        if (classes.isEmpty()) {
            return;
        }
        List tenClassesMost = ContainerUtil.getFirstItems(Arrays.asList(classes.toArray(PsiClass.EMPTY_ARRAY)), (int)10);
        if (isOnTheFly) {
            String string = StringUtil.join((Collection)tenClassesMost, aClass -> {
                boolean thisFile = aClass.getContainingFile() == originalExpression.getContainingFile();
                return "&nbsp;&nbsp;&nbsp;'<b>" + aClass.getQualifiedName() + "</b>'" + (thisFile ? " " + InspectionsBundle.message((String)"inspection.duplicates.message.in.this.file", (Object[])new Object[0]) : "");
            }, (String)", <br>");
        } else {
            String string = StringUtil.join((Collection)tenClassesMost, aClass -> "'" + aClass.getQualifiedName() + "'", (String)", ");
        }
        if (classes.size() > tenClassesMost.size()) {
            void var7_12;
            String string = (String)var7_12 + BR + InspectionsBundle.message((String)"inspection.duplicates.message.more", (Object[])new Object[]{classes.size() - 10});
        }
        String msg = InspectionsBundle.message((String)"inspection.duplicates.message", (Object[])new Object[]{var7_14});
        SmartList fixes = new SmartList();
        if (isOnTheFly) {
            fixes.add(DuplicateStringLiteralInspection.createIntroduceConstFix(foundExpr, originalExpression));
            fixes.add(new NavigateToOccurrencesFix(originalExpression));
        }
        DuplicateStringLiteralInspection.createReplaceFixes(foundExpr, originalExpression, (Collection<? super LocalQuickFix>)fixes);
        LocalQuickFix[] array = fixes.toArray(LocalQuickFix.EMPTY_ARRAY);
        holder.registerProblem((PsiElement)originalExpression, msg, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, array);
    }

    @NotNull
    private List<PsiLiteralExpression> getDuplicateLiterals(@NotNull Project project, @NotNull PsiLiteralExpression place) {
        Object value = place.getValue();
        if (!(value instanceof String)) {
            return Collections.emptyList();
        }
        if (!DuplicateStringLiteralInspection.shouldCheck(place, this.IGNORE_PROPERTY_KEYS)) {
            return Collections.emptyList();
        }
        String stringToFind = (String)value;
        if (stringToFind.isEmpty()) {
            return Collections.emptyList();
        }
        Map map = (Map)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            ConcurrentMap duplicates = ConcurrentFactoryMap.createMap(t -> {
                Set<PsiFile> files = DuplicateStringLiteralInspection.getCandidateFiles((String)t.first, project, (Integer)t.third);
                return Collections.unmodifiableList(DuplicateStringLiteralInspection.findDuplicateLiterals((String)t.first, (Boolean)t.second, files));
            });
            return CachedValueProvider.Result.create((Object)duplicates, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
        return ContainerUtil.filter((Collection)((Collection)map.get(Trinity.create((Object)stringToFind, (Object)this.IGNORE_PROPERTY_KEYS, (Object)this.MIN_STRING_LENGTH))), literal -> literal != place);
    }

    private static boolean shouldCheck(@NotNull PsiLiteralExpression expression, boolean ignorePropertyKeys) {
        if (ignorePropertyKeys && JavaI18nUtil.mustBePropertyKey((PsiExpression)expression, null)) {
            return false;
        }
        return !SuppressManager.isSuppressedInspectionName((PsiLiteralExpression)expression);
    }

    private static void createReplaceFixes(@NotNull List<PsiLiteralExpression> foundExpr, @NotNull PsiLiteralExpression originalExpression, @NotNull Collection<? super LocalQuickFix> fixes) {
        THashSet constants = new THashSet();
        Iterator<PsiLiteralExpression> iterator = foundExpr.iterator();
        while (iterator.hasNext()) {
            PsiField field;
            PsiExpression expression1 = (PsiExpression)iterator.next();
            PsiElement parent = expression1.getParent();
            if (!(parent instanceof PsiField) || (field = (PsiField)parent).getInitializer() != expression1 || !field.hasModifierProperty("static")) continue;
            constants.add(field);
            iterator.remove();
        }
        for (PsiField constant : constants) {
            boolean isAccessible;
            PsiClass containingClass = constant.getContainingClass();
            if (containingClass == null || !(isAccessible = JavaPsiFacade.getInstance((Project)constant.getProject()).getResolveHelper().isAccessible((PsiMember)constant, (PsiElement)originalExpression, containingClass)) && containingClass.getQualifiedName() == null) continue;
            ReplaceFix replaceQuickFix = new ReplaceFix(constant, originalExpression);
            fixes.add((LocalQuickFix)replaceQuickFix);
        }
    }

    @NotNull
    private static LocalQuickFix createIntroduceConstFix(@NotNull List<PsiLiteralExpression> foundExpr, @NotNull PsiLiteralExpression originalExpression) {
        PsiLiteralExpression[] expressions = foundExpr.toArray(new PsiLiteralExpression[foundExpr.size() + 1]);
        expressions[foundExpr.size()] = originalExpression;
        return new IntroduceLiteralConstantFix(expressions);
    }

    @Nullable
    private static PsiReferenceExpression createReferenceTo(@NotNull PsiField constant) throws IncorrectOperationException {
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)constant.getProject()).getElementFactory();
        PsiReferenceExpression reference = (PsiReferenceExpression)factory.createExpressionFromText("XXX." + constant.getName(), null);
        PsiReferenceExpression classQualifier = (PsiReferenceExpression)reference.getQualifierExpression();
        PsiClass containingClass = constant.getContainingClass();
        if (containingClass.getQualifiedName() == null) {
            return null;
        }
        classQualifier.bindToElement((PsiElement)containingClass);
        if (reference.isReferenceTo((PsiElement)constant)) {
            return reference;
        }
        return null;
    }

    public boolean isEnabledByDefault() {
        return false;
    }

    public JComponent createOptionsPanel() {
        final OptionsPanel optionsPanel = new OptionsPanel();
        optionsPanel.myIgnorePropertyKeyExpressions.addActionListener(e -> {
            this.IGNORE_PROPERTY_KEYS = optionsPanel.myIgnorePropertyKeyExpressions.isSelected();
        });
        optionsPanel.myMinStringLengthField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                try {
                    DuplicateStringLiteralInspection.this.MIN_STRING_LENGTH = Integer.parseInt(optionsPanel.myMinStringLengthField.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        optionsPanel.myIgnorePropertyKeyExpressions.setSelected(this.IGNORE_PROPERTY_KEYS);
        optionsPanel.myMinStringLengthField.setText(Integer.toString(this.MIN_STRING_LENGTH));
        return optionsPanel.myPanel;
    }

    private class NavigateToOccurrencesFix
    extends LocalQuickFixOnPsiElement {
        NavigateToOccurrencesFix(PsiLiteralExpression representative) {
            super((PsiElement)representative);
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (!(startElement instanceof PsiLiteralExpression)) {
                return;
            }
            final PsiLiteralExpression literal = (PsiLiteralExpression)startElement;
            List duplicates = DuplicateStringLiteralInspection.this.getDuplicateLiterals(file.getProject(), literal);
            PsiLiteralExpression[] literalExpressions = (PsiLiteralExpression[])StreamEx.of((Collection)duplicates).append((Object)literal).toArray(PsiLiteralExpression.class);
            Usage[] usages = (Usage[])Stream.of(literalExpressions).map(UsageInfo::new).map(UsageInfo2UsageAdapter::new).toArray(Usage[]::new);
            UsageViewPresentation presentation = new UsageViewPresentation();
            String title = InspectionsBundle.message((String)"inspection.duplicates.occurrences.view.title", (Object[])new Object[]{literal.getValue()});
            presentation.setUsagesString(title);
            presentation.setTabName(title);
            presentation.setTabText(title);
            presentation.setShowCancelButton(true);
            UsageView view = UsageViewManager.getInstance((Project)project).showUsages(new UsageTarget[]{new PsiElement2UsageTargetAdapter((PsiElement)literal){

                public String getPresentableText() {
                    return "String literal: '" + literal.getValue() + "'";
                }
            }}, usages, presentation);
            view.addButtonToLowerPane(() -> {
                new IntroduceLiteralConstantFix(literalExpressions).applyFix(project);
                view.close();
            }, InspectionsBundle.message((String)"introduce.constant.across.the.project", (Object[])new Object[0]));
        }

        @NotNull
        public String getText() {
            return this.getFamilyName();
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return InspectionsBundle.message((String)"inspection.duplicates.navigate.to.occurrences", (Object[])new Object[0]);
        }
    }

    private static class ReplaceFix
    extends LocalQuickFixAndIntentionActionOnPsiElement {
        private final String myText;
        private final SmartPsiElementPointer<PsiField> myConst;

        private ReplaceFix(PsiField constant, PsiLiteralExpression originalExpression) {
            super((PsiElement)originalExpression);
            this.myText = InspectionsBundle.message((String)"inspection.duplicates.replace.quickfix", (Object[])new Object[]{PsiFormatUtil.formatVariable((PsiVariable)constant, (int)6145, (PsiSubstitutor)PsiSubstitutor.EMPTY)});
            this.myConst = SmartPointerManager.getInstance((Project)constant.getProject()).createSmartPsiElementPointer((PsiElement)constant);
        }

        @NotNull
        public String getText() {
            return this.myText;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            PsiLiteralExpression myOriginalExpression = (PsiLiteralExpression)startElement;
            PsiField myConstant = (PsiField)this.myConst.getElement();
            if (myConstant == null) {
                return;
            }
            PsiExpression initializer = myConstant.getInitializer();
            if (!(initializer instanceof PsiLiteralExpression)) {
                return;
            }
            try {
                PsiReferenceExpression newReference;
                PsiReferenceExpression reference = DuplicateStringLiteralInspection.createReferenceTo(myConstant);
                if (reference != null && UnnecessarilyQualifiedStaticUsageInspection.isUnnecessarilyQualifiedAccess((PsiJavaCodeReferenceElement)(newReference = (PsiReferenceExpression)myOriginalExpression.replace((PsiElement)reference)), (boolean)false, (boolean)false, (boolean)true)) {
                    newReference.getChildren()[0].delete();
                }
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }

        @NotNull
        public String getFamilyName() {
            return InspectionsBundle.message((String)"inspection.duplicates.replace.family.quickfix", (Object[])new Object[0]);
        }
    }

    private static class IntroduceLiteralConstantFix
    implements LocalQuickFix {
        private final SmartPsiElementPointer[] myExpressions;

        IntroduceLiteralConstantFix(PsiLiteralExpression[] expressions) {
            this.myExpressions = new SmartPsiElementPointer[expressions.length];
            for (int i = 0; i < expressions.length; ++i) {
                PsiLiteralExpression expression = expressions[i];
                this.myExpressions[i] = SmartPointerManager.getInstance((Project)expression.getProject()).createSmartPsiElementPointer((PsiElement)expression);
            }
        }

        @NotNull
        public String getFamilyName() {
            return InspectionsBundle.message((String)"introduce.constant.across.the.project", (Object[])new Object[0]);
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            this.applyFix(project);
        }

        private void applyFix(@NotNull Project project) {
            ArrayList<PsiExpression> expressions = new ArrayList<PsiExpression>();
            for (SmartPsiElementPointer ptr : this.myExpressions) {
                PsiElement element = ptr.getElement();
                if (element == null) continue;
                expressions.add((PsiExpression)element);
            }
            final PsiExpression[] expressionArray = expressions.toArray(PsiExpression.EMPTY_ARRAY);
            IntroduceConstantHandler handler = new IntroduceConstantHandler(){

                protected OccurrenceManager createOccurrenceManager(PsiExpression selectedExpr, PsiClass parentClass) {
                    return new BaseOccurrenceManager(occurrence -> true){

                        protected PsiExpression[] defaultOccurrences() {
                            return expressionArray;
                        }

                        protected PsiExpression[] findOccurrences() {
                            return expressionArray;
                        }
                    };
                }
            };
            handler.invoke(project, expressionArray);
        }
    }

    public static class OptionsPanel {
        private JTextField myMinStringLengthField;
        private JPanel myPanel;
        private JCheckBox myIgnorePropertyKeyExpressions;

        public OptionsPanel() {
            this.$$$setupUI$$$();
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JCheckBox jCheckBox;
            JTextField jTextField;
            JPanel jPanel;
            this.myPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
            this.myMinStringLengthField = jTextField = new JTextField();
            jTextField.setColumns(3);
            jPanel.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 0, 0, null, new Dimension(40, -1), null));
            JLabel jLabel = new JLabel();
            this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/InspectionsBundle").getString("inspection.duplicates.option"));
            jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myIgnorePropertyKeyExpressions = jCheckBox = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/InspectionsBundle").getString("inspection.duplicates.option.report.propertykey.expressions"));
            jPanel.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 3, 8, 0, 3, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 3, 0, 2, 1, 6, null, null, null));
            Spacer spacer2 = new Spacer();
            jPanel.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
            jLabel.setLabelFor(jTextField);
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myPanel;
        }

        private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            jLabel.setText(stringBuffer.toString());
            if (bl) {
                jLabel.setDisplayedMnemonic(c);
                jLabel.setDisplayedMnemonicIndex(n);
            }
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }
}

