/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.i18n;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.i18n.I18nQuickFixHandler;
import com.intellij.codeInspection.i18n.I18nizeConcatenationQuickFix;
import com.intellij.codeInspection.i18n.I18nizeHandlerProvider;
import com.intellij.codeInspection.i18n.I18nizeQuickFix;
import com.intellij.codeInspection.i18n.JavaI18nUtil;
import com.intellij.codeInspection.i18n.JavaI18nizeQuickFixDialog;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.ResourceBundleManager;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class I18nizeAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.i18n.I18nizeAction");

    public void update(@NotNull AnActionEvent e) {
        boolean active;
        boolean bl = active = I18nizeAction.getHandler(e) != null;
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            e.getPresentation().setVisible(active);
        } else {
            e.getPresentation().setEnabled(active);
        }
    }

    @Nullable
    public static I18nQuickFixHandler getHandler(AnActionEvent e) {
        Editor editor = I18nizeAction.getEditor(e);
        if (editor == null) {
            return null;
        }
        PsiFile psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        if (psiFile == null) {
            return null;
        }
        return I18nizeAction.getHandler(editor, psiFile);
    }

    @Nullable
    public static I18nQuickFixHandler getHandler(@NotNull Editor editor, @NotNull PsiFile psiFile) {
        TextRange range = JavaI18nUtil.getSelectedRange(editor, psiFile);
        if (range == null) {
            return null;
        }
        PsiLiteralExpression literalExpression = I18nizeAction.getEnclosingStringLiteral(psiFile, editor);
        PsiElement element = psiFile.findElementAt(editor.getCaretModel().getOffset());
        if (element == null) {
            return null;
        }
        if (I18nizeConcatenationQuickFix.getEnclosingLiteralConcatenation(element) != null) {
            return new I18nizeConcatenationQuickFix();
        }
        if (literalExpression != null && literalExpression.getTextRange().contains(range)) {
            return new I18nizeQuickFix();
        }
        for (I18nizeHandlerProvider handlerProvider : (I18nizeHandlerProvider[])I18nizeHandlerProvider.EP_NAME.getExtensions()) {
            I18nQuickFixHandler handler = handlerProvider.getHandler(psiFile, editor, range);
            if (handler == null) continue;
            return handler;
        }
        return null;
    }

    @Nullable
    public static PsiLiteralExpression getEnclosingStringLiteral(PsiFile psiFile, Editor editor) {
        PsiElement psiElement = psiFile.findElementAt(editor.getCaretModel().getOffset());
        if (psiElement == null) {
            return null;
        }
        PsiLiteralExpression expression = (PsiLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiLiteralExpression.class);
        if (expression == null || !(expression.getValue() instanceof String)) {
            return null;
        }
        return expression;
    }

    private static Editor getEditor(AnActionEvent e) {
        return (Editor)CommonDataKeys.EDITOR.getData(e.getDataContext());
    }

    public static void doI18nSelectedString(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile, @NotNull I18nQuickFixHandler handler) {
        try {
            handler.checkApplicability(psiFile, editor);
        }
        catch (IncorrectOperationException ex) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)ex.getMessage(), (String)CodeInsightBundle.message((String)"i18nize.error.title", (Object[])new Object[0]), null);
            return;
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            JavaI18nizeQuickFixDialog.isAvailable(psiFile);
        }
        try {
            ResourceBundleManager.getManager(psiFile);
        }
        catch (ResourceBundleManager.ResourceBundleNotFoundException e) {
            return;
        }
        JavaI18nizeQuickFixDialog dialog = handler.createDialog(project, editor, psiFile);
        if (dialog == null) {
            return;
        }
        if (!dialog.showAndGet()) {
            return;
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(psiFile)) {
            return;
        }
        Collection propertiesFiles = dialog.getAllPropertiesFiles();
        for (PropertiesFile file : propertiesFiles) {
            if (FileModificationService.getInstance().prepareFileForWrite(file.getContainingFile())) continue;
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> CommandProcessor.getInstance().executeCommand(project, () -> {
            try {
                handler.performI18nization(psiFile, editor, dialog.getLiteralExpression(), propertiesFiles, dialog.getKey(), StringUtil.unescapeStringCharacters((String)dialog.getValue()), dialog.getI18nizedText(), dialog.getParameters(), dialog.getPropertyCreationHandler());
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }, CodeInsightBundle.message((String)"quickfix.i18n.command.name", (Object[])new Object[0]), (Object)project));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Editor editor = I18nizeAction.getEditor(e);
        Project project = editor.getProject();
        assert (project != null);
        PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(e.getDataContext());
        if (psiFile == null) {
            return;
        }
        I18nQuickFixHandler handler = I18nizeAction.getHandler(e);
        if (handler == null) {
            return;
        }
        I18nizeAction.doI18nSelectedString(project, editor, psiFile, handler);
    }
}

