/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.i18n;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.template.macro.MacroUtil;
import com.intellij.lang.properties.BundleNameEvaluator;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.PropertiesReferenceManager;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.PropertyCreationHandler;
import com.intellij.lang.properties.references.I18nUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import gnu.trove.THashSet;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UNamedExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastLiteralUtils;
import org.jetbrains.uast.UastUtils;

public class JavaI18nUtil
extends I18nUtil {
    public static final PropertyCreationHandler DEFAULT_PROPERTY_CREATION_HANDLER = (project, propertiesFiles, key, value, parameters) -> JavaI18nUtil.createProperty((Project)project, (Collection)propertiesFiles, (String)key, (String)value, (boolean)true);

    private JavaI18nUtil() {
    }

    @Nullable
    public static TextRange getSelectedRange(Editor editor, PsiFile psiFile) {
        if (editor == null) {
            return null;
        }
        String selectedText = editor.getSelectionModel().getSelectedText();
        if (selectedText != null) {
            return new TextRange(editor.getSelectionModel().getSelectionStart(), editor.getSelectionModel().getSelectionEnd());
        }
        PsiElement psiElement = psiFile.findElementAt(editor.getCaretModel().getOffset());
        if (psiElement == null || psiElement instanceof PsiWhiteSpace) {
            return null;
        }
        return psiElement.getTextRange();
    }

    public static boolean mustBePropertyKey(@NotNull PsiExpression expression, @Nullable Ref<? super PsiAnnotationMemberValue> resourceBundleRef) {
        PsiAnnotation annotation;
        PsiElement parent = expression.getParent();
        if (parent instanceof PsiVariable && (annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)((PsiVariable)parent), (String[])new String[]{"org.jetbrains.annotations.PropertyKey"})) != null) {
            JavaI18nUtil.processAnnotationAttributes(resourceBundleRef, annotation);
            return true;
        }
        return JavaI18nUtil.isPassedToAnnotatedParam(expression, "org.jetbrains.annotations.PropertyKey", resourceBundleRef, null);
    }

    public static boolean mustBePropertyKey(@NotNull UExpression expression, @Nullable Ref<? super UExpression> resourceBundleRef) {
        UAnnotation annotation;
        UElement parent = expression.getUastParent();
        if (parent instanceof UVariable && (annotation = ((UVariable)parent).findAnnotation("org.jetbrains.annotations.PropertyKey")) != null) {
            JavaI18nUtil.processAnnotationAttributes(resourceBundleRef, annotation);
            return true;
        }
        UCallExpression callExpression = UastUtils.getUCallExpression((UElement)expression);
        if (callExpression == null) {
            return false;
        }
        PsiMethod psiMethod = callExpression.resolve();
        if (psiMethod == null) {
            return false;
        }
        PsiParameter parameter = UastUtils.getParameterForArgument((UCallExpression)callExpression, (UExpression)expression);
        if (parameter == null) {
            return false;
        }
        int paramIndex = ArrayUtil.indexOf((Object[])psiMethod.getParameterList().getParameters(), (Object)parameter);
        if (paramIndex == -1) {
            return false;
        }
        return JavaI18nUtil.isMethodParameterAnnotatedWith(psiMethod, paramIndex, null, "org.jetbrains.annotations.PropertyKey", null, null);
    }

    static boolean isPassedToAnnotatedParam(@NotNull PsiExpression expression, String annFqn, @Nullable Ref<? super PsiAnnotationMemberValue> resourceBundleRef, @Nullable Set<? super PsiModifierListOwner> nonNlsTargets) {
        PsiElement parent = (expression = JavaI18nUtil.getTopLevelExpression(expression)).getParent();
        if (!(parent instanceof PsiExpressionList)) {
            return false;
        }
        int idx = ArrayUtil.indexOf((Object[])((PsiExpressionList)parent).getExpressions(), (Object)expression);
        if (idx == -1) {
            return false;
        }
        PsiElement grParent = parent.getParent();
        if (grParent instanceof PsiAnonymousClass) {
            grParent = grParent.getParent();
        }
        if (grParent instanceof PsiCall) {
            PsiMethod method = ((PsiCall)grParent).resolveMethod();
            return method != null && JavaI18nUtil.isMethodParameterAnnotatedWith(method, idx, null, annFqn, resourceBundleRef, nonNlsTargets);
        }
        return false;
    }

    @NotNull
    static PsiExpression getTopLevelExpression(@NotNull PsiExpression expression) {
        PsiExpression parent;
        while (!(!(expression.getParent() instanceof PsiExpression) || (parent = (PsiExpression)expression.getParent()) instanceof PsiConditionalExpression && ((PsiConditionalExpression)parent).getCondition() == expression || (expression = parent) instanceof PsiAssignmentExpression)) {
        }
        return expression;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean isMethodParameterAnnotatedWith(PsiMethod method, int idx, @Nullable Collection<? super PsiMethod> processed, String annFqn, @Nullable Ref<? super PsiAnnotationMemberValue> resourceBundleRef, @Nullable Set<? super PsiModifierListOwner> nonNlsTargets) {
        PsiMethod[] superMethods;
        PsiAnnotation annotation;
        PsiParameter param;
        if (processed != null) {
            if (processed.contains(method)) {
                return false;
            }
        } else {
            processed = new THashSet();
        }
        processed.add(method);
        PsiParameter[] params = method.getParameterList().getParameters();
        if (idx >= params.length) {
            if (params.length == 0) {
                return false;
            }
            PsiParameter lastParam = params[params.length - 1];
            if (!lastParam.isVarArgs()) return false;
            param = lastParam;
        } else {
            param = params[idx];
        }
        if ((annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)param, (String[])new String[]{annFqn})) != null) {
            JavaI18nUtil.processAnnotationAttributes(resourceBundleRef, annotation);
            return true;
        }
        if (nonNlsTargets != null) {
            nonNlsTargets.add((PsiModifierListOwner)param);
        }
        for (PsiMethod superMethod : superMethods = method.findSuperMethods()) {
            if (!JavaI18nUtil.isMethodParameterAnnotatedWith(superMethod, idx, (Collection<? super PsiMethod>)processed, annFqn, resourceBundleRef, null)) continue;
            return true;
        }
        return false;
    }

    private static void processAnnotationAttributes(@Nullable Ref<? super PsiAnnotationMemberValue> resourceBundleRef, @NotNull PsiAnnotation annotation) {
        if (resourceBundleRef != null) {
            PsiNameValuePair[] attributes;
            PsiAnnotationParameterList parameterList = annotation.getParameterList();
            for (PsiNameValuePair attribute : attributes = parameterList.getAttributes()) {
                String name = attribute.getName();
                if (!"resourceBundle".equals(name)) continue;
                resourceBundleRef.set((Object)attribute.getValue());
            }
        }
    }

    private static void processAnnotationAttributes(@Nullable Ref<? super UExpression> resourceBundleRef, @NotNull UAnnotation annotation) {
        if (resourceBundleRef != null) {
            for (UNamedExpression attribute : annotation.getAttributeValues()) {
                String name = attribute.getName();
                if (!"resourceBundle".equals(name)) continue;
                resourceBundleRef.set((Object)attribute.getExpression());
            }
        }
    }

    static boolean isValidPropertyReference(@NotNull Project project, @NotNull PsiExpression expression, @NotNull String key, @NotNull Ref<? super String> outResourceBundle) {
        Ref resourceBundleRef = Ref.create();
        if (JavaI18nUtil.mustBePropertyKey(expression, (Ref<? super PsiAnnotationMemberValue>)resourceBundleRef)) {
            Object resourceBundleName = resourceBundleRef.get();
            if (!(resourceBundleName instanceof PsiExpression)) {
                return false;
            }
            PsiExpression expr = (PsiExpression)resourceBundleName;
            PsiConstantEvaluationHelper constantEvaluationHelper = JavaPsiFacade.getInstance((Project)project).getConstantEvaluationHelper();
            Object value = constantEvaluationHelper.computeConstantExpression((PsiElement)expr);
            if (value == null) {
                PsiElement resolve;
                if (expr instanceof PsiReferenceExpression && (resolve = ((PsiReferenceExpression)expr).resolve()) instanceof PsiField && ((PsiField)resolve).hasModifierProperty("final") && (value = constantEvaluationHelper.computeConstantExpression((PsiElement)((PsiField)resolve).getInitializer())) == null) {
                    return false;
                }
                if (value == null) {
                    ResourceBundle resourceBundle = JavaI18nUtil.resolveResourceBundleByKey(key, project);
                    if (resourceBundle == null) {
                        return false;
                    }
                    PropertiesFile defaultPropertiesFile = resourceBundle.getDefaultPropertiesFile();
                    String bundleName = BundleNameEvaluator.DEFAULT.evaluateBundleName(defaultPropertiesFile.getContainingFile());
                    if (bundleName == null) {
                        return false;
                    }
                    value = bundleName;
                }
            }
            String bundleName = value.toString();
            outResourceBundle.set((Object)bundleName);
            return JavaI18nUtil.isPropertyRef(expression, key, bundleName);
        }
        return true;
    }

    @Nullable
    private static ResourceBundle resolveResourceBundleByKey(@NotNull String key, @NotNull Project project) {
        Ref bundleRef = Ref.create();
        boolean r = PropertiesReferenceManager.getInstance((Project)project).processAllPropertiesFiles((baseName, propertiesFile) -> {
            if (propertiesFile.findPropertyByKey(key) != null) {
                if (bundleRef.get() == null) {
                    bundleRef.set((Object)propertiesFile.getResourceBundle());
                } else {
                    return ((ResourceBundle)bundleRef.get()).equals(propertiesFile.getResourceBundle());
                }
            }
            return true;
        });
        return r ? (ResourceBundle)bundleRef.get() : null;
    }

    static boolean isPropertyRef(PsiExpression expression, String key, String resourceBundleName) {
        if (resourceBundleName == null) {
            return !PropertiesImplUtil.findPropertiesByKey((Project)expression.getProject(), (String)key).isEmpty();
        }
        List propertiesFiles = JavaI18nUtil.propertiesFilesByBundleName((String)resourceBundleName, (PsiElement)expression);
        boolean containedInPropertiesFile = false;
        for (PropertiesFile propertiesFile : propertiesFiles) {
            containedInPropertiesFile |= propertiesFile.findPropertyByKey(key) != null;
        }
        return containedInPropertiesFile;
    }

    public static Set<String> suggestExpressionOfType(PsiClassType type, PsiLiteralExpression context) {
        PsiExpression[] expressions;
        PsiVariable[] variables = MacroUtil.getVariablesVisibleAt((PsiElement)context, (String)"");
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (PsiVariable var : variables) {
            PsiType varType = var.getType();
            PsiIdentifier identifier = var.getNameIdentifier();
            if (type != null && !type.isAssignableFrom(varType) || identifier == null) continue;
            result.add(identifier.getText());
        }
        for (PsiExpression expression : expressions = MacroUtil.getStandardExpressionsOfType((PsiElement)context, (PsiType)type)) {
            result.add(expression.getText());
        }
        if (type != null) {
            JavaI18nUtil.addAvailableMethodsOfType(type, context, result);
        }
        return result;
    }

    private static void addAvailableMethodsOfType(PsiClassType type, PsiLiteralExpression context, Collection<? super String> result) {
        PsiScopesUtil.treeWalkUp((element, state) -> {
            PsiMethod method;
            PsiType returnType;
            if (element instanceof PsiMethod && (returnType = (method = (PsiMethod)element).getReturnType()) != null && TypeConversionUtil.isAssignable((PsiType)type, (PsiType)returnType) && method.getParameterList().isEmpty()) {
                result.add(method.getName() + "()");
            }
            return true;
        }, (PsiElement)context, null);
    }

    public static int getPropertyValuePlaceholdersCount(@NotNull String propertyValue) {
        try {
            return new MessageFormat(propertyValue).getFormatsByArgumentIndex().length;
        }
        catch (IllegalArgumentException e) {
            return 0;
        }
    }

    public static int getPropertyValueParamsMaxCount(@NotNull UExpression expression) {
        SortedSet<Integer> paramsCount = JavaI18nUtil.getPropertyValueParamsCount(expression, null);
        if (paramsCount.isEmpty()) {
            return -1;
        }
        return paramsCount.last();
    }

    @NotNull
    static SortedSet<Integer> getPropertyValueParamsCount(@NotNull PsiExpression expression, @Nullable String resourceBundleName) {
        UExpression uExpression = (UExpression)UastContextKt.toUElement((PsiElement)expression, UExpression.class);
        if (uExpression == null) {
            return new TreeSet<Integer>();
        }
        return JavaI18nUtil.getPropertyValueParamsCount(uExpression, resourceBundleName);
    }

    @NotNull
    private static SortedSet<Integer> getPropertyValueParamsCount(@NotNull UExpression expression, @Nullable String resourceBundleName) {
        ULiteralExpression literalExpression;
        if (expression instanceof ULiteralExpression) {
            literalExpression = (ULiteralExpression)expression;
        } else if (expression instanceof UReferenceExpression) {
            PsiElement resolved = ((UReferenceExpression)expression).resolve();
            PsiField field = resolved == null ? null : (PsiField)resolved;
            literalExpression = field != null && field.hasModifierProperty("final") && field.getInitializer() instanceof PsiLiteralExpression ? (ULiteralExpression)UastContextKt.toUElement((PsiElement)field.getInitializer(), ULiteralExpression.class) : null;
        } else {
            literalExpression = null;
        }
        TreeSet<Integer> paramsCount = new TreeSet<Integer>();
        if (literalExpression == null) {
            return paramsCount;
        }
        for (PsiReference reference : UastLiteralUtils.getInjectedReferences((ULiteralExpression)literalExpression)) {
            if (!(reference instanceof PsiPolyVariantReference)) continue;
            for (ResolveResult result : ((PsiPolyVariantReference)reference).multiResolve(false)) {
                if (!result.isValidResult() || !(result.getElement() instanceof IProperty)) continue;
                try {
                    String propertyValue;
                    PsiFile file;
                    IProperty property = (IProperty)result.getElement();
                    if (resourceBundleName != null && !resourceBundleName.equals(BundleNameEvaluator.DEFAULT.evaluateBundleName(file = property.getPropertiesFile().getContainingFile())) || (propertyValue = property.getValue()) == null) continue;
                    paramsCount.add(JavaI18nUtil.getPropertyValuePlaceholdersCount(propertyValue));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        return paramsCount;
    }
}

