/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.i18n.folding;

import com.intellij.codeInsight.folding.JavaCodeFoldingSettings;
import com.intellij.codeInspection.i18n.JavaI18nUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.StdLanguages;
import com.intellij.lang.folding.FoldingBuilderEx;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.lang.folding.NamedFoldingDescriptor;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.parsing.PropertiesElementTypes;
import com.intellij.lang.properties.psi.Property;
import com.intellij.lang.properties.psi.PropertyStub;
import com.intellij.lang.properties.psi.impl.PropertyImpl;
import com.intellij.lang.properties.psi.impl.PropertyStubImpl;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastLiteralUtils;

public class PropertyFoldingBuilder
extends FoldingBuilderEx {
    private static final int FOLD_MAX_LENGTH = 50;
    private static final Key<IProperty> CACHE = Key.create((String)"i18n.property.cache");
    public static final IProperty NULL = new PropertyImpl((PropertyStub)new PropertyStubImpl(null, null), PropertiesElementTypes.PROPERTY);

    @NotNull
    public FoldingDescriptor[] buildFoldRegions(@NotNull PsiElement element, @NotNull Document document, boolean quick) {
        if (!(element instanceof PsiFile) || quick || !PropertyFoldingBuilder.isFoldingsOn()) {
            return FoldingDescriptor.EMPTY;
        }
        PsiFile file = (PsiFile)element;
        final ArrayList result = new ArrayList();
        boolean hasJsp = ContainerUtil.intersects(Arrays.asList(StdLanguages.JSP, StdLanguages.JSPX), (Collection)file.getViewProvider().getLanguages());
        file.accept((PsiElementVisitor)(hasJsp ? new JavaRecursiveElementWalkingVisitor(){

            public void visitLiteralExpression(PsiLiteralExpression expression) {
                ProgressManager.checkCanceled();
                ULiteralExpression uLiteralExpression = (ULiteralExpression)UastContextKt.toUElement((PsiElement)expression, ULiteralExpression.class);
                if (uLiteralExpression != null) {
                    PropertyFoldingBuilder.checkLiteral(uLiteralExpression, result);
                }
            }
        } : new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(PsiElement element) {
                ProgressManager.checkCanceled();
                ULiteralExpression uLiteralExpression = (ULiteralExpression)UastContextKt.toUElement((PsiElement)element, ULiteralExpression.class);
                if (uLiteralExpression != null) {
                    PropertyFoldingBuilder.checkLiteral(uLiteralExpression, result);
                }
                super.visitElement(element);
            }
        }));
        return result.toArray(FoldingDescriptor.EMPTY);
    }

    private static boolean isFoldingsOn() {
        return JavaCodeFoldingSettings.getInstance().isCollapseI18nMessages();
    }

    private static void checkLiteral(ULiteralExpression expression, List<? super FoldingDescriptor> result) {
        PsiElement sourcePsi = expression.getSourcePsi();
        if (sourcePsi == null) {
            return;
        }
        if (!PropertyFoldingBuilder.isI18nProperty(expression)) {
            return;
        }
        IProperty property = PropertyFoldingBuilder.getI18nProperty(expression);
        HashSet<IProperty> set = new HashSet<IProperty>();
        set.add((IProperty)(property != null ? property : PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT));
        String msg = PropertyFoldingBuilder.formatI18nProperty(expression, property);
        UElement parent = expression.getUastParent();
        if (!msg.equals(UastLiteralUtils.getValueIfStringLiteral((UElement)expression)) && parent instanceof UCallExpression && ((UExpression)((UCallExpression)parent).getValueArguments().get(0)).getSourcePsi() == expression.getSourcePsi()) {
            UCallExpression expressions = (UCallExpression)parent;
            PsiElement callSourcePsi = expressions.getSourcePsi();
            if (callSourcePsi == null) {
                return;
            }
            int count = JavaI18nUtil.getPropertyValueParamsMaxCount((UExpression)expression);
            List args = expressions.getValueArguments();
            if (args.size() == 1 + count) {
                boolean ok = true;
                for (int i = 1; i < count + 1; ++i) {
                    Object value = ((UExpression)args.get(i)).evaluate();
                    if (value != null || args.get(i) instanceof UReferenceExpression) continue;
                    ok = false;
                    break;
                }
                if (ok) {
                    UExpression receiver = expressions.getReceiver();
                    PsiElement receiverSourcePsi = receiver != null ? receiver.getSourcePsi() : null;
                    PsiElement elementToFold = null;
                    if (receiverSourcePsi != null) {
                        elementToFold = PsiTreeUtil.findCommonParent((PsiElement)callSourcePsi, (PsiElement)receiverSourcePsi);
                    }
                    if (elementToFold == null) {
                        elementToFold = callSourcePsi;
                    }
                    result.add((FoldingDescriptor)new NamedFoldingDescriptor((ASTNode)ObjectUtils.assertNotNull((Object)elementToFold.getNode()), elementToFold.getTextRange(), null, PropertyFoldingBuilder.formatMethodCallExpression(expressions), Boolean.valueOf(PropertyFoldingBuilder.isFoldingsOn()), set));
                    return;
                }
            }
        }
        result.add((FoldingDescriptor)new NamedFoldingDescriptor((ASTNode)ObjectUtils.assertNotNull((Object)sourcePsi.getNode()), sourcePsi.getTextRange(), null, PropertyFoldingBuilder.getI18nMessage(expression), Boolean.valueOf(PropertyFoldingBuilder.isFoldingsOn()), set));
    }

    public String getPlaceholderText(@NotNull ASTNode node) {
        return null;
    }

    @NotNull
    private static String formatMethodCallExpression(@NotNull UCallExpression methodCallExpression) {
        List args = methodCallExpression.getValueArguments();
        PsiElement callSourcePsi = methodCallExpression.getSourcePsi();
        if (args.size() > 0 && args.get(0) instanceof ULiteralExpression && PropertyFoldingBuilder.isI18nProperty((ULiteralExpression)args.get(0))) {
            int count = JavaI18nUtil.getPropertyValueParamsMaxCount((UExpression)args.get(0));
            if (args.size() == 1 + count) {
                String text = PropertyFoldingBuilder.getI18nMessage((ULiteralExpression)args.get(0));
                for (int i = 1; i < count + 1; ++i) {
                    Object value = ((UExpression)args.get(i)).evaluate();
                    if (value == null) {
                        if (args.get(i) instanceof UReferenceExpression) {
                            PsiElement sourcePsi = ((UExpression)args.get(i)).getSourcePsi();
                            value = "{" + (sourcePsi != null ? sourcePsi.getText() : "<error>") + "}";
                        } else {
                            text = null;
                            break;
                        }
                    }
                    text = text.replace("{" + (i - 1) + "}", value.toString());
                }
                if (text != null) {
                    return text.length() > 50 ? text.substring(0, 47) + "...\"" : text;
                }
            }
        }
        return callSourcePsi != null ? callSourcePsi.getText() : "<error>";
    }

    @NotNull
    private static String getI18nMessage(@NotNull ULiteralExpression literal) {
        IProperty property = PropertyFoldingBuilder.getI18nProperty(literal);
        return property == null ? UastLiteralUtils.getValueIfStringLiteral((UElement)literal) : PropertyFoldingBuilder.formatI18nProperty(literal, property);
    }

    @Nullable
    public static IProperty getI18nProperty(@NotNull ULiteralExpression literal) {
        PsiElement sourcePsi = literal.getSourcePsi();
        if (sourcePsi == null) {
            return null;
        }
        Property property = (Property)sourcePsi.getUserData(CACHE);
        if (property == NULL) {
            return null;
        }
        if (property != null && PropertyFoldingBuilder.isValid(property, literal)) {
            return property;
        }
        if (PropertyFoldingBuilder.isI18nProperty(literal)) {
            Iterable references = UastLiteralUtils.getInjectedReferences((ULiteralExpression)literal);
            for (PsiReference reference : references) {
                if (reference instanceof PsiPolyVariantReference) {
                    ResolveResult[] results;
                    for (ResolveResult result : results = ((PsiPolyVariantReference)reference).multiResolve(false)) {
                        PsiElement element = result.getElement();
                        if (!(element instanceof IProperty)) continue;
                        IProperty p = (IProperty)element;
                        sourcePsi.putUserData(CACHE, (Object)p);
                        return p;
                    }
                    continue;
                }
                PsiElement element = reference.resolve();
                if (!(element instanceof IProperty)) continue;
                IProperty p = (IProperty)element;
                sourcePsi.putUserData(CACHE, (Object)p);
                return p;
            }
        }
        return null;
    }

    private static boolean isValid(Property property, ULiteralExpression literal) {
        if (literal == null || property == null || !property.isValid()) {
            return false;
        }
        Object result = literal.evaluate();
        if (!(result instanceof String)) {
            return false;
        }
        return StringUtil.unquoteString((String)((String)result)).equals(property.getKey());
    }

    @NotNull
    private static String formatI18nProperty(@NotNull ULiteralExpression literal, IProperty property) {
        Object evaluated = literal.evaluate();
        return property == null ? (evaluated != null ? evaluated.toString() : "null") : "\"" + property.getValue() + "\"";
    }

    public boolean isCollapsedByDefault(@NotNull ASTNode node) {
        return PropertyFoldingBuilder.isFoldingsOn();
    }

    public static boolean isI18nProperty(@NotNull PsiLiteralExpression expr) {
        ULiteralExpression uLiteralExpression = (ULiteralExpression)UastContextKt.toUElement((PsiElement)expr, ULiteralExpression.class);
        if (uLiteralExpression == null) {
            return false;
        }
        return PropertyFoldingBuilder.isI18nProperty(uLiteralExpression);
    }

    public static boolean isI18nProperty(@NotNull ULiteralExpression expr) {
        if (!expr.isString()) {
            return false;
        }
        PsiElement sourcePsi = expr.getSourcePsi();
        if (sourcePsi == null) {
            return false;
        }
        IProperty property = (IProperty)sourcePsi.getUserData(CACHE);
        if (property == NULL) {
            return false;
        }
        if (property != null) {
            return true;
        }
        boolean isI18n = JavaI18nUtil.mustBePropertyKey((UExpression)expr, null);
        if (!isI18n) {
            sourcePsi.putUserData(CACHE, (Object)NULL);
        }
        return isI18n;
    }
}

