/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.i18n.inconsistentResourceBundle;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.i18n.inconsistentResourceBundle.InconsistentResourceBundleInspectionProvider;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.BidirectionalMap;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class InconsistentPropertiesEndsInspectionProvider
implements InconsistentResourceBundleInspectionProvider {
    private static final Set<Character> PROPERTY_VALUE_END_CHECK_SYMBOLS = ContainerUtil.newTroveSet((Object[])new Character[]{Character.valueOf('!'), Character.valueOf('?'), Character.valueOf('.'), Character.valueOf(':'), Character.valueOf(';')});
    private static final char NULL = '\u0000';

    @Override
    @NotNull
    public String getName() {
        return "REPORT_INCONSISTENT_PROPERTIES_ENDS";
    }

    @Override
    @NotNull
    public String getPresentableName() {
        return InspectionsBundle.message((String)"inconsistent.bundle.report.inconsistent.properties.ends", (Object[])new Object[0]);
    }

    @Override
    public void check(BidirectionalMap<PropertiesFile, PropertiesFile> parents, List<? extends PropertiesFile> files, Map<PropertiesFile, Set<String>> keysUpToParent, Map<PropertiesFile, Map<String, String>> propertiesFilesNamesMaps, InspectionManager manager, RefManager refManager, ProblemDescriptionsProcessor processor) {
        for (PropertiesFile propertiesFile : files) {
            THashSet filePropertyKeys = new THashSet(propertiesFilesNamesMaps.get(propertiesFile).keySet());
            PropertiesFile parent = (PropertiesFile)parents.get((Object)propertiesFile);
            while (parent != null) {
                Collection commonKeys = ContainerUtil.intersection(propertiesFilesNamesMaps.get(parent).keySet(), (Collection)filePropertyKeys);
                for (String commonKey : commonKeys) {
                    char parentLastChar;
                    String parentPropertyValue;
                    char lastChar;
                    IProperty property = propertiesFile.findPropertyByKey(commonKey);
                    assert (property != null);
                    String propertyValue = property.getValue();
                    if (StringUtil.isEmptyOrSpaces((String)propertyValue) || !PROPERTY_VALUE_END_CHECK_SYMBOLS.contains(Character.valueOf(lastChar = propertyValue.charAt(propertyValue.length() - 1))) || (parentPropertyValue = propertiesFilesNamesMaps.get(parent).get(commonKey)) == null || lastChar == (parentLastChar = parentPropertyValue.isEmpty() ? (char)'\u0000' : parentPropertyValue.charAt(parentPropertyValue.length() - 1))) continue;
                    String message = PROPERTY_VALUE_END_CHECK_SYMBOLS.contains(Character.valueOf(parentLastChar)) ? InspectionsBundle.message((String)"inconsistent.bundle.property.inconsistent.end.parent.end.from.check.symbols", (Object[])new Object[]{Character.valueOf(lastChar), Character.valueOf(parentLastChar), parent.getName()}) : InspectionsBundle.message((String)"inconsistent.bundle.property.inconsistent.end", (Object[])new Object[]{Character.valueOf(lastChar)});
                    PsiElement propertyPsiElement = property.getPsiElement();
                    processor.addProblemElement((RefEntity)refManager.getReference((PsiElement)propertiesFile.getContainingFile()), new CommonProblemDescriptor[]{manager.createProblemDescriptor(propertyPsiElement, message, true, LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING)});
                }
                filePropertyKeys.removeAll(commonKeys);
                parent = (PropertiesFile)parents.get((Object)parent);
            }
        }
    }
}

