/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.i18n.inconsistentResourceBundle;

import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalSimpleInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.i18n.inconsistentResourceBundle.DuplicatedPropertiesInspectionProvider;
import com.intellij.codeInspection.i18n.inconsistentResourceBundle.InconsistentPropertiesEndsInspectionProvider;
import com.intellij.codeInspection.i18n.inconsistentResourceBundle.InconsistentResourceBundleInspectionProvider;
import com.intellij.codeInspection.i18n.inconsistentResourceBundle.MissingTranslationsInspectionProvider;
import com.intellij.codeInspection.i18n.inconsistentResourceBundle.PropertiesKeysConsistencyInspectionProvider;
import com.intellij.codeInspection.i18n.inconsistentResourceBundle.PropertiesPlaceholdersInspectionProvider;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.codeInspection.ui.OptionAccessor;
import com.intellij.lang.properties.PropertiesUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.BidirectionalMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InconsistentResourceBundleInspection
extends GlobalSimpleInspectionTool {
    private static final Key<Set<ResourceBundle>> VISITED_BUNDLES_KEY = Key.create((String)"VISITED_BUNDLES_KEY");
    private final NotNullLazyValue<InconsistentResourceBundleInspectionProvider[]> myInspectionProviders = new NotNullLazyValue<InconsistentResourceBundleInspectionProvider[]>(){

        @NotNull
        protected InconsistentResourceBundleInspectionProvider[] compute() {
            return new InconsistentResourceBundleInspectionProvider[]{new PropertiesKeysConsistencyInspectionProvider(), new DuplicatedPropertiesInspectionProvider(), new MissingTranslationsInspectionProvider(), new PropertiesPlaceholdersInspectionProvider(), new InconsistentPropertiesEndsInspectionProvider()};
        }
    };
    private final Map<String, Boolean> mySettings = new LinkedHashMap<String, Boolean>();

    @NotNull
    public String getDisplayName() {
        return InspectionsBundle.message((String)"inconsistent.resource.bundle.display.name", (Object[])new Object[0]);
    }

    @NotNull
    public String getShortName() {
        return "InconsistentResourceBundle";
    }

    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel = new MultipleCheckboxOptionsPanel(new OptionAccessor(){

            public boolean getOption(String optionName) {
                return InconsistentResourceBundleInspection.this.isProviderEnabled(optionName);
            }

            public void setOption(String optionName, boolean optionValue) {
                if (optionValue) {
                    InconsistentResourceBundleInspection.this.mySettings.remove(optionName);
                } else {
                    InconsistentResourceBundleInspection.this.mySettings.put(optionName, false);
                }
            }
        });
        for (InconsistentResourceBundleInspectionProvider provider : (InconsistentResourceBundleInspectionProvider[])this.myInspectionProviders.getValue()) {
            panel.addCheckbox(provider.getPresentableName(), provider.getName());
        }
        return panel;
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        for (Map.Entry<String, Boolean> e : this.mySettings.entrySet()) {
            JDOMExternalizerUtil.writeField((Element)node, (String)e.getKey(), (String)Boolean.toString(e.getValue()));
        }
    }

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        this.mySettings.clear();
        for (Object o : node.getChildren()) {
            if (!(o instanceof Element)) continue;
            Element e = (Element)o;
            String name = e.getAttributeValue("name");
            boolean value = Boolean.parseBoolean(e.getAttributeValue("value"));
            this.mySettings.put(name, value);
        }
    }

    public void inspectionStarted(@NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor problemDescriptionsProcessor) {
        globalContext.putUserData(VISITED_BUNDLES_KEY, (Object)ContainerUtil.newConcurrentSet());
    }

    public void checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, @NotNull ProblemsHolder problemsHolder, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor problemDescriptionsProcessor) {
        Set visitedBundles = (Set)globalContext.getUserData(VISITED_BUNDLES_KEY);
        if (!(file instanceof PropertiesFile)) {
            return;
        }
        PropertiesFile propertiesFile = (PropertiesFile)file;
        ResourceBundle resourceBundle = propertiesFile.getResourceBundle();
        assert (visitedBundles != null);
        if (!visitedBundles.add(resourceBundle)) {
            return;
        }
        List files = resourceBundle.getPropertiesFiles();
        if (files.size() < 2) {
            return;
        }
        BidirectionalMap parents = new BidirectionalMap();
        for (PropertiesFile f : files) {
            PropertiesFile parent = PropertiesUtil.getParent((PropertiesFile)f, (Collection)files);
            if (parent == null) continue;
            parents.put((Object)f, (Object)parent);
        }
        Map propertiesFilesNamesMaps = FactoryMap.create(key -> key.getNamesMap());
        THashMap keysUpToParent = new THashMap();
        for (PropertiesFile f : files) {
            THashSet keys = new THashSet(((Map)propertiesFilesNamesMaps.get(f)).keySet());
            PropertiesFile parent = (PropertiesFile)parents.get((Object)f);
            while (parent != null) {
                keys.addAll(((Map)propertiesFilesNamesMaps.get(parent)).keySet());
                parent = (PropertiesFile)parents.get((Object)parent);
            }
            keysUpToParent.put(f, keys);
        }
        for (InconsistentResourceBundleInspectionProvider provider : (InconsistentResourceBundleInspectionProvider[])this.myInspectionProviders.getValue()) {
            if (!this.isProviderEnabled(provider.getName())) continue;
            provider.check((BidirectionalMap<PropertiesFile, PropertiesFile>)parents, files, (Map<PropertiesFile, Set<String>>)keysUpToParent, propertiesFilesNamesMaps, manager, globalContext.getRefManager(), problemDescriptionsProcessor);
        }
    }

    private boolean isProviderEnabled(String providerName) {
        return (Boolean)ContainerUtil.getOrElse(this.mySettings, (Object)providerName, (Object)true);
    }

    @SafeVarargs
    public final void enableProviders(Class<? extends InconsistentResourceBundleInspectionProvider> ... providerClasses) {
        HashSet providersToEnable = ContainerUtil.newHashSet((Object[])providerClasses);
        for (InconsistentResourceBundleInspectionProvider inspectionProvider : (InconsistentResourceBundleInspectionProvider[])this.myInspectionProviders.getValue()) {
            if (!providersToEnable.contains(inspectionProvider.getClass())) continue;
            this.mySettings.put(inspectionProvider.getName(), true);
        }
    }

    public void disableAllProviders() {
        for (InconsistentResourceBundleInspectionProvider inspectionProvider : (InconsistentResourceBundleInspectionProvider[])this.myInspectionProviders.getValue()) {
            this.mySettings.put(inspectionProvider.getName(), false);
        }
    }

    public void clearSettings() {
        this.mySettings.clear();
    }
}

