/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.i18n.inconsistentResourceBundle;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.i18n.JavaI18nUtil;
import com.intellij.codeInspection.i18n.inconsistentResourceBundle.InconsistentResourceBundleInspectionProvider;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.BidirectionalMap;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class PropertiesPlaceholdersInspectionProvider
implements InconsistentResourceBundleInspectionProvider {
    @Override
    @NotNull
    public String getName() {
        return "REPORT_INCONSISTENT_PROPERTIES_PLACEHOLDERS";
    }

    @Override
    @NotNull
    public String getPresentableName() {
        return InspectionsBundle.message((String)"inconsistent.bundle.report.inconsistent.properties.placeholders", (Object[])new Object[0]);
    }

    @Override
    public void check(BidirectionalMap<PropertiesFile, PropertiesFile> parents, List<? extends PropertiesFile> files, Map<PropertiesFile, Set<String>> keysUpToParent, Map<PropertiesFile, Map<String, String>> propertiesFilesNamesMaps, InspectionManager manager, RefManager refManager, ProblemDescriptionsProcessor processor) {
        for (PropertiesFile propertiesFile : files) {
            THashSet filePropertyKeys = new THashSet(propertiesFilesNamesMaps.get(propertiesFile).keySet());
            PropertiesFile parent = (PropertiesFile)parents.get((Object)propertiesFile);
            while (parent != null) {
                Collection commonKeys = ContainerUtil.intersection(propertiesFilesNamesMaps.get(parent).keySet(), (Collection)filePropertyKeys);
                for (String commonKey : commonKeys) {
                    int parentOccurrences;
                    int occurrences;
                    String parentPropertyValue;
                    IProperty property = propertiesFile.findPropertyByKey(commonKey);
                    assert (property != null);
                    String propertyValue = property.getValue();
                    if (propertyValue == null || (parentPropertyValue = propertiesFilesNamesMaps.get(parent).get(commonKey)) == null || (occurrences = JavaI18nUtil.getPropertyValuePlaceholdersCount(propertyValue)) == (parentOccurrences = JavaI18nUtil.getPropertyValuePlaceholdersCount(parentPropertyValue))) continue;
                    String problemDescriptorString = InspectionsBundle.message((String)"inconsistent.bundle.property.inconsistent.placeholders", (Object[])new Object[]{parentOccurrences, parent.getName()});
                    PsiElement propertyPsiElement = property.getPsiElement();
                    processor.addProblemElement((RefEntity)refManager.getReference((PsiElement)propertiesFile.getContainingFile()), new CommonProblemDescriptor[]{manager.createProblemDescriptor(propertyPsiElement, problemDescriptorString, true, LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING)});
                }
                filePropertyKeys.removeAll(commonKeys);
                parent = (PropertiesFile)parents.get((Object)parent);
            }
        }
    }
}

