/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.lang.properties.PrefixBasedPropertyReference;
import com.intellij.lang.properties.UastPropertiesReferenceProvider;
import com.intellij.lang.properties.references.PropertyReference;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.jsp.jspXml.JspXmlTagBase;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ProcessingContext;
import com.intellij.xml.util.XmlUtil;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UastContextKt;

public class PropertiesReferenceProvider
extends PsiReferenceProvider {
    private final UastPropertiesReferenceProvider myProvider;
    private final boolean myDefaultSoft;

    public PropertiesReferenceProvider() {
        this(false);
    }

    public PropertiesReferenceProvider(boolean defaultSoft) {
        this.myProvider = new UastPropertiesReferenceProvider(defaultSoft);
        this.myDefaultSoft = defaultSoft;
    }

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element instanceof XmlAttributeValue && PropertiesReferenceProvider.isNonDynamicAttribute(element)) {
            XmlTag parent;
            if (element.getTextLength() < 2) {
                return PsiReference.EMPTY_ARRAY;
            }
            String value = ((XmlAttributeValue)element).getValue();
            XmlAttribute attribute = (XmlAttribute)element.getParent();
            boolean propertyRefWithPrefix = false;
            if ("key".equals(attribute.getName()) && "message".equals((parent = attribute.getParent()).getLocalName()) && Arrays.binarySearch(XmlUtil.JSTL_FORMAT_URIS, parent.getNamespace()) >= 0) {
                propertyRefWithPrefix = true;
            }
            PrefixBasedPropertyReference reference = propertyRefWithPrefix ? new PrefixBasedPropertyReference(value, element, null, this.myDefaultSoft) : new PropertyReference(value, element, null, this.myDefaultSoft);
            return new PsiReference[]{reference};
        }
        UElement uElement = UastContextKt.toUElement((PsiElement)element, ULiteralExpression.class);
        return uElement == null ? PsiReference.EMPTY_ARRAY : this.myProvider.getReferencesByElement(uElement, context);
    }

    static boolean isNonDynamicAttribute(PsiElement element) {
        return PsiTreeUtil.getChildOfAnyType((PsiElement)element, (Class[])new Class[]{OuterLanguageElement.class, JspXmlTagBase.class}) == null;
    }

    public boolean acceptsTarget(@NotNull PsiElement target) {
        return this.myProvider.acceptsTarget(target);
    }
}

