/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.codeInspection.i18n.JavaI18nUtil;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.references.PropertyReference;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.UastInjectionHostReferenceProvider;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.UNamedExpression;

class UastPropertiesReferenceProvider
extends UastInjectionHostReferenceProvider {
    private final boolean myDefaultSoft;

    UastPropertiesReferenceProvider(boolean defaultSoft) {
        this.myDefaultSoft = defaultSoft;
    }

    public boolean acceptsTarget(@NotNull PsiElement target) {
        return target instanceof IProperty;
    }

    @NotNull
    public PsiReference[] getReferencesForInjectionHost(@NotNull UExpression element, @NotNull PsiLanguageInjectionHost host, @NotNull ProcessingContext context) {
        String text;
        Object value = null;
        String bundleName = null;
        boolean soft = this.myDefaultSoft;
        if (UastPropertiesReferenceProvider.canBePropertyKeyRef(element)) {
            value = element.evaluate();
            Ref resourceBundleValue = Ref.create();
            if (JavaI18nUtil.mustBePropertyKey(element, (Ref<? super UExpression>)resourceBundleValue)) {
                soft = false;
                UExpression resourceBundleName = (UExpression)resourceBundleValue.get();
                if (resourceBundleName != null) {
                    Object bundleValue = resourceBundleName.evaluate();
                    String string = bundleName = bundleValue == null ? null : bundleValue.toString();
                }
            }
        }
        if (value instanceof String && (text = (String)value).indexOf(10) == -1) {
            PropertyReference reference = new PropertyReference(text, (PsiElement)host, bundleName, soft);
            return new PsiReference[]{reference};
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private static boolean canBePropertyKeyRef(@NotNull UExpression element) {
        UElement parent = element.getUastParent();
        if (parent instanceof UExpression) {
            if (parent instanceof UIfExpression && ((UIfExpression)parent).isTernary()) {
                UExpression elseExpr = ((UIfExpression)parent).getElseExpression();
                UExpression thenExpr = ((UIfExpression)parent).getThenExpression();
                PsiElement elseExprSrc = elseExpr == null ? null : elseExpr.getSourcePsi();
                PsiElement thenExprSrc = thenExpr == null ? null : thenExpr.getSourcePsi();
                PsiElement psi = element.getSourcePsi();
                return (psi == thenExprSrc || psi == elseExprSrc) && UastPropertiesReferenceProvider.canBePropertyKeyRef((UExpression)parent);
            }
            return parent instanceof UCallExpression || parent instanceof UNamedExpression;
        }
        return true;
    }
}

