/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components;

import com.intellij.openapi.application.PathMacroFilter;
import com.intellij.openapi.diagnostic.Logger;
import org.jdom.Attribute;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Text;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PathMacroMap {
    private static final Logger LOG = Logger.getInstance(PathMacroMap.class);

    public abstract String substitute(String var1, boolean var2);

    public final String substitute(String text, boolean caseSensitive, boolean recursively) {
        return recursively ? this.substituteRecursively(text, caseSensitive) : this.substitute(text, caseSensitive);
    }

    public final void substitute(@NotNull Element e, boolean caseSensitive) {
        this.substitute(e, caseSensitive, false);
    }

    public final void substitute(@NotNull Element element, boolean caseSensitive, boolean recursively, @Nullable PathMacroFilter filter) {
        if (filter != null && filter.skipPathMacros(element)) {
            return;
        }
        for (Content child : element.getContent()) {
            if (child instanceof Element) {
                this.substitute((Element)child, caseSensitive, recursively, filter);
                continue;
            }
            if (child instanceof Text) {
                String newText;
                Text t = (Text)child;
                String oldText = t.getText();
                if (oldText == (newText = recursively ? this.substituteRecursively(oldText, caseSensitive) : this.substitute(oldText, caseSensitive))) continue;
                t.setText(newText);
                continue;
            }
            if (child instanceof Comment) continue;
            LOG.error("Wrong content: " + child.getClass());
        }
        if (!element.hasAttributes()) {
            return;
        }
        for (Attribute attribute : element.getAttributes()) {
            if (filter != null && filter.skipPathMacros(attribute)) continue;
            String newValue = this.getAttributeValue(attribute, filter, caseSensitive, recursively);
            if (attribute.getValue() == newValue) continue;
            attribute.setValue(newValue);
        }
    }

    public String getAttributeValue(@NotNull Attribute attribute, @Nullable PathMacroFilter filter, boolean caseSensitive, boolean recursively) {
        String oldValue = attribute.getValue();
        if (recursively || filter != null && filter.recursePathMacros(attribute)) {
            return this.substituteRecursively(oldValue, caseSensitive);
        }
        return this.substitute(oldValue, caseSensitive);
    }

    public final void substitute(@NotNull Element e, boolean caseSensitive, boolean recursively) {
        this.substitute(e, caseSensitive, recursively, null);
    }

    @NotNull
    public String substituteRecursively(@NotNull String text, boolean caseSensitive) {
        return this.substitute(text, caseSensitive);
    }

    public abstract int hashCode();
}

