/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.text.XmlCharsetDetector;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElementChildRole;
import org.jetbrains.jps.model.JpsEncodingConfigurationService;
import org.jetbrains.jps.model.JpsEncodingProjectConfiguration;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.ex.JpsElementBase;
import org.jetbrains.jps.model.ex.JpsElementChildRoleBase;
import org.jetbrains.jps.util.JpsPathUtil;

public class JpsEncodingProjectConfigurationImpl
extends JpsElementBase<JpsEncodingProjectConfigurationImpl>
implements JpsEncodingProjectConfiguration {
    private static final Logger LOG = Logger.getInstance(JpsEncodingProjectConfigurationImpl.class);
    public static final JpsElementChildRole<JpsEncodingProjectConfiguration> ROLE = JpsElementChildRoleBase.create((String)"encoding configuration");
    private static final String XML_NAME_SUFFIX = ".xml";
    private final Map<String, String> myUrlToEncoding = new HashMap<String, String>();
    private final String myProjectEncoding;

    public JpsEncodingProjectConfigurationImpl(Map<String, String> urlToEncoding, String projectEncoding) {
        this.myUrlToEncoding.putAll(urlToEncoding);
        this.myProjectEncoding = projectEncoding;
    }

    @Nullable
    public String getEncoding(@NotNull File file) {
        if (JpsEncodingProjectConfigurationImpl.isXmlFile(file)) {
            try {
                String encoding = XmlCharsetDetector.extractXmlEncodingFromProlog((byte[])FileUtil.loadFileBytes((File)file));
                if (encoding != null) {
                    return encoding;
                }
            }
            catch (IOException e) {
                LOG.info("Cannot detect encoding for xml file " + file.getAbsolutePath(), (Throwable)e);
            }
        }
        if (!this.myUrlToEncoding.isEmpty()) {
            File current = file;
            while (current != null) {
                String encoding = this.myUrlToEncoding.get(JpsPathUtil.pathToUrl((String)FileUtilRt.toSystemIndependentName((String)current.getPath())));
                if (encoding != null) {
                    return encoding;
                }
                current = FileUtilRt.getParentFile((File)current);
            }
        }
        if (this.myProjectEncoding != null) {
            return this.myProjectEncoding;
        }
        JpsModel model = this.getModel();
        assert (model != null);
        return JpsEncodingConfigurationService.getInstance().getGlobalEncoding(model.getGlobal());
    }

    private static boolean isXmlFile(File file) {
        String fileName = file.getName();
        return SystemInfo.isFileSystemCaseSensitive ? fileName.endsWith(XML_NAME_SUFFIX) : StringUtil.endsWithIgnoreCase((String)fileName, (String)XML_NAME_SUFFIX);
    }

    @NotNull
    public Map<String, String> getUrlToEncoding() {
        return Collections.unmodifiableMap(this.myUrlToEncoding);
    }

    @Nullable
    public String getProjectEncoding() {
        return this.myProjectEncoding;
    }

    @NotNull
    public JpsEncodingProjectConfigurationImpl createCopy() {
        return new JpsEncodingProjectConfigurationImpl(this.myUrlToEncoding, this.myProjectEncoding);
    }

    public void applyChanges(@NotNull JpsEncodingProjectConfigurationImpl modified) {
    }
}

