/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.module.impl;

import com.intellij.util.containers.ContainerUtil;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementCreator;
import org.jetbrains.jps.model.ex.JpsCompositeElementBase;
import org.jetbrains.jps.model.ex.JpsElementChildRoleBase;
import org.jetbrains.jps.model.library.sdk.JpsSdkReference;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;
import org.jetbrains.jps.model.module.JpsSdkReferencesTable;
import org.jetbrains.jps.model.module.impl.JpsSdkReferenceRole;

public class JpsSdkReferencesTableImpl
extends JpsCompositeElementBase<JpsSdkReferencesTableImpl>
implements JpsSdkReferencesTable {
    public static final JpsSdkReferencesTableRole ROLE = new JpsSdkReferencesTableRole();
    private static final ConcurrentMap<JpsSdkType, JpsSdkReferenceRole> ourReferenceRoles = ContainerUtil.newConcurrentMap();

    public JpsSdkReferencesTableImpl() {
    }

    private JpsSdkReferencesTableImpl(JpsSdkReferencesTableImpl original) {
        super((JpsCompositeElementBase)original);
    }

    @NotNull
    public JpsSdkReferencesTableImpl createCopy() {
        return new JpsSdkReferencesTableImpl(this);
    }

    public <P extends JpsElement> void setSdkReference(@NotNull JpsSdkType<P> type, @Nullable JpsSdkReference<P> sdkReference) {
        JpsSdkReferenceRole<P> role = JpsSdkReferencesTableImpl.getSdkReferenceRole(type);
        if (sdkReference != null) {
            this.myContainer.setChild(role, sdkReference);
        } else {
            this.myContainer.removeChild(role);
        }
    }

    public <P extends JpsElement> JpsSdkReference<P> getSdkReference(@NotNull JpsSdkType<P> type) {
        return (JpsSdkReference)this.myContainer.getChild(JpsSdkReferencesTableImpl.getSdkReferenceRole(type));
    }

    @NotNull
    private static <P extends JpsElement> JpsSdkReferenceRole<P> getSdkReferenceRole(@NotNull JpsSdkType<P> type) {
        JpsSdkReferenceRole role = (JpsSdkReferenceRole)((Object)ourReferenceRoles.get(type));
        if (role != null) {
            return role;
        }
        ourReferenceRoles.putIfAbsent(type, new JpsSdkReferenceRole<P>(type));
        return (JpsSdkReferenceRole)((Object)ourReferenceRoles.get(type));
    }

    private static class JpsSdkReferencesTableRole
    extends JpsElementChildRoleBase<JpsSdkReferencesTable>
    implements JpsElementCreator<JpsSdkReferencesTable> {
        JpsSdkReferencesTableRole() {
            super("sdk references");
        }

        @NotNull
        public JpsSdkReferencesTable create() {
            return new JpsSdkReferencesTableImpl();
        }
    }
}

