/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization;

import com.intellij.openapi.util.JDOMUtil;
import org.jdom.Content;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JDomSerializationUtil {
    @NonNls
    public static final String COMPONENT_ELEMENT = "component";
    @NonNls
    protected static final String OPTION_ELEMENT = "option";
    @NonNls
    protected static final String NAME_ATTRIBUTE = "name";
    @NonNls
    protected static final String VALUE_ATTRIBUTE = "value";

    @Nullable
    public static Element findComponent(@Nullable Element root, @NonNls String componentName) {
        for (Element element : JDOMUtil.getChildren((Element)root, (String)COMPONENT_ELEMENT)) {
            if (!JDomSerializationUtil.isComponent(componentName, element)) continue;
            return element;
        }
        return null;
    }

    public static boolean isComponent(@NotNull String componentName, @NotNull Element element) {
        return componentName.equals(element.getAttributeValue(NAME_ATTRIBUTE));
    }

    public static Element createComponentElement(String componentName) {
        Element element = new Element(COMPONENT_ELEMENT);
        element.setAttribute(NAME_ATTRIBUTE, componentName);
        return element;
    }

    @NotNull
    public static Element findOrCreateComponentElement(@NotNull Element root, @NotNull String componentName) {
        Element component = JDomSerializationUtil.findComponent(root, componentName);
        if (component == null) {
            component = JDomSerializationUtil.createComponentElement(componentName);
            JDomSerializationUtil.addComponent(root, component);
        }
        return component;
    }

    public static void addComponent(Element root, Element component) {
        String componentName = component.getAttributeValue(NAME_ATTRIBUTE);
        Element old = JDomSerializationUtil.findComponent(root, componentName);
        if (old != null) {
            root.removeContent((Content)old);
        }
        for (int i = 0; i < root.getContent().size(); ++i) {
            String name;
            Element element;
            Object o = root.getContent().get(i);
            if (!(o instanceof Element) || !(element = (Element)o).getName().equals(COMPONENT_ELEMENT) || componentName.compareTo(name = element.getAttributeValue(NAME_ATTRIBUTE)) >= 0) continue;
            root.addContent(i, (Content)component);
            return;
        }
        root.addContent(component);
    }
}

