/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.service.impl;

import com.intellij.util.ConcurrencyUtil;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.service.SharedThreadPool;

public class SharedThreadPoolImpl
extends SharedThreadPool {
    private final ExecutorService myService = Executors.newCachedThreadPool(ConcurrencyUtil.newNamedThreadFactory((String)"JPS thread pool", (boolean)true, (int)5));

    public void execute(@NotNull Runnable command) {
        this.executeOnPooledThread(command);
    }

    @NotNull
    public Future<?> executeOnPooledThread(@NotNull Runnable action) {
        return this.myService.submit(() -> {
            try {
                action.run();
            }
            finally {
                Thread.interrupted();
            }
        });
    }
}

