/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.BackgroundTaskQueue;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ZipperUpdater;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsListener;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Alarm;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.WorkingCopy;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.info.Info;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000fH\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0017\u001a\u00020\u000fH\u0002J\u0006\u0010\u0019\u001a\u00020\u0016J\b\u0010\u001a\u001a\u00020\u0016H\u0016J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00102\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dJ\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0017\u001a\u00020\u000fJ\u001c\u0010\u001f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0017\u001a\u00020\u000f2\b\u0010 \u001a\u0004\u0018\u00010\u0010H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/idea/svn/RootsToWorkingCopies;", "Lcom/intellij/openapi/vcs/VcsListener;", "myVcs", "Lorg/jetbrains/idea/svn/SvnVcs;", "(Lorg/jetbrains/idea/svn/SvnVcs;)V", "myLock", "", "myProject", "Lcom/intellij/openapi/project/Project;", "myQueue", "Lcom/intellij/openapi/progress/BackgroundTaskQueue;", "myRechecker", "Ljava/lang/Runnable;", "myRootMapping", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lorg/jetbrains/idea/svn/WorkingCopy;", "myUnversioned", "", "myZipperUpdater", "Lcom/intellij/openapi/util/ZipperUpdater;", "addRoot", "", "root", "calculateRoot", "clear", "directoryMappingChanged", "getMatchingCopy", "url", "Lorg/jetbrains/idea/svn/api/Url;", "getWcRoot", "registerWorkingCopy", "resolvedWorkingCopy", "intellij.vcs.svn"})
public final class RootsToWorkingCopies
implements VcsListener {
    private final Object myLock;
    private final Project myProject;
    private final Map<VirtualFile, WorkingCopy> myRootMapping;
    private final Set<VirtualFile> myUnversioned;
    private final BackgroundTaskQueue myQueue;
    private final ZipperUpdater myZipperUpdater;
    private final Runnable myRechecker;
    private final SvnVcs myVcs;

    private final void addRoot(VirtualFile root) {
        this.myQueue.run(new Task.Backgroundable(this, root, this.myProject, "Looking for '" + root.getPath() + "' working copy root", false){
            final /* synthetic */ RootsToWorkingCopies this$0;
            final /* synthetic */ VirtualFile $root;

            public void run(@NotNull ProgressIndicator indicator) {
                RootsToWorkingCopies.access$calculateRoot(this.this$0, this.$root);
            }
            {
                this.this$0 = $outer;
                this.$root = $captured_local_variable$1;
                super($super_call_param$2, $super_call_param$3, $super_call_param$4);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public final WorkingCopy getMatchingCopy(@Nullable Url url) {
        boolean bl;
        boolean bl2 = bl = !ApplicationManager.getApplication().isDispatchThread() || ApplicationManager.getApplication().isUnitTestMode();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        if (url == null) {
            return null;
        }
        Unit roots = ProjectLevelVcsManager.getInstance((Project)this.myProject).getRootsUnderVcs((AbstractVcs)SvnVcs.getInstance(this.myProject));
        Object object = this.myLock;
        synchronized (object) {
            boolean bl3 = false;
            Unit unit = roots;
            int n = ((VirtualFile[])unit).length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    unit = Unit.INSTANCE;
                    return null;
                }
                Unit root = unit[n2];
                WorkingCopy wcRoot = this.getWcRoot((VirtualFile)root);
                if (wcRoot != null) {
                    if (SvnUtil.isAncestor(wcRoot.getUrl(), url)) return wcRoot;
                    if (SvnUtil.isAncestor(url, wcRoot.getUrl())) {
                        return wcRoot;
                    }
                }
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final WorkingCopy getWcRoot(@NotNull VirtualFile root) {
        boolean bl;
        boolean bl2 = bl = !ApplicationManager.getApplication().isDispatchThread() || ApplicationManager.getApplication().isUnitTestMode();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        Object object = this.myLock;
        synchronized (object) {
            block7: {
                block6: {
                    boolean bl3 = false;
                    if (!this.myUnversioned.contains(root)) break block6;
                    WorkingCopy workingCopy = null;
                    return workingCopy;
                }
                WorkingCopy existing = this.myRootMapping.get(root);
                if (existing == null) break block7;
                WorkingCopy workingCopy = existing;
                return workingCopy;
            }
            Unit unit = Unit.INSTANCE;
        }
        return this.calculateRoot(root);
    }

    private final WorkingCopy calculateRoot(VirtualFile root) {
        Info svnInfo;
        File workingCopyRoot = SvnUtil.getWorkingCopyRoot(VfsUtilCore.virtualToIoFile((VirtualFile)root));
        WorkingCopy workingCopy = null;
        if (workingCopyRoot != null && (svnInfo = this.myVcs.getInfo(workingCopyRoot)) != null && svnInfo.getUrl() != null) {
            workingCopy = new WorkingCopy(workingCopyRoot, svnInfo.getUrl());
        }
        return this.registerWorkingCopy(root, workingCopy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final WorkingCopy registerWorkingCopy(VirtualFile root, WorkingCopy resolvedWorkingCopy) {
        Object object = this.myLock;
        synchronized (object) {
            Object object2;
            Boolean bl;
            boolean bl2 = false;
            if (resolvedWorkingCopy == null) {
                this.myRootMapping.remove(root);
                bl = this.myUnversioned.add(root);
            } else {
                this.myUnversioned.remove(root);
                object2 = this.myRootMapping;
                VirtualFile virtualFile = root;
                WorkingCopy workingCopy = resolvedWorkingCopy;
                object2.put(virtualFile, workingCopy);
                bl = Unit.INSTANCE;
            }
            object2 = bl;
        }
        return resolvedWorkingCopy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear() {
        Object object = this.myLock;
        synchronized (object) {
            boolean bl = false;
            this.myRootMapping.clear();
            this.myUnversioned.clear();
            Unit unit = Unit.INSTANCE;
        }
        this.myZipperUpdater.stop();
    }

    public void directoryMappingChanged() {
        this.myVcs.getAuthNotifier().clear();
        this.myZipperUpdater.queue(this.myRechecker);
    }

    public RootsToWorkingCopies(@NotNull SvnVcs myVcs) {
        this.myVcs = myVcs;
        this.myLock = new Object();
        this.myProject = this.myVcs.getProject();
        RootsToWorkingCopies rootsToWorkingCopies = this;
        Object object = new LinkedHashMap();
        rootsToWorkingCopies.myRootMapping = object;
        rootsToWorkingCopies = this;
        rootsToWorkingCopies.myUnversioned = object = (Set)new LinkedHashSet();
        this.myQueue = new BackgroundTaskQueue(this.myProject, "SVN VCS roots authorization checker");
        this.myZipperUpdater = new ZipperUpdater(200, Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this.myProject);
        this.myRechecker = new Runnable(this){
            final /* synthetic */ RootsToWorkingCopies this$0;

            public final void run() {
                VirtualFile[] roots;
                this.this$0.clear();
                for (VirtualFile root : roots = ProjectLevelVcsManager.getInstance((Project)RootsToWorkingCopies.access$getMyProject$p(this.this$0)).getRootsUnderVcs((AbstractVcs)RootsToWorkingCopies.access$getMyVcs$p(this.this$0))) {
                    RootsToWorkingCopies.access$addRoot(this.this$0, root);
                }
            }
            {
                this.this$0 = rootsToWorkingCopies;
            }
        };
    }

    public static final /* synthetic */ WorkingCopy access$calculateRoot(RootsToWorkingCopies $this, VirtualFile root) {
        return $this.calculateRoot(root);
    }

    public static final /* synthetic */ Project access$getMyProject$p(RootsToWorkingCopies $this) {
        return $this.myProject;
    }

    public static final /* synthetic */ SvnVcs access$getMyVcs$p(RootsToWorkingCopies $this) {
        return $this.myVcs;
    }

    public static final /* synthetic */ void access$addRoot(RootsToWorkingCopies $this, VirtualFile root) {
        $this.addRoot(root);
    }
}

