/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.ErrorCode;
import org.jetbrains.idea.svn.change.ChangeListClient;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.status.Status;

public class SvnChangelistListener
implements ChangeListListener {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.svn.SvnChangelistListener");
    @NotNull
    private final SvnVcs myVcs;
    @NotNull
    private final Condition<FilePath> myUnderSvnCondition;

    public SvnChangelistListener(@NotNull SvnVcs vcs) {
        this.myVcs = vcs;
        this.myUnderSvnCondition = path -> {
            AbstractVcs vcs1 = ProjectLevelVcsManager.getInstance((Project)this.myVcs.getProject()).getVcsFor(path);
            return vcs1 != null && "svn".equals(vcs1.getName());
        };
    }

    public void changesRemoved(Collection<Change> changes, ChangeList fromList) {
        if (LocalChangeList.DEFAULT_NAME.equals(fromList.getName())) {
            return;
        }
        this.removeFromChangeList(changes);
    }

    public void changesAdded(Collection<Change> changes, ChangeList toList) {
        if (toList == null || LocalChangeList.DEFAULT_NAME.equals(toList.getName())) {
            return;
        }
        this.addToChangeList(toList.getName(), changes);
    }

    public void changeListRemoved(ChangeList list) {
        this.removeFromChangeList(list.getChanges());
    }

    @NotNull
    private List<FilePath> getPathsFromChanges(@NotNull Collection<Change> changes) {
        return ContainerUtil.findAll((Collection)ChangesUtil.getPaths(changes), this.myUnderSvnCondition);
    }

    public void changeListRenamed(ChangeList list, String oldName) {
        if (Comparing.equal((String)list.getName(), (String)oldName)) {
            return;
        }
        if (LocalChangeList.DEFAULT_NAME.equals(list.getName())) {
            this.changeListRemoved(list);
            return;
        }
        this.addToChangeList(list.getName(), list.getChanges());
    }

    public void changesMoved(Collection<Change> changes, ChangeList fromList, ChangeList toList) {
        String[] stringArray;
        if (fromList.getName().equals(toList.getName())) {
            return;
        }
        if (LocalChangeList.DEFAULT_NAME.equals(toList.getName())) {
            this.changeListRemoved(toList);
            return;
        }
        if (LocalChangeList.DEFAULT_NAME.equals(fromList.getName())) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = fromList.getName();
        }
        String[] fromLists = stringArray;
        this.addToChangeList(toList.getName(), changes, fromLists);
    }

    @Nullable
    public static String getCurrentMapping(@NotNull SvnVcs vcs, @NotNull File file) {
        try {
            Status status = vcs.getFactory(file).createStatusClient().doStatus(file, false);
            return status == null ? null : status.getChangeListName();
        }
        catch (SvnBindException e) {
            if (e.contains(ErrorCode.WC_NOT_WORKING_COPY) || e.contains(ErrorCode.WC_NOT_FILE)) {
                LOG.debug("Logging only, exception is valid (caught) here", (Throwable)((Object)e));
            } else {
                LOG.info("Logging only, exception is valid (caught) here", (Throwable)((Object)e));
            }
            return null;
        }
    }

    public static void putUnderList(@NotNull SvnVcs vcs, @NotNull String list, @NotNull File after) throws VcsException {
        SvnChangelistListener.doChangeListOperation(vcs, after, (ThrowableConsumer<ChangeListClient, VcsException>)((ThrowableConsumer)client -> client.add(list, after, null)));
    }

    public static void removeFromList(@NotNull SvnVcs vcs, @NotNull File after) throws VcsException {
        SvnChangelistListener.doChangeListOperation(vcs, after, (ThrowableConsumer<ChangeListClient, VcsException>)((ThrowableConsumer)client -> client.remove(after)));
    }

    private static void doChangeListOperation(@NotNull SvnVcs vcs, @NotNull File file, @NotNull ThrowableConsumer<ChangeListClient, VcsException> operation) throws VcsException {
        try {
            operation.consume((Object)vcs.getFactory(file).createChangeListClient());
        }
        catch (SvnBindException e) {
            LOG.info((Throwable)((Object)e));
            if (!e.contains(ErrorCode.WC_NOT_WORKING_COPY) && !e.contains(ErrorCode.WC_NOT_FILE)) {
                throw e;
            }
        }
        catch (VcsException e) {
            LOG.info((Throwable)e);
            throw e;
        }
    }

    private void removeFromChangeList(@NotNull Collection<Change> changes) {
        for (FilePath path : this.getPathsFromChanges(changes)) {
            try {
                File file = path.getIOFile();
                this.myVcs.getFactory(file).createChangeListClient().remove(file);
            }
            catch (VcsException e) {
                LOG.info((Throwable)e);
            }
        }
    }

    private void addToChangeList(@NotNull String changeList, @NotNull Collection<Change> changes) {
        this.addToChangeList(changeList, changes, null);
    }

    private void addToChangeList(@NotNull String changeList, @NotNull Collection<Change> changes, @Nullable String[] changeListsToOperate) {
        for (FilePath path : this.getPathsFromChanges(changes)) {
            try {
                File file = path.getIOFile();
                this.myVcs.getFactory(file).createChangeListClient().add(changeList, file, changeListsToOperate);
            }
            catch (VcsException e) {
                LOG.info((Throwable)e);
            }
        }
    }
}

