/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.StatusReceiver;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.ErrorCode;
import org.jetbrains.idea.svn.api.ProgressEvent;
import org.jetbrains.idea.svn.api.ProgressTracker;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.status.Status;
import org.jetbrains.idea.svn.status.StatusClient;
import org.jetbrains.idea.svn.status.StatusConsumer;
import org.jetbrains.idea.svn.status.StatusType;

public class SvnRecursiveStatusWalker {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.svn.SvnRecursiveStatusWalker");
    @NotNull
    private final SvnVcs myVcs;
    @NotNull
    private final Project myProject;
    @NotNull
    private final ProjectLevelVcsManager myVcsManager;
    @NotNull
    private final ChangeListManager myChangeListManager;
    @Nullable
    private final ProgressIndicator myProgress;
    @NotNull
    private final StatusReceiver myReceiver;
    @NotNull
    private final LinkedList<MyItem> myQueue;
    @NotNull
    private final MyHandler myHandler;
    @Nullable
    private MultiMap<FilePath, FilePath> myNonRecursiveScope;

    public SvnRecursiveStatusWalker(@NotNull SvnVcs vcs, @NotNull StatusReceiver receiver, @Nullable ProgressIndicator progress) {
        this.myVcs = vcs;
        this.myProject = vcs.getProject();
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        this.myChangeListManager = ChangeListManager.getInstance((Project)this.myProject);
        this.myReceiver = receiver;
        this.myProgress = progress;
        this.myQueue = new LinkedList();
        this.myHandler = new MyHandler();
    }

    public void setNonRecursiveScope(@Nullable MultiMap<FilePath, FilePath> nonRecursiveScope) {
        this.myNonRecursiveScope = nonRecursiveScope;
    }

    public void go(@NotNull FilePath rootPath, @NotNull Depth depth) throws SvnBindException {
        this.myQueue.add(this.createItem(rootPath, depth, false));
        while (!this.myQueue.isEmpty()) {
            this.checkCanceled();
            MyItem item = this.myQueue.removeFirst();
            try {
                if (item.getPath().isDirectory()) {
                    this.processDirectory(item);
                    continue;
                }
                this.processFile(item);
            }
            catch (SvnBindException e) {
                this.handleStatusException(item, e);
            }
        }
    }

    private void processDirectory(@NotNull MyItem item) throws SvnBindException {
        File ioFile = item.getPath().getIOFile();
        this.myHandler.setCurrentItem(item);
        item.getClient().doStatus(ioFile, item.getDepth(), false, false, true, true, this.myHandler);
        if (!this.myHandler.myMetCurrentItem) {
            this.myHandler.checkIfCopyRootWasReported(this.myHandler.getCurrentItemStatus());
        }
    }

    private void processFile(@NotNull MyItem item) throws SvnBindException {
        this.myReceiver.process(item.getPath(), item.getClient().doStatus(item.getPath().getIOFile(), false));
    }

    public void checkCanceled() {
        if (this.myProgress != null) {
            this.myProgress.checkCanceled();
        }
    }

    public boolean isIgnoredByVcs(@NotNull VirtualFile vFile) {
        return (Boolean)ReadAction.compute(() -> {
            if (this.myVcs.getProject().isDisposed()) {
                throw new ProcessCanceledException();
            }
            return this.myVcsManager.isIgnored(vFile);
        });
    }

    public boolean isIgnoredIdeaLevel(@NotNull VirtualFile vFile) {
        return this.myChangeListManager.isIgnoredFile(vFile);
    }

    private void handleStatusException(@NotNull MyItem item, @NotNull SvnBindException e) throws SvnBindException {
        if (e.contains(ErrorCode.WC_NOT_WORKING_COPY) || e.contains(ErrorCode.WC_NOT_FILE) || e.contains(ErrorCode.WC_PATH_NOT_FOUND)) {
            VirtualFile virtualFile = item.getPath().getVirtualFile();
            if (virtualFile != null && !this.isIgnoredByVcs(virtualFile) && !this.myChangeListManager.isVcsIgnoredFile(virtualFile)) {
                this.myReceiver.processUnversioned(virtualFile);
                if (virtualFile.isDirectory()) {
                    this.processRecursively(virtualFile, item.getDepth());
                }
            }
        } else {
            throw e;
        }
    }

    private void processRecursively(@NotNull VirtualFile vFile, @NotNull Depth prevDepth) {
        if (Depth.EMPTY.equals((Object)prevDepth)) {
            return;
        }
        if (this.isIgnoredIdeaLevel(vFile)) {
            this.myReceiver.processIgnored(vFile);
            return;
        }
        final Depth newDepth = Depth.INFINITY.equals((Object)prevDepth) ? Depth.INFINITY : Depth.EMPTY;
        VirtualFileVisitor.Option[] options = newDepth.equals((Object)Depth.EMPTY) ? (VirtualFileVisitor.Option[])ContainerUtil.ar((Object[])new VirtualFileVisitor.Option[]{VirtualFileVisitor.SKIP_ROOT, VirtualFileVisitor.ONE_LEVEL_DEEP}) : new VirtualFileVisitor.Option[]{};
        VfsUtilCore.visitChildrenRecursively((VirtualFile)vFile, (VirtualFileVisitor)new VirtualFileVisitor(options){

            @NotNull
            public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file) {
                if (SvnRecursiveStatusWalker.this.isIgnoredIdeaLevel(file)) {
                    SvnRecursiveStatusWalker.this.myReceiver.processIgnored(file);
                    return SKIP_CHILDREN;
                }
                if (file.isDirectory() && file.findChild(SvnUtil.SVN_ADMIN_DIR_NAME) != null) {
                    SvnRecursiveStatusWalker.this.myQueue.add(SvnRecursiveStatusWalker.this.createItem(VcsUtil.getFilePath((VirtualFile)file), newDepth, true));
                    return SKIP_CHILDREN;
                }
                SvnRecursiveStatusWalker.this.myReceiver.processUnversioned(file);
                return CONTINUE;
            }
        });
    }

    @NotNull
    private MyItem createItem(@NotNull FilePath path, @NotNull Depth depth, boolean isInnerCopyRoot) {
        StatusClient statusClient = this.myVcs.getFactory(path.getIOFile()).createStatusClient(this.myNonRecursiveScope, this.createEventHandler());
        return new MyItem(path, depth, isInnerCopyRoot, statusClient);
    }

    @NotNull
    public ProgressTracker createEventHandler() {
        return new ProgressTracker(){

            public void consume(ProgressEvent event) {
            }

            @Override
            public void checkCancelled() throws ProcessCanceledException {
                SvnRecursiveStatusWalker.this.checkCanceled();
            }
        };
    }

    private class MyHandler
    implements StatusConsumer {
        private MyItem myCurrentItem;
        private boolean myMetCurrentItem;

        private MyHandler() {
        }

        public void setCurrentItem(@NotNull MyItem currentItem) {
            this.myCurrentItem = currentItem;
            this.myMetCurrentItem = false;
        }

        public void checkIfCopyRootWasReported(@Nullable Status status) {
            if (!this.myMetCurrentItem && status != null && FileUtil.filesEqual((File)status.getFile(), (File)this.myCurrentItem.getPath().getIOFile())) {
                this.myMetCurrentItem = true;
                this.processCurrentItem(status);
            }
        }

        @Nullable
        public Status getCurrentItemStatus() {
            Status result = null;
            try {
                result = this.myCurrentItem.getClient().doStatus(this.myCurrentItem.getPath().getIOFile(), false);
            }
            catch (SvnBindException e) {
                LOG.info((Throwable)((Object)e));
            }
            return result;
        }

        public void processCurrentItem(@NotNull Status status) {
            FilePath path = this.myCurrentItem.getPath();
            VirtualFile vf = path.getVirtualFile();
            if (vf != null) {
                if (status.is(StatusType.STATUS_IGNORED)) {
                    SvnRecursiveStatusWalker.this.myReceiver.processIgnored(vf);
                } else if (status.is(StatusType.STATUS_UNVERSIONED, StatusType.STATUS_NONE)) {
                    SvnRecursiveStatusWalker.this.myReceiver.processUnversioned(vf);
                    SvnRecursiveStatusWalker.this.processRecursively(vf, this.myCurrentItem.getDepth());
                } else if (!status.is(StatusType.OBSTRUCTED)) {
                    if (this.myCurrentItem.isIsInnerCopyRoot()) {
                        SvnRecursiveStatusWalker.this.myReceiver.processCopyRoot(vf, status.getUrl(), SvnRecursiveStatusWalker.this.myVcs.getWorkingCopyFormat(path.getIOFile()), status.getRepositoryRootUrl());
                    } else {
                        SvnRecursiveStatusWalker.this.myReceiver.bewareRoot(vf, status.getUrl());
                    }
                }
            }
        }

        public void consume(Status status) throws SvnBindException {
            SvnRecursiveStatusWalker.this.checkCanceled();
            File ioFile = status.getFile();
            this.checkIfCopyRootWasReported(status);
            VirtualFile vFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(ioFile);
            if (vFile != null && SvnRecursiveStatusWalker.this.isIgnoredByVcs(vFile)) {
                return;
            }
            if (SvnRecursiveStatusWalker.this.myProject.isDisposed()) {
                throw new ProcessCanceledException();
            }
            if (vFile != null && status.is(StatusType.STATUS_UNVERSIONED)) {
                if (vFile.isDirectory()) {
                    if (!FileUtil.filesEqual((File)this.myCurrentItem.getPath().getIOFile(), (File)ioFile)) {
                        SvnRecursiveStatusWalker.this.myQueue.add(SvnRecursiveStatusWalker.this.createItem(VcsUtil.getFilePath((VirtualFile)vFile), Depth.INFINITY, true));
                    }
                } else {
                    SvnRecursiveStatusWalker.this.myReceiver.processUnversioned(vFile);
                }
            } else {
                SvnRecursiveStatusWalker.this.myReceiver.process(VcsUtil.getFilePath((File)ioFile, (boolean)status.getNodeKind().isDirectory()), status);
            }
        }
    }

    private static class MyItem {
        @NotNull
        private final FilePath myPath;
        @NotNull
        private final Depth myDepth;
        @NotNull
        private final StatusClient myStatusClient;
        private final boolean myIsInnerCopyRoot;

        private MyItem(@NotNull FilePath path, @NotNull Depth depth, boolean isInnerCopyRoot, @NotNull StatusClient statusClient) {
            this.myPath = path;
            this.myDepth = depth;
            this.myStatusClient = statusClient;
            this.myIsInnerCopyRoot = isInnerCopyRoot;
        }

        @NotNull
        public FilePath getPath() {
            return this.myPath;
        }

        @NotNull
        public Depth getDepth() {
            return this.myDepth;
        }

        @NotNull
        public StatusClient getClient() {
            return this.myStatusClient;
        }

        public boolean isIsInnerCopyRoot() {
            return this.myIsInnerCopyRoot;
        }
    }
}

