/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.vcs.history.LongRevisionNumber;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.api.Revision;

public class SvnRevisionNumber
implements VcsRevisionNumber,
LongRevisionNumber {
    @NotNull
    private final Revision myRevision;

    public SvnRevisionNumber(@NotNull Revision revision) {
        this.myRevision = revision;
    }

    public String asString() {
        return this.myRevision.toString();
    }

    public long getLongRevisionNumber() {
        return this.myRevision.getNumber();
    }

    public int compareTo(VcsRevisionNumber vcsRevisionNumber) {
        if (vcsRevisionNumber == null || vcsRevisionNumber.getClass() != SvnRevisionNumber.class) {
            return -1;
        }
        Revision rev = ((SvnRevisionNumber)vcsRevisionNumber).myRevision;
        if (this.myRevision.getNumber() >= 0L && rev.getNumber() >= 0L) {
            return Long.compare(this.myRevision.getNumber(), rev.getNumber());
        }
        if (this.myRevision.getDate() != null && rev.getDate() != null) {
            return this.myRevision.getDate().compareTo(rev.getDate());
        }
        return Revision.GENERAL_ORDER.compare(this.myRevision, rev);
    }

    @NotNull
    public Revision getRevision() {
        return this.myRevision;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SvnRevisionNumber that = (SvnRevisionNumber)o;
        return this.myRevision.equals(that.myRevision);
    }

    public int hashCode() {
        return this.myRevision.hashCode();
    }

    public String toString() {
        return this.myRevision.toString();
    }
}

