/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.ForNestedRootChecker;
import org.jetbrains.idea.svn.NestedCopiesHolder;
import org.jetbrains.idea.svn.NestedCopyInfo;
import org.jetbrains.idea.svn.NestedCopyType;
import org.jetbrains.idea.svn.Node;
import org.jetbrains.idea.svn.RootUrlInfo;
import org.jetbrains.idea.svn.SvnFileUrlMappingImpl;
import org.jetbrains.idea.svn.SvnFormatSelector;
import org.jetbrains.idea.svn.SvnRootsDetector;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.status.Status;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002,-B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J)\u0010\u0013\u001a\u00020\u000e2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0017J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u0016H\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001cH\u0002J\u0016\u0010\u001d\u001a\u00020\u000e2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00190\u001fH\u0002J\u0010\u0010 \u001a\u00020\u00102\u0006\u0010!\u001a\u00020\"H\u0002J\u001e\u0010#\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020\u00162\f\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&H\u0002J\u001e\u0010(\u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\"2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00190*H\u0002J\u001e\u0010+\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020\u00162\f\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lorg/jetbrains/idea/svn/SvnRootsDetector;", "", "myVcs", "Lorg/jetbrains/idea/svn/SvnVcs;", "myMapping", "Lorg/jetbrains/idea/svn/SvnFileUrlMappingImpl;", "myNestedCopiesHolder", "Lorg/jetbrains/idea/svn/NestedCopiesHolder;", "(Lorg/jetbrains/idea/svn/SvnVcs;Lorg/jetbrains/idea/svn/SvnFileUrlMappingImpl;Lorg/jetbrains/idea/svn/NestedCopiesHolder;)V", "myRepositoryRoots", "Lorg/jetbrains/idea/svn/SvnRootsDetector$RepositoryRoots;", "myResult", "Lorg/jetbrains/idea/svn/SvnRootsDetector$Result;", "addNestedRoots", "", "clearState", "", "callback", "Ljava/lang/Runnable;", "detectCopyRoots", "roots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "([Lcom/intellij/openapi/vfs/VirtualFile;ZLjava/lang/Runnable;)V", "findAncestorTopRoot", "Lorg/jetbrains/idea/svn/RootUrlInfo;", "file", "findTopRoot", "Ljava/io/File;", "putWcDbFilesToVfs", "infos", "", "refreshPointInfo", "info", "Lorg/jetbrains/idea/svn/NestedCopyInfo;", "registerLonelyRoots", "vcsRoot", "foundRoots", "", "Lorg/jetbrains/idea/svn/Node;", "registerRootUrlFromNestedPoint", "nestedRoots", "", "registerTopRoots", "RepositoryRoots", "Result", "intellij.vcs.svn"})
public final class SvnRootsDetector {
    private final Result myResult;
    private final RepositoryRoots myRepositoryRoots;
    private final SvnVcs myVcs;
    private final SvnFileUrlMappingImpl myMapping;
    private final NestedCopiesHolder myNestedCopiesHolder;

    public final void detectCopyRoots(@NotNull VirtualFile[] roots, boolean clearState, @NotNull Runnable callback) {
        for (VirtualFile vcsRoot : roots) {
            List<Node> foundRoots = new ForNestedRootChecker(this.myVcs).getAllNestedWorkingCopies(vcsRoot);
            this.registerLonelyRoots(vcsRoot, foundRoots);
            this.registerTopRoots(vcsRoot, foundRoots);
        }
        this.addNestedRoots(clearState, callback);
    }

    private final void registerLonelyRoots(VirtualFile vcsRoot, List<? extends Node> foundRoots) {
        if (foundRoots.isEmpty()) {
            this.myResult.getLonelyRoots().add(vcsRoot);
        }
    }

    private final void registerTopRoots(VirtualFile vcsRoot, List<? extends Node> foundRoots) {
        for (Node node : foundRoots) {
            RootUrlInfo root = new RootUrlInfo(node, SvnFormatSelector.findRootAndGetFormat(node.getIoFile()), vcsRoot);
            if (!node.hasError()) {
                this.myRepositoryRoots.register(node.getRepositoryRootUrl());
                this.myResult.getTopRoots().add(root);
                continue;
            }
            this.myResult.getErrorRoots().add(root);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addNestedRoots(boolean clearState, Runnable callback) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)this.myResult.getTopRoots();
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            RootUrlInfo rootUrlInfo = (RootUrlInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            VirtualFile virtualFile = it.getVirtualFile();
            collection.add(virtualFile);
        }
        List basicVfRoots = (List)destination$iv$iv;
        ChangeListManager clManager = ChangeListManager.getInstance((Project)this.myVcs.getProject());
        if (clearState) {
            this.myNestedCopiesHolder.getAndClear();
            VcsDirtyScopeManager.getInstance((Project)this.myVcs.getProject()).filesDirty(null, (Collection)basicVfRoots);
        }
        clManager.invokeAfterUpdate(new Runnable(this, callback){
            final /* synthetic */ SvnRootsDetector this$0;
            final /* synthetic */ Runnable $callback;

            public final void run() {
                List nestedRoots = new ArrayList<E>();
                for (NestedCopyInfo info2 : SvnRootsDetector.access$getMyNestedCopiesHolder$p(this.this$0).getAndClear()) {
                    if (NestedCopyType.external == info2.getType() || NestedCopyType.switched == info2.getType()) {
                        RootUrlInfo topRoot = SvnRootsDetector.access$findTopRoot(this.this$0, VfsUtilCore.virtualToIoFile((VirtualFile)info2.getFile()));
                        if (topRoot != null) {
                            topRoot.setType(info2.getType());
                            continue;
                        }
                        if (!SvnRootsDetector.access$refreshPointInfo(this.this$0, info2)) continue;
                    }
                    SvnRootsDetector.access$registerRootUrlFromNestedPoint(this.this$0, info2, nestedRoots);
                }
                SvnRootsDetector.access$getMyResult$p(this.this$0).getTopRoots().addAll(nestedRoots);
                SvnRootsDetector.access$putWcDbFilesToVfs(this.this$0, SvnRootsDetector.access$getMyResult$p(this.this$0).getTopRoots());
                SvnRootsDetector.access$getMyMapping$p(this.this$0).applyDetectionResult(SvnRootsDetector.access$getMyResult$p(this.this$0));
                this.$callback.run();
            }
            {
                this.this$0 = svnRootsDetector;
                this.$callback = runnable;
            }
        }, InvokeAfterUpdateMode.SILENT_CALLBACK_POOLED, null, null);
    }

    private final void putWcDbFilesToVfs(Collection<? extends RootUrlInfo> infos) {
        if (!SvnVcs.ourListenToWcDb) {
            return;
        }
        List wcDbFiles2 = infos.stream().filter(putWcDbFilesToVfs.wcDbFiles.1.INSTANCE).filter(putWcDbFilesToVfs.wcDbFiles.2.INSTANCE).map(putWcDbFilesToVfs.wcDbFiles.3.INSTANCE).map(putWcDbFilesToVfs.wcDbFiles.4.INSTANCE).collect(Collectors.toList());
        LocalFileSystem.getInstance().refreshIoFiles((Iterable)wcDbFiles2, true, false, null);
    }

    private final void registerRootUrlFromNestedPoint(NestedCopyInfo info2, List<RootUrlInfo> nestedRoots) {
        block3: {
            RootUrlInfo rootUrlInfo;
            RootUrlInfo rootUrlInfo2 = this.findAncestorTopRoot(info2.getFile());
            if (rootUrlInfo2 == null) break block3;
            RootUrlInfo topRoot = rootUrlInfo = rootUrlInfo2;
            boolean bl = false;
            Url url = info2.getRootURL();
            if (url == null) {
                url = this.myRepositoryRoots.ask(info2.getUrl(), info2.getFile());
            }
            if (url != null) {
                Url url2;
                Url repoRoot = url2 = url;
                boolean bl2 = false;
                VirtualFile virtualFile = info2.getFile();
                Url url3 = info2.getUrl();
                if (url3 == null) {
                    Intrinsics.throwNpe();
                }
                Node node = new Node(virtualFile, url3, repoRoot);
                nestedRoots.add(new RootUrlInfo(node, info2.getFormat(), topRoot.getRoot(), info2.getType()));
            }
        }
    }

    private final boolean refreshPointInfo(NestedCopyInfo info2) {
        boolean refreshed = false;
        File infoFile = VfsUtilCore.virtualToIoFile((VirtualFile)info2.getFile());
        Status svnStatus = SvnUtil.getStatus(this.myVcs, infoFile);
        if (svnStatus != null && svnStatus.getUrl() != null) {
            info2.setUrl(svnStatus.getUrl());
            info2.setFormat(this.myVcs.getWorkingCopyFormat(infoFile, false));
            if (svnStatus.getRepositoryRootUrl() != null) {
                info2.setRootURL(svnStatus.getRepositoryRootUrl());
            }
            refreshed = true;
        }
        return refreshed;
    }

    private final RootUrlInfo findTopRoot(File file) {
        Object v0;
        block1: {
            Iterable iterable;
            Iterable iterable2 = iterable = (Iterable)this.myResult.getTopRoots();
            for (Object t : iterable2) {
                RootUrlInfo it = (RootUrlInfo)t;
                boolean bl = false;
                if (!FileUtil.filesEqual((File)it.getIoFile(), (File)file)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final RootUrlInfo findAncestorTopRoot(VirtualFile file) {
        Object v0;
        block1: {
            Iterable iterable;
            Iterable iterable2 = iterable = (Iterable)this.myResult.getTopRoots();
            for (Object t : iterable2) {
                RootUrlInfo it = (RootUrlInfo)t;
                boolean bl = false;
                if (!VfsUtilCore.isAncestor((VirtualFile)it.getVirtualFile(), (VirtualFile)file, (boolean)true)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    public SvnRootsDetector(@NotNull SvnVcs myVcs, @NotNull SvnFileUrlMappingImpl myMapping, @NotNull NestedCopiesHolder myNestedCopiesHolder) {
        this.myVcs = myVcs;
        this.myMapping = myMapping;
        this.myNestedCopiesHolder = myNestedCopiesHolder;
        this.myResult = new Result();
        this.myRepositoryRoots = new RepositoryRoots(this.myVcs);
    }

    public static final /* synthetic */ NestedCopiesHolder access$getMyNestedCopiesHolder$p(SvnRootsDetector $this) {
        return $this.myNestedCopiesHolder;
    }

    public static final /* synthetic */ RootUrlInfo access$findTopRoot(SvnRootsDetector $this, File file) {
        return $this.findTopRoot(file);
    }

    public static final /* synthetic */ boolean access$refreshPointInfo(SvnRootsDetector $this, NestedCopyInfo info2) {
        return $this.refreshPointInfo(info2);
    }

    public static final /* synthetic */ void access$registerRootUrlFromNestedPoint(SvnRootsDetector $this, NestedCopyInfo info2, List nestedRoots) {
        $this.registerRootUrlFromNestedPoint(info2, nestedRoots);
    }

    public static final /* synthetic */ Result access$getMyResult$p(SvnRootsDetector $this) {
        return $this.myResult;
    }

    public static final /* synthetic */ void access$putWcDbFilesToVfs(SvnRootsDetector $this, Collection infos) {
        $this.putWcDbFilesToVfs(infos);
    }

    public static final /* synthetic */ SvnFileUrlMappingImpl access$getMyMapping$p(SvnRootsDetector $this) {
        return $this.myMapping;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\b\u001a\u0004\u0018\u00010\u00072\b\u0010\t\u001a\u0004\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u0007R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/idea/svn/SvnRootsDetector$RepositoryRoots;", "", "myVcs", "Lorg/jetbrains/idea/svn/SvnVcs;", "(Lorg/jetbrains/idea/svn/SvnVcs;)V", "myRoots", "", "Lorg/jetbrains/idea/svn/api/Url;", "ask", "url", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "register", "", "intellij.vcs.svn"})
    private static final class RepositoryRoots {
        private final Set<Url> myRoots;
        private final SvnVcs myVcs;

        public final void register(@NotNull Url url) {
            this.myRoots.add(url);
        }

        @Nullable
        public final Url ask(@Nullable Url url, @NotNull VirtualFile file) {
            Url root;
            Url url2;
            Url url3;
            Url it;
            Url url4;
            Url url5 = url;
            if (url5 != null) {
                Object v1;
                block6: {
                    Iterable iterable;
                    it = url4 = url5;
                    boolean bl = false;
                    Iterable iterable2 = iterable = (Iterable)this.myRoots;
                    for (Object t : iterable2) {
                        Url root2 = (Url)t;
                        boolean bl2 = false;
                        if (!SvnUtil.isAncestor(root2, it)) continue;
                        v1 = t;
                        break block6;
                    }
                    v1 = null;
                }
                url3 = v1;
            } else {
                url3 = null;
            }
            if ((url2 = (root = url3)) == null) {
                Url url6 = SvnUtil.getRepositoryRoot(this.myVcs, VfsUtilCore.virtualToIoFile((VirtualFile)file));
                if (url6 != null) {
                    it = url4 = url6;
                    boolean bl = false;
                    this.myRoots.add(it);
                    url2 = url4;
                } else {
                    url2 = null;
                }
            }
            return url2;
        }

        public RepositoryRoots(@NotNull SvnVcs myVcs) {
            Set set;
            this.myVcs = myVcs;
            RepositoryRoots repositoryRoots = this;
            repositoryRoots.myRoots = set = (Set)new LinkedHashSet();
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0007R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0007\u00a8\u0006\r"}, d2={"Lorg/jetbrains/idea/svn/SvnRootsDetector$Result;", "", "()V", "errorRoots", "", "Lorg/jetbrains/idea/svn/RootUrlInfo;", "getErrorRoots", "()Ljava/util/List;", "lonelyRoots", "Lcom/intellij/openapi/vfs/VirtualFile;", "getLonelyRoots", "topRoots", "getTopRoots", "intellij.vcs.svn"})
    public static final class Result {
        @NotNull
        private final List<VirtualFile> lonelyRoots;
        @NotNull
        private final List<RootUrlInfo> topRoots;
        @NotNull
        private final List<RootUrlInfo> errorRoots;

        @NotNull
        public final List<VirtualFile> getLonelyRoots() {
            return this.lonelyRoots;
        }

        @NotNull
        public final List<RootUrlInfo> getTopRoots() {
            return this.topRoots;
        }

        @NotNull
        public final List<RootUrlInfo> getErrorRoots() {
            return this.errorRoots;
        }

        public Result() {
            List list;
            Result result = this;
            result.lonelyRoots = list = (List)new ArrayList();
            result = this;
            result.topRoots = list = (List)new ArrayList();
            result = this;
            result.errorRoots = list = (List)new ArrayList();
        }
    }
}

