/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcsUtil.VcsUtil;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SvnScopeZipper
implements Runnable {
    @NotNull
    private final VcsDirtyScope myIn;
    @NotNull
    private final List<FilePath> myRecursiveDirs;
    @NotNull
    private final MultiMap<FilePath, FilePath> myNonRecursiveDirs = MultiMap.createSet();

    public SvnScopeZipper(@NotNull VcsDirtyScope in) {
        this.myIn = in;
        this.myRecursiveDirs = ContainerUtil.newArrayList((Iterable)in.getRecursivelyDirtyDirectories());
    }

    @Override
    public void run() {
        Set files = this.myIn.getDirtyFilesNoExpand();
        for (FilePath file : files) {
            if (file.isDirectory()) {
                VirtualFile vFile = file.getVirtualFile();
                if (vFile == null || !vFile.isValid()) continue;
                for (VirtualFile child : vFile.getChildren()) {
                    this.myNonRecursiveDirs.putValue((Object)file, (Object)VcsUtil.getFilePath((VirtualFile)child));
                }
                continue;
            }
            FilePath parent = file.getParentPath();
            if (parent == null) continue;
            this.myNonRecursiveDirs.putValue((Object)parent, (Object)file);
        }
    }

    @NotNull
    public List<FilePath> getRecursiveDirs() {
        return this.myRecursiveDirs;
    }

    @NotNull
    public MultiMap<FilePath, FilePath> getNonRecursiveDirs() {
        return this.myNonRecursiveDirs;
    }
}

