/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.RootUrlPair;
import org.jetbrains.idea.svn.SvnUtil;

public class UniqueRootsFilter {
    @NotNull
    public <T extends RootUrlPair> List<T> filter(@NotNull List<T> list) {
        ArrayList result = ContainerUtil.newArrayList();
        Collections.sort(list, Comparator.comparing(item -> item.getVirtualFile().getPath()));
        for (RootUrlPair child : list) {
            if (UniqueRootsFilter.alreadyRegistered(child, result)) continue;
            result.add(child);
        }
        return result;
    }

    private static <T extends RootUrlPair> boolean alreadyRegistered(@NotNull T child, @NotNull List<T> registered) {
        return ContainerUtil.exists(registered, parent -> UniqueRootsFilter.isSamePath(child, parent) || UniqueRootsFilter.isSameSupposedUrl(child, parent));
    }

    private static <T extends RootUrlPair> boolean isSamePath(@NotNull T child, @NotNull T parent) {
        return parent.getVirtualFile().getPath().equals(child.getVirtualFile().getPath());
    }

    private static <T extends RootUrlPair> boolean isSameSupposedUrl(@NotNull T child, @NotNull T parent) {
        String relativePath = VfsUtilCore.getRelativePath((VirtualFile)child.getVirtualFile(), (VirtualFile)parent.getVirtualFile(), (char)'/');
        return relativePath != null && relativePath.equals(SvnUtil.getRelativeUrl(parent.getUrl(), child.getUrl()));
    }
}

