/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.UtilKt;
import java.io.File;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnProgressCanceller;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.ClientFactory;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.commandLine.CommandUtil;
import org.jetbrains.idea.svn.dialogs.SelectCreateExternalTargetDialog;
import org.jetbrains.idea.svn.properties.ExternalsDefinitionParser;
import org.jetbrains.idea.svn.properties.PropertyValue;
import org.jetbrains.idea.svn.update.UpdateClient;

public class CreateExternalAction
extends DumbAwareAction {
    public CreateExternalAction() {
        super(SvnBundle.message("svn.create.external.below.action", new Object[0]), SvnBundle.message("svn.create.external.below.description", new Object[0]), null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        VirtualFile file;
        final Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        SelectCreateExternalTargetDialog dialog = new SelectCreateExternalTargetDialog(project, file = (VirtualFile)ObjectUtils.notNull((Object)UtilKt.getIfSingle((Stream)((Stream)e.getData(VcsDataKeys.VIRTUAL_FILE_STREAM)))));
        if (dialog.showAndGet()) {
            final String url = dialog.getSelectedURL();
            final boolean checkout = dialog.isCheckout();
            final String target = dialog.getLocalTarget().trim();
            new Task.Backgroundable(project, "Creating External"){

                public void run(@NotNull ProgressIndicator indicator) {
                    CreateExternalAction.doInBackground(project, file, url, checkout, target);
                }
            }.queue();
        }
    }

    private static void doInBackground(@NotNull Project project, @NotNull VirtualFile file, String url, boolean checkout, String target) {
        SvnVcs vcs = SvnVcs.getInstance(project);
        VcsDirtyScopeManager dirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)project);
        File ioFile = VfsUtilCore.virtualToIoFile((VirtualFile)file);
        try {
            CreateExternalAction.addToExternalProperty(vcs, ioFile, target, url);
            dirtyScopeManager.fileDirty(file);
            if (checkout) {
                UpdateClient client = vcs.getFactory(ioFile).createUpdateClient();
                client.setEventHandler(new SvnProgressCanceller());
                client.doUpdate(ioFile, Revision.HEAD, Depth.UNKNOWN, false, false);
                file.refresh(true, true, () -> dirtyScopeManager.dirDirtyRecursively(file));
            }
        }
        catch (VcsException e) {
            AbstractVcsHelper.getInstance((Project)project).showError(e, "Create External");
        }
    }

    public static void addToExternalProperty(@NotNull SvnVcs vcs, @NotNull File ioFile, String target, String url) throws VcsException {
        ClientFactory factory = vcs.getFactory(ioFile);
        PropertyValue propertyValue = factory.createPropertyClient().getProperty(Target.on(ioFile), "svn:externals", false, Revision.UNDEFINED);
        boolean hasExternals = propertyValue != null && !StringUtil.isEmptyOrSpaces((String)propertyValue.toString());
        String newExternals = "";
        if (hasExternals) {
            String externalsForTarget = ExternalsDefinitionParser.parseExternalsProperty(propertyValue.toString()).get(target);
            if (externalsForTarget != null) {
                throw new VcsException("Selected destination conflicts with existing: " + externalsForTarget);
            }
            newExternals = propertyValue.toString().trim() + "\n";
        }
        newExternals = newExternals + CommandUtil.escape(url) + " " + target;
        factory.createPropertyClient().setProperty(ioFile, "svn:externals", PropertyValue.create(newExternals), Depth.EMPTY, false);
    }

    public void update(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        boolean visible = project != null && CreateExternalAction.isSvnActive(project);
        boolean enabled = visible && CreateExternalAction.isEnabled(project, (VirtualFile)UtilKt.getIfSingle((Stream)((Stream)e.getData(VcsDataKeys.VIRTUAL_FILE_STREAM))));
        e.getPresentation().setVisible(visible);
        e.getPresentation().setEnabled(enabled);
    }

    private static boolean isSvnActive(@NotNull Project project) {
        return ProjectLevelVcsManager.getInstance((Project)project).checkVcsIsActive("svn");
    }

    private static boolean isEnabled(@NotNull Project project, @Nullable VirtualFile file) {
        return file != null && file.isDirectory() && ChangesUtil.getVcsForFile((VirtualFile)file, (Project)project) instanceof SvnVcs && CreateExternalAction.isEnabled(FileStatusManager.getInstance((Project)project).getStatus(file));
    }

    private static boolean isEnabled(@Nullable FileStatus status) {
        return status != null && !FileStatus.DELETED.equals(status) && !FileStatus.IGNORED.equals(status) && !FileStatus.MERGED_WITH_PROPERTY_CONFLICTS.equals(status) && !FileStatus.OBSOLETE.equals(status) && !FileStatus.UNKNOWN.equals(status);
    }
}

