/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.ConflictedSvnChange;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Depth;

public class MarkTreeConflictResolvedAction
extends AnAction
implements DumbAware {
    private static final String myText = SvnBundle.message("action.mark.tree.conflict.resolved.text", new Object[0]);

    public MarkTreeConflictResolvedAction() {
        super(myText);
    }

    public void update(@NotNull AnActionEvent e) {
        MyChecker checker2 = new MyChecker(e);
        e.getPresentation().setVisible(checker2.isEnabled());
        e.getPresentation().setEnabled(checker2.isEnabled());
        e.getPresentation().setText(myText);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        final MyChecker checker2 = new MyChecker(e);
        if (!checker2.isEnabled()) {
            return;
        }
        String markText = SvnBundle.message("action.mark.tree.conflict.resolved.confirmation.title", new Object[0]);
        int result = Messages.showYesNoDialog((Project)checker2.getProject(), (String)SvnBundle.message("action.mark.tree.conflict.resolved.confirmation.text", new Object[0]), (String)markText, (Icon)Messages.getQuestionIcon());
        if (result == 0) {
            final Ref exception = new Ref();
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(checker2.getProject(), markText, true){

                public void run(@NotNull ProgressIndicator indicator) {
                    ConflictedSvnChange change = checker2.getChange();
                    FilePath path = change.getTreeConflictMarkHolder();
                    SvnVcs vcs = SvnVcs.getInstance(checker2.getProject());
                    try {
                        vcs.getFactory(path.getIOFile()).createConflictClient().resolve(path.getIOFile(), Depth.EMPTY, false, false, true);
                    }
                    catch (VcsException e) {
                        exception.set((Object)e);
                    }
                    VcsDirtyScopeManager.getInstance((Project)checker2.getProject()).filePathsDirty(MarkTreeConflictResolvedAction.this.getDistinctFiles(change), null);
                }
            });
            if (!exception.isNull()) {
                AbstractVcsHelper.getInstance((Project)checker2.getProject()).showError((VcsException)((Object)exception.get()), markText);
            }
        }
    }

    private Collection<FilePath> getDistinctFiles(Change change) {
        ArrayList<FilePath> result = new ArrayList<FilePath>(2);
        if (change.getBeforeRevision() != null) {
            result.add(change.getBeforeRevision().getFile());
        }
        if (change.getAfterRevision() != null && (change.getBeforeRevision() == null || change.getBeforeRevision() != null && (change.isMoved() || change.isRenamed()))) {
            result.add(change.getAfterRevision().getFile());
        }
        return result;
    }

    private static class MyChecker {
        private final boolean myEnabled;
        private final ConflictedSvnChange myChange;
        private final Project myProject;

        MyChecker(AnActionEvent e) {
            DataContext dc = e.getDataContext();
            this.myProject = (Project)CommonDataKeys.PROJECT.getData(dc);
            Change[] changes = (Change[])VcsDataKeys.CHANGE_LEAD_SELECTION.getData(dc);
            if (this.myProject == null || changes == null || changes.length != 1) {
                this.myEnabled = false;
                this.myChange = null;
                return;
            }
            Change change = changes[0];
            this.myEnabled = change instanceof ConflictedSvnChange && ((ConflictedSvnChange)change).getConflictState().isTree();
            this.myChange = this.myEnabled ? (ConflictedSvnChange)change : null;
        }

        public boolean isEnabled() {
            return this.myEnabled;
        }

        public ConflictedSvnChange getChange() {
            return this.myChange;
        }

        public Project getProject() {
            return this.myProject;
        }
    }
}

