/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.api;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.add.AddClient;
import org.jetbrains.idea.svn.annotate.AnnotateClient;
import org.jetbrains.idea.svn.api.ProgressTracker;
import org.jetbrains.idea.svn.api.RepositoryFeaturesClient;
import org.jetbrains.idea.svn.api.SvnClient;
import org.jetbrains.idea.svn.api.VersionClient;
import org.jetbrains.idea.svn.browse.BrowseClient;
import org.jetbrains.idea.svn.change.ChangeListClient;
import org.jetbrains.idea.svn.checkin.CheckinClient;
import org.jetbrains.idea.svn.checkin.ImportClient;
import org.jetbrains.idea.svn.checkout.CheckoutClient;
import org.jetbrains.idea.svn.checkout.ExportClient;
import org.jetbrains.idea.svn.cleanup.CleanupClient;
import org.jetbrains.idea.svn.conflict.ConflictClient;
import org.jetbrains.idea.svn.content.ContentClient;
import org.jetbrains.idea.svn.copy.CopyMoveClient;
import org.jetbrains.idea.svn.delete.DeleteClient;
import org.jetbrains.idea.svn.diff.DiffClient;
import org.jetbrains.idea.svn.history.HistoryClient;
import org.jetbrains.idea.svn.info.InfoClient;
import org.jetbrains.idea.svn.integrate.MergeClient;
import org.jetbrains.idea.svn.lock.LockClient;
import org.jetbrains.idea.svn.properties.PropertyClient;
import org.jetbrains.idea.svn.revert.RevertClient;
import org.jetbrains.idea.svn.status.StatusClient;
import org.jetbrains.idea.svn.update.RelocateClient;
import org.jetbrains.idea.svn.update.UpdateClient;
import org.jetbrains.idea.svn.upgrade.UpgradeClient;

public abstract class ClientFactory {
    @NotNull
    protected SvnVcs myVcs;
    protected AddClient addClient;
    protected AnnotateClient annotateClient;
    protected ContentClient contentClient;
    protected HistoryClient historyClient;
    protected RevertClient revertClient;
    protected DeleteClient deleteClient;
    protected StatusClient statusClient;
    protected InfoClient infoClient;
    protected CopyMoveClient copyMoveClient;
    protected ConflictClient conflictClient;
    protected PropertyClient propertyClient;
    protected MergeClient mergeClient;
    protected ChangeListClient changeListClient;
    protected CheckoutClient checkoutClient;
    protected LockClient myLockClient;
    protected CleanupClient myCleanupClient;
    protected RelocateClient myRelocateClient;
    protected VersionClient myVersionClient;
    protected ImportClient myImportClient;
    protected ExportClient myExportClient;
    protected UpgradeClient myUpgradeClient;
    protected BrowseClient myBrowseClient;
    protected DiffClient myDiffClient;
    protected CheckinClient myCheckinClient;
    protected RepositoryFeaturesClient myRepositoryFeaturesClient;
    @NotNull
    private final Map<Class, Class> myClientImplementations = ContainerUtil.newHashMap();

    protected ClientFactory(@NotNull SvnVcs vcs) {
        this.myVcs = vcs;
        this.setup();
    }

    protected abstract void setup();

    protected <T extends SvnClient> void put(@NotNull Class<T> type, @NotNull Class<? extends T> implementation) {
        this.myClientImplementations.put(type, implementation);
    }

    @NotNull
    protected <T extends SvnClient> Class<? extends T> get(@NotNull Class<T> type) {
        Class implementation = this.myClientImplementations.get(type);
        if (implementation == null) {
            throw new IllegalArgumentException("No implementation registered for " + type);
        }
        return implementation;
    }

    @NotNull
    public <T extends SvnClient> T create(@NotNull Class<T> type, boolean isActive) {
        SvnClient client = this.prepare((SvnClient)ReflectionUtil.newInstance(this.get(type)));
        client.setIsActive(isActive);
        return (T)client;
    }

    @NotNull
    public AddClient createAddClient() {
        return this.prepare(this.addClient);
    }

    @NotNull
    public AnnotateClient createAnnotateClient() {
        return this.prepare(this.annotateClient);
    }

    @NotNull
    public ContentClient createContentClient() {
        return this.prepare(this.contentClient);
    }

    @NotNull
    public HistoryClient createHistoryClient() {
        return this.prepare(this.historyClient);
    }

    @NotNull
    public RevertClient createRevertClient() {
        return this.prepare(this.revertClient);
    }

    @NotNull
    public StatusClient createStatusClient() {
        return this.prepare(this.statusClient);
    }

    @NotNull
    public StatusClient createStatusClient(@Nullable MultiMap<FilePath, FilePath> scope, @NotNull ProgressTracker handler) {
        return this.createStatusClient();
    }

    @NotNull
    public InfoClient createInfoClient() {
        return this.prepare(this.infoClient);
    }

    @NotNull
    public abstract UpdateClient createUpdateClient();

    @NotNull
    public DeleteClient createDeleteClient() {
        return this.prepare(this.deleteClient);
    }

    @NotNull
    public CopyMoveClient createCopyMoveClient() {
        return this.prepare(this.copyMoveClient);
    }

    @NotNull
    public ConflictClient createConflictClient() {
        return this.prepare(this.conflictClient);
    }

    @NotNull
    public PropertyClient createPropertyClient() {
        return this.prepare(this.propertyClient);
    }

    @NotNull
    public MergeClient createMergeClient() {
        return this.prepare(this.mergeClient);
    }

    @NotNull
    public ChangeListClient createChangeListClient() {
        return this.prepare(this.changeListClient);
    }

    @NotNull
    public CheckoutClient createCheckoutClient() {
        return this.prepare(this.checkoutClient);
    }

    @NotNull
    public LockClient createLockClient() {
        return this.prepare(this.myLockClient);
    }

    @NotNull
    public CleanupClient createCleanupClient() {
        return this.prepare(this.myCleanupClient);
    }

    @NotNull
    public RelocateClient createRelocateClient() {
        return this.prepare(this.myRelocateClient);
    }

    @NotNull
    public VersionClient createVersionClient() {
        return this.prepare(this.myVersionClient);
    }

    @NotNull
    public ImportClient createImportClient() {
        return this.prepare(this.myImportClient);
    }

    @NotNull
    public ExportClient createExportClient() {
        return this.prepare(this.myExportClient);
    }

    @NotNull
    public UpgradeClient createUpgradeClient() {
        return this.prepare(this.myUpgradeClient);
    }

    @NotNull
    public BrowseClient createBrowseClient() {
        return this.prepare(this.myBrowseClient);
    }

    @NotNull
    public DiffClient createDiffClient() {
        return this.prepare(this.myDiffClient);
    }

    @NotNull
    public CheckinClient createCheckinClient() {
        return this.prepare(this.myCheckinClient);
    }

    @NotNull
    public RepositoryFeaturesClient createRepositoryFeaturesClient() {
        return this.prepare(this.myRepositoryFeaturesClient);
    }

    @NotNull
    protected <T extends SvnClient> T prepare(@NotNull T client) {
        client.setVcs(this.myVcs);
        client.setFactory(this);
        client.setIsActive(true);
        return client;
    }
}

