/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.api;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.DateFormatUtil;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.api.RevisionKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0001\n\u0002\b\u0003\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB1\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u0013\u0010\u0015\u001a\u00020\u000e2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0017\u001a\u00020\u0003H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u0005H\u0016R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/idea/svn/api/Revision;", "", "order", "", "keyword", "", "number", "", "date", "Ljava/util/Date;", "(ILjava/lang/String;JLjava/util/Date;)V", "getDate", "()Ljava/util/Date;", "isLocal", "", "()Z", "isValid", "getKeyword", "()Ljava/lang/String;", "getNumber", "()J", "equals", "other", "hashCode", "throwIllegalState", "", "toString", "Companion", "intellij.vcs.svn"})
public final class Revision {
    private final int order;
    @Nullable
    private final String keyword;
    private final long number;
    @Nullable
    private final Date date;
    private static final HashMap<String, Revision> ourKeywordRevisions;
    @JvmField
    @NotNull
    public static final Revision BASE;
    @JvmField
    @NotNull
    public static final Revision COMMITTED;
    @JvmField
    @NotNull
    public static final Revision HEAD;
    @JvmField
    @NotNull
    public static final Revision PREV;
    @JvmField
    @NotNull
    public static final Revision WORKING;
    @JvmField
    @NotNull
    public static final Revision UNDEFINED;
    @JvmField
    @NotNull
    public static final Comparator<Revision> GENERAL_ORDER;
    public static final Companion Companion;

    public final boolean isValid() {
        return this != UNDEFINED;
    }

    public final boolean isLocal() {
        return this == BASE || this == WORKING;
    }

    public boolean equals(@Nullable Object other) {
        boolean bl;
        if (this == other) {
            return true;
        }
        if (!(other instanceof Revision)) {
            return false;
        }
        if (this.keyword != null) {
            bl = Intrinsics.areEqual((Object)this.keyword, (Object)((Revision)other).keyword);
        } else if (this.number >= 0L) {
            bl = this.number == ((Revision)other).number;
        } else if (this.date != null) {
            bl = Intrinsics.areEqual((Object)this.date, (Object)((Revision)other).date);
        } else {
            Void void_ = this.throwIllegalState();
            throw null;
        }
        return bl;
    }

    public int hashCode() {
        int n;
        if (this.keyword != null) {
            n = this.keyword.hashCode();
        } else if (this.number >= 0L) {
            n = Long.hashCode(this.number);
        } else if (this.date != null) {
            n = this.date.hashCode();
        } else {
            Void void_ = this.throwIllegalState();
            throw null;
        }
        return n;
    }

    @NotNull
    public String toString() {
        String string;
        if (this.keyword != null) {
            string = this.keyword;
        } else if (this.number >= 0L) {
            string = String.valueOf(this.number);
        } else if (this.date != null) {
            string = DateFormat.getDateTimeInstance().format(this.date);
        } else {
            Void void_ = this.throwIllegalState();
            throw null;
        }
        return string;
    }

    private final Void throwIllegalState() {
        throw (Throwable)new IllegalStateException("no keyword, number or date in revision");
    }

    @Nullable
    public final String getKeyword() {
        return this.keyword;
    }

    public final long getNumber() {
        return this.number;
    }

    @Nullable
    public final Date getDate() {
        return this.date;
    }

    private Revision(int order, String keyword, long number, Date date) {
        block1: {
            String string;
            this.order = order;
            this.keyword = keyword;
            this.number = number;
            this.date = date;
            if (this.keyword == null && this.number < 0L && this.date == null) {
                Void void_ = this.throwIllegalState();
                throw null;
            }
            String string2 = this.keyword;
            if (string2 == null) break block1;
            String it = string = string2;
            boolean bl = false;
            Map map = ourKeywordRevisions;
            String string3 = this.keyword;
            Revision revision = this;
            map.put(string3, revision);
        }
    }

    /* synthetic */ Revision(int n, String string, long l, Date date, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            string = null;
        }
        if ((n2 & 4) != 0) {
            l = -1L;
        }
        if ((n2 & 8) != 0) {
            date = null;
        }
        this(n, string, l, date);
    }

    static {
        Companion = new Companion(null);
        ourKeywordRevisions = ContainerUtil.newHashMap();
        BASE = new Revision(2, "BASE", 0L, null, 12, null);
        COMMITTED = new Revision(3, "COMMITTED", 0L, null, 12, null);
        HEAD = new Revision(0, "HEAD", 0L, null, 12, null);
        PREV = new Revision(4, "PREV", 0L, null, 12, null);
        WORKING = new Revision(1, "WORKING", 0L, null, 12, null);
        UNDEFINED = new Revision(30, "UNDEFINED", 0L, null, 12, null);
        GENERAL_ORDER = new Comparator<T>(){

            public final int compare(T a, T b) {
                Revision it = (Revision)b;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(Revision.access$getOrder$p(it));
                it = (Revision)a;
                Comparable comparable2 = comparable;
                bl = false;
                Integer n = Revision.access$getOrder$p(it);
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
            }
        };
    }

    public static final /* synthetic */ int access$getOrder$p(Revision $this) {
        return $this.order;
    }

    @JvmStatic
    @NotNull
    public static final Revision of(long number) {
        return Companion.of(number);
    }

    @JvmStatic
    @NotNull
    public static final Revision of(@NotNull Date date) {
        return Companion.of(date);
    }

    @JvmStatic
    @NotNull
    public static final Revision parse(@Nullable String value) {
        return Companion.parse(value);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0011\u001a\u00020\u000eH\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0011\u001a\u00020\u000eH\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0011\u001a\u00020\u000eH\u0002J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J\u0012\u0010\u0019\u001a\u00020\u00042\b\u0010\u0011\u001a\u0004\u0018\u00010\u000eH\u0007J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0011\u001a\u00020\u000eH\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0011\u001a\u00020\u000eH\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\f\u001a\u001e\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u00040\u00040\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/idea/svn/api/Revision$Companion;", "", "()V", "BASE", "Lorg/jetbrains/idea/svn/api/Revision;", "COMMITTED", "GENERAL_ORDER", "Ljava/util/Comparator;", "HEAD", "PREV", "UNDEFINED", "WORKING", "ourKeywordRevisions", "Ljava/util/HashMap;", "", "kotlin.jvm.PlatformType", "fromDate", "value", "fromKeyword", "fromNumber", "of", "date", "Ljava/util/Date;", "number", "", "parse", "parseDate", "parseIso8601", "intellij.vcs.svn"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final Revision of(long number) {
            return number < 0L ? UNDEFINED : new Revision(10, null, number, null, 10, null);
        }

        @JvmStatic
        @NotNull
        public final Revision of(@NotNull Date date) {
            return new Revision(20, null, 0L, date, 6, null);
        }

        @JvmStatic
        @NotNull
        public final Revision parse(@Nullable String value) {
            Revision revision;
            Revision revision2;
            Revision revision3;
            if (value == null) {
                return UNDEFINED;
            }
            Revision revision4 = this.fromKeyword(value);
            if (revision4 == null) {
                revision4 = revision3 = this.fromNumber(value);
            }
            if (revision4 == null) {
                revision3 = revision2 = this.fromDate(value);
            }
            if (revision2 == null) {
                RevisionKt.access$getLOG$p().info("Could not parse revision " + value);
            }
            if ((revision = revision2) == null) {
                revision = UNDEFINED;
            }
            return revision;
        }

        private final Revision fromKeyword(String value) {
            return (Revision)ourKeywordRevisions.get(value);
        }

        private final Revision fromNumber(String value) {
            Revision revision;
            Long l = StringsKt.toLongOrNull((String)value);
            if (l != null) {
                Long l2 = l;
                long it = ((Number)l2).longValue();
                boolean bl = false;
                revision = Companion.of(it);
            } else {
                revision = null;
            }
            return revision;
        }

        private final Revision fromDate(String value) {
            Revision revision;
            Date date = this.parseDate(StringsKt.removeSurrounding((String)value, (CharSequence)"{", (CharSequence)"}"));
            if (date != null) {
                Date date2;
                Date it = date2 = date;
                boolean bl = false;
                revision = Companion.of(it);
            } else {
                revision = null;
            }
            return revision;
        }

        private final Date parseDate(String value) {
            Date date = SvnUtil.parseDate(value, false);
            if (date == null) {
                date = this.parseIso8601(value);
            }
            return date;
        }

        private final Date parseIso8601(String value) {
            try {
                return DateFormatUtil.getIso8601Format().parse(value);
            }
            catch (ParseException e) {
                return null;
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

