/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.branchConfig;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.branch.BranchData;
import com.intellij.vcs.branch.BranchDataImpl;
import com.intellij.vcs.branch.BranchStateProvider;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.RootUrlInfo;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationManager;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationNew;
import org.jetbrains.idea.svn.branchConfig.SvnBranchStateProviderKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/idea/svn/branchConfig/SvnBranchStateProvider;", "Lcom/intellij/vcs/branch/BranchStateProvider;", "project", "Lcom/intellij/openapi/project/Project;", "vcsManager", "Lcom/intellij/openapi/vcs/ProjectLevelVcsManager;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vcs/ProjectLevelVcsManager;)V", "branchManager", "Lorg/jetbrains/idea/svn/branchConfig/SvnBranchConfigurationManager;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getVcsManager", "()Lcom/intellij/openapi/vcs/ProjectLevelVcsManager;", "getCurrentBranch", "Lcom/intellij/vcs/branch/BranchData;", "path", "Lcom/intellij/openapi/vcs/FilePath;", "intellij.vcs.svn"})
public final class SvnBranchStateProvider
implements BranchStateProvider {
    private final SvnBranchConfigurationManager branchManager;
    @NotNull
    private final Project project;
    @NotNull
    private final ProjectLevelVcsManager vcsManager;

    @Nullable
    public BranchData getCurrentBranch(@NotNull FilePath path) {
        Object object;
        if (!this.vcsManager.checkVcsIsActive("svn")) {
            return null;
        }
        AbstractVcs abstractVcs = this.vcsManager.getVcsFor(path);
        if (!(abstractVcs instanceof SvnVcs)) {
            abstractVcs = null;
        }
        if ((object = (SvnVcs)abstractVcs) == null || (object = ((SvnVcs)((Object)object)).getSvnFileUrlMapping()) == null || (object = object.getWcRootForFilePath(path)) == null) {
            return null;
        }
        Object wcRoot = object;
        SvnBranchConfigurationNew svnBranchConfigurationNew = this.branchManager.getSvnBranchConfigManager().getConfigOrNull(((RootUrlInfo)wcRoot).getVirtualFile());
        if (svnBranchConfigurationNew == null) {
            return null;
        }
        SvnBranchConfigurationNew configuration = svnBranchConfigurationNew;
        Url url = configuration.getWorkingBranch(((RootUrlInfo)wcRoot).getUrl());
        if (url == null) {
            return null;
        }
        Url branchUrl = url;
        String presentableRootName = SvnBranchStateProviderKt.access$join(((RootUrlInfo)wcRoot).getRoot().getPresentableName(), VfsUtilCore.getRelativePath((VirtualFile)((RootUrlInfo)wcRoot).getVirtualFile(), (VirtualFile)((RootUrlInfo)wcRoot).getRoot()));
        return (BranchData)new BranchDataImpl(presentableRootName, Intrinsics.areEqual((Object)branchUrl, (Object)configuration.getTrunk()) ? "trunk" : branchUrl.getTail());
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final ProjectLevelVcsManager getVcsManager() {
        return this.vcsManager;
    }

    public SvnBranchStateProvider(@NotNull Project project, @NotNull ProjectLevelVcsManager vcsManager) {
        this.project = project;
        this.vcsManager = vcsManager;
        this.branchManager = SvnBranchConfigurationManager.Companion.getInstance(this.project);
    }
}

