/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.branchConfig;

import com.intellij.util.io.KeyDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.commandLine.SvnBindException;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0014B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0018\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0002H\u0016J\u0010\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\u0002H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/idea/svn/branchConfig/UrlDescriptor;", "Lcom/intellij/util/io/KeyDescriptor;", "Lorg/jetbrains/idea/svn/api/Url;", "isEncoded", "", "(Z)V", "()Z", "getHashCode", "", "value", "isEqual", "val1", "val2", "read", "in", "Ljava/io/DataInput;", "save", "", "out", "Ljava/io/DataOutput;", "Companion", "intellij.vcs.svn"})
public final class UrlDescriptor
implements KeyDescriptor<Url> {
    private final boolean isEncoded;
    @JvmField
    @NotNull
    public static final UrlDescriptor ENCODED_URL_DESCRIPTOR;
    @JvmField
    @NotNull
    public static final UrlDescriptor DECODED_URL_DESCRIPTOR;
    public static final Companion Companion;

    public void save(@NotNull DataOutput out, @NotNull Url value) throws IOException {
        out.writeUTF(this.isEncoded ? value.toString() : value.toDecodedString());
    }

    @NotNull
    public Url read(@NotNull DataInput in) throws IOException {
        Url url;
        String urlValue = in.readUTF();
        try {
            url = SvnUtil.createUrl(urlValue, this.isEncoded);
        }
        catch (SvnBindException e) {
            throw (Throwable)new IOException("Could not parse url " + urlValue, (Throwable)((Object)e));
        }
        return url;
    }

    public int getHashCode(@NotNull Url value) {
        return value.hashCode();
    }

    public boolean isEqual(@NotNull Url val1, @NotNull Url val2) {
        return Intrinsics.areEqual((Object)val1, (Object)val2);
    }

    public final boolean isEncoded() {
        return this.isEncoded;
    }

    public UrlDescriptor(boolean isEncoded) {
        this.isEncoded = isEncoded;
    }

    static {
        Companion = new Companion(null);
        ENCODED_URL_DESCRIPTOR = new UrlDescriptor(true);
        DECODED_URL_DESCRIPTOR = new UrlDescriptor(false);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/idea/svn/branchConfig/UrlDescriptor$Companion;", "", "()V", "DECODED_URL_DESCRIPTOR", "Lorg/jetbrains/idea/svn/branchConfig/UrlDescriptor;", "ENCODED_URL_DESCRIPTOR", "intellij.vcs.svn"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

