/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.change;

import com.intellij.openapi.vcs.VcsException;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.change.ChangeListClient;
import org.jetbrains.idea.svn.commandLine.CommandUtil;
import org.jetbrains.idea.svn.commandLine.SvnCommandName;

public class CmdChangeListClient
extends BaseSvnClient
implements ChangeListClient {
    @Override
    public void add(@NotNull String changeList, @NotNull File path, @Nullable String[] changeListsToOperate) throws VcsException {
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add(changeList);
        CommandUtil.put(parameters, path);
        CommandUtil.put(parameters, Depth.EMPTY);
        if (changeListsToOperate != null) {
            CommandUtil.putChangeLists(parameters, Arrays.asList(changeListsToOperate));
        }
        this.execute(this.myVcs, Target.on(path), SvnCommandName.changelist, parameters, null);
    }

    @Override
    public void remove(@NotNull File path) throws VcsException {
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add("--remove");
        CommandUtil.put(parameters, path);
        CommandUtil.put(parameters, Depth.EMPTY);
        this.execute(this.myVcs, Target.on(path), SvnCommandName.changelist, parameters, null);
    }
}

