/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.auth.AuthenticationService;
import org.jetbrains.idea.svn.commandLine.Command;
import org.jetbrains.idea.svn.commandLine.SvnBindException;

public abstract class AuthCallbackCase {
    protected final Url myUrl;
    @NotNull
    protected final AuthenticationService myAuthenticationService;

    AuthCallbackCase(@NotNull AuthenticationService authenticationService, Url url) {
        this.myAuthenticationService = authenticationService;
        this.myUrl = url;
    }

    public abstract boolean canHandle(String var1);

    abstract boolean getCredentials(String var1) throws SvnBindException;

    public void updateParameters(@NotNull Command command) {
    }

    protected Url parseUrl(String urlValue) {
        try {
            return SvnUtil.createUrl(urlValue);
        }
        catch (SvnBindException e) {
            return null;
        }
    }
}

