/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.ProgressTracker;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.commandLine.CommandUtil;
import org.jetbrains.idea.svn.commandLine.LineCommandListener;
import org.jetbrains.idea.svn.commandLine.SvnCommandName;
import org.jetbrains.idea.svn.properties.PropertyValue;

public class Command {
    @NotNull
    private final List<String> myParameters = ContainerUtil.newArrayList();
    @NotNull
    private final List<String> myOriginalParameters = ContainerUtil.newArrayList();
    @NotNull
    private final SvnCommandName myName;
    private File workingDirectory;
    @Nullable
    private File myConfigDir;
    @Nullable
    private LineCommandListener myResultBuilder;
    @Nullable
    private volatile Url myRepositoryUrl;
    @NotNull
    private Target myTarget;
    @Nullable
    private Collection<File> myTargets;
    @Nullable
    private PropertyValue myPropertyValue;
    @Nullable
    private ProgressTracker myCanceller;

    public Command(@NotNull SvnCommandName name) {
        this.myName = name;
    }

    public void put(@Nullable Depth depth) {
        CommandUtil.put(this.myParameters, depth, false);
    }

    public void put(@NotNull Target target) {
        CommandUtil.put(this.myParameters, target);
    }

    public void put(@Nullable Revision revision) {
        CommandUtil.put(this.myParameters, revision);
    }

    public void put(@NotNull String parameter, boolean condition) {
        CommandUtil.put(this.myParameters, condition, parameter);
    }

    public void put(String ... parameters) {
        this.put(Arrays.asList(parameters));
    }

    public void put(@NotNull List<String> parameters) {
        this.myParameters.addAll(parameters);
    }

    public void putIfNotPresent(@NotNull String parameter) {
        if (!this.myParameters.contains(parameter)) {
            this.myParameters.add(parameter);
        }
    }

    @Nullable
    public ProgressTracker getCanceller() {
        return this.myCanceller;
    }

    public void setCanceller(@Nullable ProgressTracker canceller) {
        this.myCanceller = canceller;
    }

    @Nullable
    public File getConfigDir() {
        return this.myConfigDir;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    @Nullable
    public LineCommandListener getResultBuilder() {
        return this.myResultBuilder;
    }

    @Nullable
    public Url getRepositoryUrl() {
        return this.myRepositoryUrl;
    }

    @NotNull
    public Url requireRepositoryUrl() {
        Url result = this.getRepositoryUrl();
        assert (result != null);
        return result;
    }

    @NotNull
    public Target getTarget() {
        return this.myTarget;
    }

    @Nullable
    public List<String> getTargetsPaths() {
        return ContainerUtil.isEmpty(this.myTargets) ? null : ContainerUtil.map(this.myTargets, file -> CommandUtil.format(file.getAbsolutePath(), null));
    }

    @Nullable
    public PropertyValue getPropertyValue() {
        return this.myPropertyValue;
    }

    @NotNull
    public SvnCommandName getName() {
        return this.myName;
    }

    public void setWorkingDirectory(File workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public void setConfigDir(@Nullable File configDir) {
        this.myConfigDir = configDir;
    }

    public void setResultBuilder(@Nullable LineCommandListener resultBuilder) {
        this.myResultBuilder = resultBuilder;
    }

    public void setRepositoryUrl(@Nullable Url repositoryUrl) {
        this.myRepositoryUrl = repositoryUrl;
    }

    public void setTarget(@NotNull Target target) {
        this.myTarget = target;
    }

    public void setTargets(@Nullable Collection<File> targets) {
        this.myTargets = targets;
    }

    public void setPropertyValue(@Nullable PropertyValue propertyValue) {
        this.myPropertyValue = propertyValue;
    }

    public void saveOriginalParameters() {
        this.myOriginalParameters.clear();
        this.myOriginalParameters.addAll(this.myParameters);
    }

    @NotNull
    public List<String> getParameters() {
        return ContainerUtil.newArrayList(this.myParameters);
    }

    public String getText() {
        ArrayList<String> data = new ArrayList<String>();
        if (this.myConfigDir != null) {
            data.add("--config-dir");
            data.add(this.myConfigDir.getPath());
        }
        data.add(this.myName.getName());
        data.addAll(this.myOriginalParameters);
        List<String> targetsPaths = this.getTargetsPaths();
        if (!ContainerUtil.isEmpty(targetsPaths)) {
            data.addAll(targetsPaths);
        }
        return StringUtil.join(data, (String)" ");
    }

    public boolean isLocalInfo() {
        return this.is(SvnCommandName.info) && this.hasLocalTarget() && !this.myParameters.contains("--revision");
    }

    public boolean isLocalStatus() {
        return this.is(SvnCommandName.st) && this.hasLocalTarget() && !this.myParameters.contains("-u");
    }

    public boolean isLocalProperty() {
        boolean isPropertyCommand = this.is(SvnCommandName.proplist) || this.is(SvnCommandName.propget) || this.is(SvnCommandName.propset) || this.is(SvnCommandName.propdel);
        return isPropertyCommand && this.hasLocalTarget() && Command.isLocal(this.getRevision());
    }

    public boolean isLocalCat() {
        return this.is(SvnCommandName.cat) && this.hasLocalTarget() && Command.isLocal(this.getRevision());
    }

    @Nullable
    private Revision getRevision() {
        int index = this.myParameters.indexOf("--revision");
        return index >= 0 && index + 1 < this.myParameters.size() ? Revision.parse(this.myParameters.get(index + 1)) : null;
    }

    public boolean is(@NotNull SvnCommandName name) {
        return name.equals((Object)this.myName);
    }

    private boolean hasLocalTarget() {
        return this.myTarget.isFile() && Command.isLocal(this.myTarget.getPegRevision());
    }

    private static boolean isLocal(@Nullable Revision revision) {
        return revision == null || Revision.UNDEFINED.equals(revision) || Revision.BASE.equals(revision) || Revision.WORKING.equals(revision);
    }
}

