/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.net.PasswordAuthentication;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.auth.AuthenticationService;
import org.jetbrains.idea.svn.commandLine.AuthCallbackCase;
import org.jetbrains.idea.svn.commandLine.Command;

public class ProxyCallback
extends AuthCallbackCase {
    private static final Logger LOG = Logger.getInstance(ProxyCallback.class);
    private static final String CANNOT_AUTHENTICATE_TO_PROXY = "Could not authenticate to proxy server";
    private static final String PROXY_AUTHENTICATION_FAILED = "Proxy authentication failed";
    private PasswordAuthentication myProxyAuthentication;

    ProxyCallback(@NotNull AuthenticationService authenticationService, Url url) {
        super(authenticationService, url);
    }

    @Override
    public boolean canHandle(String error) {
        return error.contains(CANNOT_AUTHENTICATE_TO_PROXY) || error.contains(PROXY_AUTHENTICATION_FAILED);
    }

    @Override
    boolean getCredentials(String errText) {
        boolean result = false;
        if (this.myUrl == null) {
            LOG.info("Proxy callback could handle error text, but repository url is null", new Throwable());
            result = true;
        } else if (this.myAuthenticationService.haveDataForTmpConfig()) {
            this.myProxyAuthentication = this.myAuthenticationService.getProxyAuthentication(this.myUrl);
            result = this.myProxyAuthentication != null;
        }
        return result;
    }

    @Override
    public void updateParameters(@NotNull Command command) {
        String proxyHostParameter = (String)ContainerUtil.find(command.getParameters(), s -> s.contains("http-proxy-port"));
        if (!StringUtil.isEmpty((String)proxyHostParameter) && this.myUrl != null && this.myProxyAuthentication != null) {
            String group = ProxyCallback.getHostGroup(proxyHostParameter);
            command.put("--config-option");
            command.put(String.format("servers:%s:http-proxy-username=%s", group, this.myProxyAuthentication.getUserName()));
            command.put("--config-option");
            command.put(String.format("servers:%s:http-proxy-password=%s", group, String.valueOf(this.myProxyAuthentication.getPassword())));
        }
    }

    @NotNull
    private static String getHostGroup(@NotNull String proxyHostParameter) {
        int start = proxyHostParameter.indexOf(":");
        int finish = proxyHostParameter.indexOf(":", start + 1);
        return proxyHostParameter.substring(start + 1, finish);
    }
}

