/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnConfigurationState;
import org.jetbrains.idea.svn.commandLine.BaseCommandRuntimeModule;
import org.jetbrains.idea.svn.commandLine.Command;
import org.jetbrains.idea.svn.commandLine.CommandRuntime;

public class SshTunnelRuntimeModule
extends BaseCommandRuntimeModule {
    public static final String DEFAULT_SSH_TUNNEL_VALUE = "$SVN_SSH ssh -q";

    public SshTunnelRuntimeModule(@NotNull CommandRuntime runtime) {
        super(runtime);
    }

    @Override
    public void onStart(@NotNull Command command) {
        if (!CommandRuntime.isLocal(command) && !SvnConfiguration.SshConnectionType.SUBVERSION_CONFIG.equals((Object)this.getState().sshConnectionType)) {
            command.put("--config-option", "config:tunnels:ssh=" + this.buildTunnelValue());
        }
    }

    @NotNull
    private SvnConfiguration getConfiguration() {
        return this.myRuntime.getVcs().getSvnConfiguration();
    }

    @NotNull
    private SvnConfigurationState getState() {
        return this.getConfiguration().getState();
    }

    @NotNull
    private String buildTunnelValue() {
        String sshPath = this.getState().sshExecutablePath;
        sshPath = !StringUtil.isEmpty((String)sshPath) ? sshPath : SshTunnelRuntimeModule.getExecutablePath(this.getConfiguration().getSshTunnelSetting());
        List parameters = CommandLineUtil.toCommandLine((String)sshPath, (List)this.buildTunnelCommandLine(sshPath).getParametersList().getParameters());
        parameters.set(0, FileUtil.toSystemIndependentName((String)sshPath));
        return StringUtil.join((Collection)parameters, (String)" ");
    }

    @NotNull
    private GeneralCommandLine buildTunnelCommandLine(@NotNull String sshPath) {
        GeneralCommandLine result = new GeneralCommandLine(new String[]{sshPath});
        boolean isPuttyLinkClient = StringUtil.endsWithIgnoreCase((String)FileUtil.getNameWithoutExtension((String)sshPath), (String)"plink");
        SvnConfigurationState state = this.getState();
        if (!isPuttyLinkClient) {
            result.addParameter("-q");
        }
        result.addParameters(new String[]{isPuttyLinkClient ? "-P" : "-p", String.valueOf(state.sshPort)});
        if (!StringUtil.isEmpty((String)state.sshUserName)) {
            result.addParameters(new String[]{"-l", state.sshUserName});
        }
        if (SvnConfiguration.SshConnectionType.PRIVATE_KEY.equals((Object)state.sshConnectionType) && !StringUtil.isEmpty((String)state.sshPrivateKeyPath)) {
            result.addParameters(new String[]{"-i", FileUtil.toSystemIndependentName((String)state.sshPrivateKeyPath)});
        }
        return result;
    }

    @NotNull
    public static String getSshTunnelValue(@Nullable String tunnelSetting) {
        String svnSshVariableName = SshTunnelRuntimeModule.getSvnSshVariableName(tunnelSetting = !StringUtil.isEmpty((String)tunnelSetting) ? tunnelSetting : DEFAULT_SSH_TUNNEL_VALUE);
        String svnSshVariableValue = EnvironmentUtil.getValue((String)svnSshVariableName);
        return !StringUtil.isEmpty((String)svnSshVariableValue) ? svnSshVariableValue : (!StringUtil.isEmpty((String)svnSshVariableName) ? tunnelSetting.substring(1 + svnSshVariableName.length()) : tunnelSetting);
    }

    @NotNull
    public static String getSvnSshVariableName(@Nullable String tunnel) {
        return tunnel != null && tunnel.startsWith("$") ? ((String)ObjectUtils.notNull((Object)StringUtil.substringBefore((String)tunnel, (String)" "), (Object)tunnel)).substring(1) : "";
    }

    @NotNull
    public static String getExecutablePath(@Nullable String tunnelSetting) {
        return StringUtil.notNullize((String)((String)ContainerUtil.getFirstItem((List)ParametersListUtil.parse((String)SshTunnelRuntimeModule.getSshTunnelValue(tunnelSetting))))).trim();
    }
}

