/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import com.intellij.openapi.util.Key;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.auth.AcceptResult;
import org.jetbrains.idea.svn.commandLine.BaseTerminalModule;
import org.jetbrains.idea.svn.commandLine.CommandExecutor;
import org.jetbrains.idea.svn.commandLine.CommandRuntime;

public class TerminalSslCertificateModule
extends BaseTerminalModule {
    private static final Pattern ERROR_VALIDATING_CERTIFICATE_MESSAGE = Pattern.compile("Error validating server certificate for \\'(.*)\\':\\s?");
    private static final Pattern CERTIFICATE_INFORMATION_MESSAGE = Pattern.compile("Certificate information:\\s?");
    private static final Pattern ACCEPT_CERTIFICATE_PROMPT = Pattern.compile("\\(R\\)eject.*\\?\\s?");
    @NotNull
    private final StringBuilder certificateError = new StringBuilder();
    @NotNull
    private final StringBuilder certificateInfo = new StringBuilder();
    private boolean collectingCertificateError;
    private boolean collectingCertificateInfo;
    private String serverUrl;

    public TerminalSslCertificateModule(@NotNull CommandRuntime runtime, @NotNull CommandExecutor executor) {
        super(runtime, executor);
    }

    @Override
    public boolean doHandlePrompt(String line, Key outputType) {
        return this.checkCertificate(line);
    }

    private boolean checkCertificate(String line) {
        Matcher certificateErrorMatcher = ERROR_VALIDATING_CERTIFICATE_MESSAGE.matcher(line);
        Matcher certificateInfoMatcher = CERTIFICATE_INFORMATION_MESSAGE.matcher(line);
        Matcher acceptCertificateMatcher = ACCEPT_CERTIFICATE_PROMPT.matcher(line);
        if (certificateErrorMatcher.matches()) {
            this.serverUrl = certificateErrorMatcher.group(1);
            this.setCollectingMode(false, true);
        } else if (certificateInfoMatcher.matches()) {
            this.setCollectingMode(true, false);
        } else if (acceptCertificateMatcher.matches()) {
            this.setCollectingMode(false, false);
            this.handleAcceptCertificatePrompt();
        } else if (this.collectingCertificateError) {
            this.certificateError.append(line);
        } else if (this.collectingCertificateInfo) {
            this.certificateInfo.append(line);
        }
        return certificateErrorMatcher.matches() || certificateInfoMatcher.matches() || acceptCertificateMatcher.matches() || this.collectingCertificateError || this.collectingCertificateInfo;
    }

    private void setCollectingMode(boolean collectInfo, boolean collectError) {
        this.collectingCertificateInfo = collectInfo;
        this.collectingCertificateError = collectError;
        if (this.collectingCertificateInfo) {
            this.certificateInfo.setLength(0);
        }
        if (this.collectingCertificateError) {
            this.certificateError.setLength(0);
        }
    }

    private void handleAcceptCertificatePrompt() {
        Url url = SvnUtil.parseUrl(this.serverUrl);
        AcceptResult result = this.myRuntime.getAuthenticationService().acceptCertificate(url, this.certificateInfo.toString());
        this.sendData(result.toString());
    }
}

